/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.entry.RtWorkflow;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.entry.application.RuntimePredictionMode;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class PPExportBreezeRuntimeTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setMockInstance() {
        BreezeProperties.getInstance().setTestingInstance(new BreezeProperties.MockBreezeProperties(this){

            @Override
            public String getBreezeRuntimeHost() {
                return "localhost";
            }
        });
    }

    @After
    public void resetMockInstance() {
        BreezeProperties.clearInstance();
    }

    @Test
    public void testExportRuntime() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        File file = new File(this.tempFolder.getRoot(), "breeze.xml");
        PPExportBreezeRuntime.export(BreezeProgressImpl.createEmpty(), workflowWithoutIO, "test", "description", file, -1, PPExportBreezeRuntime.ObjectProcessing.Sequential, false);
        RtWorkflow rtWorkflow = new RtWorkflow(file);
        MatcherAssert.assertThat((Object)rtWorkflow.getName(), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)rtWorkflow.getDescription(), (Matcher)Matchers.is((Object)"description"));
        RtPredictionMode rtPredictionMode = rtWorkflow.getPredictionMode();
        MatcherAssert.assertThat((Object)((Object)rtPredictionMode.getMode()), (Matcher)Matchers.is((Object)((Object)RtPredictionMode.PredictionMode.Normal)));
        RtPredictionMode.NormalModeSetup normalModeSetup = (RtPredictionMode.NormalModeSetup)rtPredictionMode.getPredictionSetup();
        MatcherAssert.assertThat((Object)normalModeSetup.getChunks(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testExportRuntimeCustomMode() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        RuntimePredictionMode.updatePredictionNode(workflowWithoutIO, RtPredictionMode.PredictionMode.ObjectToPixelsPipeline, (RtPredictionMode.PredictionModeSetup)new RtPredictionMode.PixelToObjectModeSetup(20, 2));
        File file = new File(this.tempFolder.getRoot(), "breeze.xml");
        PPExportBreezeRuntime.export(BreezeProgressImpl.createEmpty(), workflowWithoutIO, "test", "description", file, -1, PPExportBreezeRuntime.ObjectProcessing.Sequential, false);
        RtWorkflow rtWorkflow = new RtWorkflow(file);
        MatcherAssert.assertThat((Object)rtWorkflow.getName(), (Matcher)Matchers.is((Object)"test"));
        MatcherAssert.assertThat((Object)rtWorkflow.getDescription(), (Matcher)Matchers.is((Object)"description"));
        MatcherAssert.assertThat((Object)rtWorkflow.getSourceVersion(), (Matcher)Matchers.is((Object)InitClass.getBreezeVersion().format(false)));
        RtPredictionMode rtPredictionMode = rtWorkflow.getPredictionMode();
        MatcherAssert.assertThat((Object)((Object)rtPredictionMode.getMode()), (Matcher)Matchers.is((Object)((Object)RtPredictionMode.PredictionMode.ObjectToPixelsPipeline)));
        RtPredictionMode.PixelToObjectModeSetup pixelToObjectModeSetup = (RtPredictionMode.PixelToObjectModeSetup)rtPredictionMode.getPredictionSetup();
        MatcherAssert.assertThat((Object)pixelToObjectModeSetup.getBufferSize(), (Matcher)Matchers.is((Object)20));
        MatcherAssert.assertThat((Object)pixelToObjectModeSetup.getChunks(), (Matcher)Matchers.is((Object)5));
        MatcherAssert.assertThat((Object)pixelToObjectModeSetup.getLineBinning(), (Matcher)Matchers.is((Object)2));
    }
}

