/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportProperties;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.WizardComponents;
import se.prediktera.breeze.frontend.common.report.CsvEndMembersReportCreator;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;

public class PPExportEndMembers
extends AbstractWizardPanel.AbstractExportWizard {
    private final String defaultName;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final PPExportSegmentation.SegmentationIdInputField segComboBox = new PPExportSegmentation.SegmentationIdInputField();
    private final FileInputField.FolderInputField folderInputField;
    private final FileInputField fileInputField;
    private final WizardComponents.ExportInputField<String> typeComboBox = new WizardComponents.ExportInputField("Type");
    private final WizardComponents.ExportInputField nameComboBox = new WizardComponents.ExportInputField("Name");
    private final WizardComponents.ExportTextField delimiterInputField = new WizardComponents.ExportTextField("csvDelimiter", "Delimiter", ";");
    private final WizardComponents.ExportOptionCheckBox shouldMergeCheckBox = new PPExportProperties.MergeDepthCheckBox();
    private final WizardComponents.ExportOptionCheckBox openExplorerCheckBox = new WizardComponents.OpenInExplorerCheckBox();

    public PPExportEndMembers(EntryMainPanel entryMainPanel, String string2, Object object2) {
        super(entryMainPanel, entryMainPanel.getPageType(), string2, object2);
        Workflow workflow = Workflow.getWorkflow(object2);
        File file = new File(((Entry)object2).getFolder(), "Export");
        file.mkdir();
        this.defaultName = ((Entry)object2).getName() + "_endmembers.csv";
        String string3 = new File(file, this.defaultName).getAbsolutePath();
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Provide settings for exporting endmembers for use in Constrained Spectral Unmixing. Press Finish to perform the export.");
        this.segmentationComboBox.setChangedListener(object -> this.segComboBox.setVisible(this.segComboBox.init(this.segmentationComboBox.getSelectedItem())));
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.setUnit(" ");
        this.segmentationComboBox.setUnitLabelWidth(100);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        this.segmentationComboBox.setChangedListener(object -> this.shouldMergeCheckBox.setVisible(this.segmentationComboBox.shouldOfferMergeIntervalChoice()));
        this.segmentationComboBox.init(Workflow.getWorkflow(object2));
        pPDescriptionPanel.addOption(this.shouldMergeCheckBox);
        this.segComboBox.setLabelWidth(120);
        this.segComboBox.setUnit(" ");
        this.segComboBox.setUnitLabelWidth(100);
        pPDescriptionPanel.addOption(this.segComboBox);
        this.fileInputField = new FileInputField(this, "Select file", string3);
        this.fileInputField.getInputField().setLabelWidth(120);
        this.folderInputField = new FileInputField.FolderInputField((Component)this, "Select folder", file);
        this.folderInputField.getInputField().setLabelWidth(120);
        this.folderInputField.setVisible(false);
        this.typeComboBox.setUnit(" ");
        this.typeComboBox.setUnitLabelWidth(100);
        this.typeComboBox.addItem("All in one file");
        this.typeComboBox.addItem("Separate files");
        this.typeComboBox.getComboBox().setName("typeFile");
        this.typeComboBox.setChangedListener(string -> {
            boolean bl = string.equals("All in one file");
            this.folderInputField.setVisible(!bl);
            this.fileInputField.setVisible(bl);
        });
        pPDescriptionPanel.addOption(this.typeComboBox);
        pPDescriptionPanel.addOption(this.folderInputField);
        pPDescriptionPanel.addOption(this.fileInputField);
        this.nameComboBox.setUnit(" ");
        this.nameComboBox.setUnitLabelWidth(100);
        this.nameComboBox.addItem("Default");
        if (workflow.getIdentifiers().size() > 0) {
            this.nameComboBox.addSeparator();
            for (ThingWithName thingWithName : workflow.getIdentifiers()) {
                this.nameComboBox.addItem(thingWithName);
            }
        }
        if (workflow.getCategoryFactors().size() > 0) {
            this.nameComboBox.addSeparator();
            for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
                this.nameComboBox.addItem(thingWithName);
            }
        }
        pPDescriptionPanel.addOption(this.nameComboBox);
        pPDescriptionPanel.addOptionNoFill(this.delimiterInputField);
        pPDescriptionPanel.addSeparator("Options");
        pPDescriptionPanel.addOptionIndent(this.openExplorerCheckBox);
        this.viewClassList.add(new ViewClass("Settings", "Setting for exporting End Members to file", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    protected void finishWizard() {
        File file;
        File file2;
        final CsvEndMembersReportCreator.EndMemberType endMemberType = ((String)this.typeComboBox.getSelectedItem()).equals("All in one file") ? CsvEndMembersReportCreator.EndMemberType.AllVertical : CsvEndMembersReportCreator.EndMemberType.Vertical;
        final boolean bl = endMemberType == CsvEndMembersReportCreator.EndMemberType.AllVertical;
        File file3 = file2 = bl ? this.fileInputField.getFile() : this.folderInputField.getFile();
        if (file2 != null) {
            if (file2.isDirectory()) {
                file2.mkdirs();
                if (bl) {
                    file2 = new File(file2, this.defaultName);
                }
            } else {
                file2.getParentFile().mkdirs();
            }
        }
        if ((file = file2) != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportEndMembers this$0;
                {
                    this.this$0 = pPExportEndMembers;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(bl ? file.getParentFile() : file);
                    }
                }

                @Override
                public void runAction() throws IOException {
                    this.setInfoText("Exporting End Members to CSV file(s)");
                    CsvEndMembersReportCreator.createEndMembers(file, Measurement.getMeasurements(this.this$0.mainPanel.getSelectedEntries()), this.this$0.delimiterInputField.getValue(), this.this$0.segComboBox.getUids(), endMemberType, this.this$0.nameComboBox.getSelectedItem(), this.this$0.shouldMergeCheckBox.isVisibleAndSelected(), this.this$0.segComboBox.getSelectedItem());
                    this.this$0.delimiterInputField.store();
                    this.this$0.shouldMergeCheckBox.store();
                    this.this$0.openExplorerCheckBox.store();
                }
            }, "Export values");
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Group members to End Member format for unmixing descriptor";
        }

        @Override
        public String getName() {
            return "End Member";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportEndMembers(entryMainPanel, string, object);
        }
    }
}

