/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;

public class PPExportGroup
extends AbstractWizardPanel.AbstractExportWizard {
    public static final String ArchiveDescription = "Archive with group measurements";
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportGroup(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, ArchiveDescription);
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getDataPath(), PPExportHtml.createDefaultExportFileName(Group.getGroup(object), "zip", true));
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Press Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export Group", pPDescriptionPanel));
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        pPDescriptionPanel.addBottomOption(new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, Group.getGroup(object).formatNumberGroupsAndMeasurements() + " will be exported"));
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportGroup this$0;
                {
                    this.this$0 = pPExportGroup;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file.getParentFile());
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting group with measurements");
                    ZipManager zipManager = new ZipManager(file);
                    for (Object t : this.this$0.mainPanel.getSelectedEntries()) {
                        zipManager.addFolder(Group.getGroup(t).getFolder(), null);
                    }
                    zipManager.perform(this.getProgressManager());
                }
            }, "Export group");
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Selected groups with recorded measurements";
        }

        @Override
        public String getName() {
            return "Groups";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportGroup(entryMainPanel, string, object);
        }
    }
}

