/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Desktop;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;

public class PPExportHtml
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final PPExportSegmentation.SegmentationIdInputField segmentationIdInputField = new PPExportSegmentation.SegmentationIdInputField();
    private final BreezeCheckBox shouldMergeCheckBox = new BreezeCheckBox("Depth Interval: Merge samples from same interval", true);
    private final BreezeCheckBox showBrowserCheckBox;
    private BreezeCheckBox disableJavaScript;

    public PPExportHtml(EntryMainPanel entryMainPanel, String string, Object object2) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object2);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        this.fileSelectionPanel.addExtension(new String[]{"html"}, "Html data format");
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = PPExportHtml.createDefaultExportFile((Entry)object2, "html");
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Setting for export html. Press Finish to complete export");
        this.segmentationComboBox.setChangedListener(object -> this.segmentationIdInputField.setVisible(this.segmentationIdInputField.init(this.segmentationComboBox.getSelectedItem())));
        this.segmentationComboBox.setLabelWidth(120);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        this.segmentationComboBox.setChangedListener(object -> this.shouldMergeCheckBox.setVisible(this.segmentationComboBox.shouldOfferMergeIntervalChoice()));
        Workflow workflow = Workflow.getWorkflow(object2);
        this.segmentationComboBox.init(workflow);
        pPDescriptionPanel.addOption(this.shouldMergeCheckBox);
        this.segmentationIdInputField.setLabelWidth(120);
        this.segmentationIdInputField.setUnit(" ");
        this.segmentationIdInputField.setUnitLabelWidth(100);
        this.segmentationIdInputField.setDefault(workflow);
        pPDescriptionPanel.addOption(this.segmentationIdInputField);
        pPDescriptionPanel.addSeparator("Options");
        this.showBrowserCheckBox = new BreezeCheckBox("Show html report in browser", true);
        pPDescriptionPanel.addOptionIndent(this.showBrowserCheckBox);
        this.showBrowserCheckBox.setName("showbrowser");
        this.disableJavaScript = new BreezeCheckBox("Disable JavaScript in export", false);
        pPDescriptionPanel.addOptionIndent(this.disableJavaScript);
        this.disableJavaScript.setName("noJs");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export html", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected boolean shouldShowToasterWhenFinished() {
        return !this.showBrowserCheckBox.isSelected();
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            AbstractWizardPanel.WizardProgressAction wizardProgressAction = new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportHtml this$0;
                {
                    this.this$0 = pPExportHtml;
                    super(abstractWizardPanel);
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting to HTML file");
                    try {
                        FreemarkerReportCreator.createReport(this.getProgressManager(), file, Measurement.getMeasurements(this.this$0.entryData), new SegmentationIdentifier(this.this$0.segmentationComboBox.getSegmentationLevel(), this.this$0.segmentationIdInputField.getSegmentationHashId()), this.this$0.shouldMergeCheckBox.isVisibleAndSelected(), this.this$0.disableJavaScript.isSelected());
                        if (this.this$0.showBrowserCheckBox != null && this.this$0.showBrowserCheckBox.isSelected()) {
                            Desktop.getDesktop().browse(file.toURI());
                            Thread.sleep(500L);
                        }
                    }
                    catch (BreezeProgress.ProgressActionCancelledException progressActionCancelledException) {
                        // empty catch block
                    }
                }
            };
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), wizardProgressAction, "Export html file");
        }
    }

    public static File createDefaultExportFile(Entry entry, String string) {
        return PPExportHtml.createDefaultExportFile(new File(entry.getFolder(), "Export"), entry, string);
    }

    public static File createDefaultExportFile(File file, Entry entry, String string) {
        return new File(file, PPExportHtml.createDefaultExportFileName(entry, string));
    }

    public static String createDefaultExportFileName(Entry entry, String string) {
        return PPExportHtml.createDefaultExportFileName(entry, string, false);
    }

    private static String getName(Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        Workflow workflow = Workflow.getWorkflow(entry);
        if (workflow != null) {
            stringBuilder.append(workflow.getName());
        }
        if (entry instanceof Workflow) {
            return stringBuilder.toString();
        }
        stringBuilder.append("_");
        Group group = Group.getGroup(entry);
        if (group != null) {
            stringBuilder.append(group.getName());
        }
        if (entry instanceof Group) {
            return stringBuilder.toString();
        }
        stringBuilder.append("_");
        stringBuilder.append(entry.getName());
        return stringBuilder.toString();
    }

    public static String createDefaultExportFileName(Entry entry, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(PPExportHtml.getName(entry));
        if (bl) {
            stringBuilder.append("_");
            stringBuilder.append(new SimpleDateFormat("yyyy-MM-dd_HH_mm").format(new Date()));
            stringBuilder.append("_");
            stringBuilder.append((Object)entry.getEntryType());
        }
        stringBuilder.append(".");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Table data with thumbnails to html report";
        }

        @Override
        public String getName() {
            return "Html report";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportHtml(entryMainPanel, string, object);
        }
    }
}

