/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportWorkflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;

public class PPExportModel
extends AbstractWizardPanel.AbstractExportWizard {
    public static final String ArchiveDescription = "Archive model";
    public static final String OnnxDescription = "ONNX model";
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportModel(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, ArchiveDescription);
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getDataPath(), PPExportHtml.createDefaultExportFileName((Entry)object, "zip", true));
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Press Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export model", pPDescriptionPanel));
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportModel this$0;
                {
                    this.this$0 = pPExportModel;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file.getParentFile());
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting model");
                    PPExportModel.export(this.getProgressManager(), (Analyse)this.this$0.entryData, file);
                }
            }, "Export model");
        }
    }

    private static void export(BreezeProgress breezeProgress, Analyse analyse, File file) {
        ZipManager zipManager = new ZipManager(file);
        PPExportWorkflow.addModel(true, zipManager, analyse);
        zipManager.perform(breezeProgress);
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Model folder to zip file";
        }

        @Override
        public String getName() {
            return "Model";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportModel(entryMainPanel, string, object);
        }
    }
}

