/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.model.AbstractModel;

public class PPExportModelDataParameters
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportModelDataParameters(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select folder for model parameters export and press Finish", true);
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(1);
        Analyse analyse = (Analyse)object;
        File file = new File(analyse.getFolder(), "Export");
        file.mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file);
        this.viewClassList.add(new ViewClass("Select folder", "Select export folder", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Press Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export", pPDescriptionPanel));
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportModelDataParameters this$0;
                {
                    this.this$0 = pPExportModelDataParameters;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file);
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting model data");
                    Analyse analyse = (Analyse)this.this$0.entryData;
                    AbstractModel abstractModel = analyse.getBaseModel(this.getProgressManager());
                    this.saveMatrix(file, abstractModel.getMatrixByName("Ycalc"));
                    this.saveMatrix(file, abstractModel.getMatrixByName("YcalcCV"));
                }

                private void saveMatrix(File file2, AbstractDataMatrix abstractDataMatrix) {
                    if (abstractDataMatrix instanceof MatrixContainer) {
                        MatrixContainer matrixContainer = (MatrixContainer)abstractDataMatrix;
                        matrixContainer.getLastAbstractMatrix().save((ProgressManager)this.getProgressManager(), new File(file2, abstractDataMatrix.getName() + ".csv").getAbsolutePath(), "csv");
                    }
                }
            }, "Export model data");
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Ycalc and YcalcCV (require full crossvalidation)";
        }

        @Override
        public String getName() {
            return "Ycalc";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportModelDataParameters(entryMainPanel, string, object);
        }
    }
}

