/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.EvinceModelParameters;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.datasetcontainer.matrix.MVmatrix;
import se.prediktera.map.model.AbstractModel;

public class PPExportModelParameters
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportModelParameters(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select folder for model parameters export and press Finish", true);
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(1);
        Analyse analyse = (Analyse)object;
        File file = new File(analyse.getFolder(), "Export");
        file.mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file);
        this.viewClassList.add(new ViewClass("Model parameters", "Select export folder", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Press Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export", pPDescriptionPanel));
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportModelParameters this$0;
                {
                    this.this$0 = pPExportModelParameters;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file);
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting model parameters");
                    Analyse analyse = (Analyse)this.this$0.entryData;
                    AbstractModel abstractModel = analyse.getBaseModel(this.getProgressManager());
                    FloatMatrix floatMatrix = EvinceModelParameters.calculateBprim(abstractModel);
                    if (floatMatrix != null) {
                        this.createMvmatrix(floatMatrix.transpose()).save((ProgressManager)this.getProgressManager(), new File(file, "B.csv").getAbsolutePath(), "csv");
                    }
                    AbstractDataMatrix abstractDataMatrix = abstractModel.getMatrixByName("Xres");
                    this.saveTransformation(file, abstractDataMatrix, "Center", "Mean values of X");
                    this.saveTransformation(file, abstractDataMatrix, "UV Scale", "1 div (standard deviation of X)");
                    AbstractDataMatrix abstractDataMatrix2 = abstractModel.getMatrixByName("Yres");
                    if (abstractDataMatrix2 != null) {
                        this.saveTransformation(file, abstractDataMatrix2, "Center", "Mean values of Y");
                        this.saveTransformation(file, abstractDataMatrix2, "UV Scale", "1 div (standard deviation of Y)");
                    }
                    if (BreezeFrame.development) {
                        File file2 = new File(file, analyse.getName() + ".html");
                        FreemarkerReportCreator.createReport(this.getProgressManager(), file2, analyse);
                    }
                }

                private MVmatrix createMvmatrix(FloatMatrix floatMatrix) {
                    MVmatrix mVmatrix = new MVmatrix(floatMatrix.rows, floatMatrix.columns);
                    for (int i = 0; i < floatMatrix.columns; ++i) {
                        for (int j = 0; j < floatMatrix.rows; ++j) {
                            mVmatrix.setValue(j, i, (double)floatMatrix.get(j, i));
                        }
                    }
                    return mVmatrix;
                }

                private void saveTransformation(File file2, AbstractDataMatrix abstractDataMatrix, String string, String string2) {
                    DataTreeInterface dataTreeInterface = abstractDataMatrix.getNodeByName(string);
                    if (dataTreeInterface != null && dataTreeInterface.getTreeNodeCount() >= 2) {
                        AbstractDataMatrix abstractDataMatrix2 = (AbstractDataMatrix)dataTreeInterface.getTreeNodeAt(1);
                        abstractDataMatrix2.save((ProgressManager)this.getProgressManager(), new File(file2, string2 + ".csv").getAbsolutePath(), "csv");
                    }
                }
            }, "Export model parameters");
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Model parameters (transformations and pls-weights)";
        }

        @Override
        public String getName() {
            return "Model parameters";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportModelParameters(entryMainPanel, string, object);
        }
    }
}

