/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyseList;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.segmentation.SampleImageMask;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.CachedRawFile;
import se.prediktera.breeze.common.util.raw.QgisLauncher;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.AnalyseList;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.WizardComponents;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorPanel;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.mat.MatExport;

public class PPExportPredictedSegmentation
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final WizardComponents.ExportInputField<PPExportSegmentation.OutputData> dataInputField = new WizardComponents.ExportInputField("Visualization");
    private final WizardComponents.ExportInputField<ExportScope> exportScopeComboBox = new WizardComponents.ExportInputField("Scope");
    private final WizardComponents.ExportInputField<BasicAnalyse> analyseComboBox = new WizardComponents.ExportInputField("Analysis");
    private final WizardComponents.ExportInputField<PropertyFactor> propertyComboBox = new WizardComponents.ExportInputField("Property");
    private final WizardComponents.ExportInputField<DescriptorTreeNode> nodeComboBox = new WizardComponents.ExportInputField("Descriptor");
    private final WizardComponents.ExportInputField<PPExportSegmentation.OutputFormat> formatInputField = new WizardComponents.ExportInputField("File format");
    private final BreezeLabel objectProcessingLabel = new BreezeLabel("Objects identified by the segmentation can be exported as separate files, or per measurement image:");
    private final WizardComponents.ExportOptionCheckBox keepOriginalSizeCheckBox = new WizardComponents.KeepOriginalSizeCheckBox();
    private final WizardComponents.ExportOptionCheckBox mergeSamplesCheckBox = new WizardComponents.MergeSamplesCheckBox();
    private final WizardComponents.ExportOptionCheckBox createFoldersCheckBox = new WizardComponents.CreateFoldersCheckBox();
    private final WizardComponents.ExportOptionCheckBox openInEvinceCheckBox = new WizardComponents.OpenInEvinceCheckBox();
    private final WizardComponents.ExportOptionCheckBox openInQgisCheckBox = new WizardComponents.OpenInQgisCheckBox();
    private final WizardComponents.OpenInExplorerCheckBox openExplorerCheckBox = new WizardComponents.OpenInExplorerCheckBox();

    public PPExportPredictedSegmentation(EntryMainPanel entryMainPanel, String string, Object object2) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object2);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select folder to export to, and press Next", false);
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(1);
        File file = new File(((Entry)object2).getFolder(), "Export");
        file.mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file);
        this.viewClassList.add(new ViewClass("Export folder", "Select folder to export to", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Select segmentation, what data to export, and the file format. Press Finish to complete export");
        Workflow workflow = Workflow.getWorkflow(object2);
        Objects.requireNonNull(workflow, "No workflow found");
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.setChangedListener(object -> {
            boolean bl = this.segmentationComboBox.getSegmentationLevel() > 0;
            this.objectProcessingLabel.setVisible(bl);
            this.mergeSamplesCheckBox.setVisible(bl);
            this.keepOriginalSizeCheckBox.setVisible(bl);
            this.nodeComboBox.setList(this.segmentationComboBox.getSelectedNodes(workflow, true));
        });
        this.segmentationComboBox.init(workflow);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        pPDescriptionPanel.addOption(this.objectProcessingLabel);
        pPDescriptionPanel.addOptionIndent(this.mergeSamplesCheckBox);
        pPDescriptionPanel.addOptionIndent(this.keepOriginalSizeCheckBox);
        pPDescriptionPanel.addOption(this.dataInputField);
        this.dataInputField.setChangedListener(outputData -> this.dataInputChanged(workflow));
        this.nodeComboBox.setRenderer(new EditDescriptorPanel.DescriptorListCellRenderer());
        pPDescriptionPanel.addOption(this.nodeComboBox);
        this.exportScopeComboBox.getComboBox().setName("exportScope");
        this.exportScopeComboBox.addItems((ExportScope[])ExportScope.values());
        this.exportScopeComboBox.setChangedListener(exportScope -> this.scopeChanged(workflow));
        pPDescriptionPanel.addOption(this.exportScopeComboBox);
        this.analyseComboBox.setChangedListener(basicAnalyse -> {
            BasicAnalyse basicAnalyse2 = (BasicAnalyse)this.analyseComboBox.getValue();
            this.propertyComboBox.removeAllItems();
            if (basicAnalyse2 != null) {
                basicAnalyse2.getPropertyFactors().forEach(this.propertyComboBox::addItem);
            }
        });
        this.analyseComboBox.getComboBox().setName("exportAnalyse");
        this.analyseComboBox.setVisible(false);
        pPDescriptionPanel.addOption(this.analyseComboBox);
        this.propertyComboBox.getComboBox().setName("exportProperty");
        this.propertyComboBox.setVisible(false);
        pPDescriptionPanel.addOption(this.propertyComboBox);
        this.formatInputField.addItem(PPExportSegmentation.OutputFormat.Envi);
        this.formatInputField.addItem(PPExportSegmentation.OutputFormat.Matlab);
        this.dataInputField.addItem(PPExportSegmentation.OutputData.Pixels);
        this.dataInputField.addItem(PPExportSegmentation.OutputData.Sample);
        this.dataInputField.selectAndRemember(PPExportSegmentation.OutputData.Pixels);
        pPDescriptionPanel.addSeparator("Output file options");
        pPDescriptionPanel.addOption(this.formatInputField);
        pPDescriptionPanel.addOptionIndent(this.createFoldersCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openInEvinceCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openInQgisCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openExplorerCheckBox);
        pPDescriptionPanel.addBottomOption(new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, ((Entry)object2).formatNumberGroupsAndMeasurements() + " will be exported"));
        this.viewClassList.add(new ViewClass("What to export", "Settings for export predicted pixel data", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    private void dataInputChanged(Workflow workflow) {
        if (((PPExportSegmentation.OutputData)((Object)this.dataInputField.getSelectedItem())).equals((Object)PPExportSegmentation.OutputData.Pixels)) {
            this.scopeChanged(workflow);
            this.exportScopeComboBox.setVisible(true);
            this.nodeComboBox.setVisible(false);
        } else {
            this.analyseComboBox.setVisible(false);
            this.propertyComboBox.setVisible(false);
            this.exportScopeComboBox.setVisible(false);
            this.nodeComboBox.setVisible(true);
        }
        super.enabledNextButton(this.canFinish());
    }

    private void scopeChanged(Workflow workflow) {
        boolean bl = ExportScope.SingleClassification == this.exportScopeComboBox.getValue();
        boolean bl2 = ExportScope.SingleQuantification == this.exportScopeComboBox.getValue();
        this.analyseComboBox.removeAllItems();
        for (BasicAnalyse basicAnalyse : workflow.getConnectedAnalysis(false)) {
            if (bl && !basicAnalyse.getCategoryFactors().isEmpty()) {
                this.analyseComboBox.addItem(basicAnalyse);
                continue;
            }
            if (!bl2 || basicAnalyse.getPropertyFactors().isEmpty()) continue;
            this.analyseComboBox.addItem(basicAnalyse);
        }
        this.analyseComboBox.setVisible(bl || bl2);
        this.propertyComboBox.setVisible(bl2);
        this.formatInputField.removeAllItems();
        switch (((ExportScope)((Object)this.exportScopeComboBox.getValue())).ordinal()) {
            case 0: {
                this.formatInputField.addItem(PPExportSegmentation.OutputFormat.Envi);
                this.formatInputField.addItem(PPExportSegmentation.OutputFormat.Matlab);
                break;
            }
            case 1: {
                this.formatInputField.addItem(PPExportSegmentation.OutputFormat.EnviClassificationImage);
                break;
            }
            case 2: {
                this.formatInputField.addItem(PPExportSegmentation.OutputFormat.Envi);
            }
        }
        super.enabledNextButton(this.canFinish());
    }

    private boolean canFinish() {
        if (((PPExportSegmentation.OutputData)((Object)this.dataInputField.getSelectedItem())).equals((Object)PPExportSegmentation.OutputData.Pixels)) {
            return switch (((ExportScope)((Object)this.exportScopeComboBox.getValue())).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> this.analyseComboBox.hasValue();
                case 2 -> this.analyseComboBox.hasValue() && this.propertyComboBox.hasValue();
            };
        }
        return this.nodeComboBox.hasValue();
    }

    @Override
    public void enterStep(int n) {
        super.enterStep(n);
        if (n == 1) {
            this.openExplorerCheckBox.setFolder(this.fileSelectionPanel.approveSelectionAndGetSelectedFolder());
        }
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFolder();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                private List<File> folders;
                final /* synthetic */ PPExportPredictedSegmentation this$0;
                {
                    this.this$0 = pPExportPredictedSegmentation;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openInEvinceCheckBox.isSelected() && this.folders != null) {
                        EvinceHelper.startEvince(this.folders, this.createImportTemplate());
                    }
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file);
                    }
                }

                private String createImportTemplate() {
                    return "createTable('viewdataset',dataset);plot=createPlot('contour2d',dataset.get('xtraining'),{'fold=true'});plot.setTitle('Breeze Prediction ($range)');plot.setDataRange('range', 'matrix', 2);plot.setColor('amplitude',{'min=0','max=100','colorscheme=" + String.valueOf(this.this$0.mainPanel.getColorScale()) + "'});plot.addLegend('color','right',{'title=$range'});";
                }

                @Override
                public void runAction() {
                    if (!this.this$0.canFinish()) {
                        throw new RuntimeException("Provide all settings before finishing");
                    }
                    this.setInfoText("Exporting " + new Info().getName() + "...");
                    BasicAnalyse basicAnalyse = this.getAnalyse();
                    Factor factor = this.getFactor(basicAnalyse);
                    this.folders = new ExportPredictedSegmentations(file, (BasicAnalyse)this.this$0.analyseComboBox.getValue(), factor, (DescriptorTreeNode)this.this$0.nodeComboBox.getSelectedItem()).perform(this.getProgressManager(), Measurement.getMeasurements(this.this$0.entryData), this.getFormat(basicAnalyse), (PPExportSegmentation.OutputData)((Object)this.this$0.dataInputField.getSelectedItem()), RtFramePredictor.ReferenceConvertTo.None, this.this$0.segmentationComboBox.getSelectedIndex(), null, 5, this.this$0.keepOriginalSizeCheckBox.isSelected(), this.this$0.mergeSamplesCheckBox.isSelected(), this.this$0.createFoldersCheckBox.isSelected());
                    if (this.this$0.openInQgisCheckBox.isVisibleAndSelected()) {
                        QgisLauncher.builder().build().openNewProjectWithLayers(FileHelper.listRawAndImgFiles(this.folders));
                    }
                    this.this$0.dataInputField.remember();
                    this.this$0.keepOriginalSizeCheckBox.store();
                    this.this$0.mergeSamplesCheckBox.store();
                    this.this$0.createFoldersCheckBox.store();
                    this.this$0.openInEvinceCheckBox.store();
                    this.this$0.openInQgisCheckBox.store();
                    this.this$0.openExplorerCheckBox.store();
                }

                private PPExportSegmentation.OutputFormat getFormat(BasicAnalyse basicAnalyse) {
                    PPExportSegmentation.OutputFormat outputFormat = (PPExportSegmentation.OutputFormat)((Object)this.this$0.formatInputField.getSelectedItem());
                    if (((PPExportSegmentation.OutputData)((Object)this.this$0.dataInputField.getSelectedItem())).equals((Object)PPExportSegmentation.OutputData.Pixels)) {
                        return outputFormat;
                    }
                    if (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.Envi) && basicAnalyse != null && basicAnalyse.getModelMethod().isClassification()) {
                        return PPExportSegmentation.OutputFormat.EnviClassificationImage;
                    }
                    return outputFormat;
                }

                private BasicAnalyse getAnalyse() {
                    if (((PPExportSegmentation.OutputData)((Object)this.this$0.dataInputField.getSelectedItem())).equals((Object)PPExportSegmentation.OutputData.Pixels)) {
                        return (BasicAnalyse)this.this$0.analyseComboBox.getSelectedItem();
                    }
                    return ((DescriptorTreeNode)this.this$0.nodeComboBox.getSelectedItem()).getAnalyse();
                }

                private Factor getFactor(BasicAnalyse basicAnalyse) {
                    if (basicAnalyse != null) {
                        if (((PPExportSegmentation.OutputData)((Object)this.this$0.dataInputField.getSelectedItem())).equals((Object)PPExportSegmentation.OutputData.Pixels)) {
                            return ((ExportScope)((Object)this.this$0.exportScopeComboBox.getSelectedItem())).equals((Object)ExportScope.SingleClassification) ? basicAnalyse.getCategoryFactor() : (Factor)this.this$0.propertyComboBox.getValue();
                        }
                        return ((DescriptorTreeNode)this.this$0.nodeComboBox.getSelectedItem()).getFactor();
                    }
                    return null;
                }
            }, "Export predicted pixel data");
        }
    }

    public static enum ExportScope {
        AllData("All data"),
        SingleClassification("Single classification"),
        SingleQuantification("Single quantification property");

        private final String description;

        public String toString() {
            return this.description;
        }

        @Generated
        private ExportScope(String string2) {
            this.description = string2;
        }
    }

    public static class ExportPredictedSegmentations<T extends Factor<T>>
    extends PPExportSegmentation.ExportSegmentations {
        private final BasicAnalyse analyse;
        private final Factor<T> factor;
        private final DescriptorTreeNode node;

        public ExportPredictedSegmentations(File file) {
            this(file, null, null, null);
        }

        public ExportPredictedSegmentations(File file, BasicAnalyse basicAnalyse, Factor<T> factor, DescriptorTreeNode descriptorTreeNode) {
            super(file);
            this.analyse = basicAnalyse;
            this.factor = factor;
            this.node = descriptorTreeNode;
        }

        @Override
        protected RawFile getRawFile(Measurement measurement) {
            try {
                return new CachedRawFile(measurement, new MeasurementFileLocation.Prediction());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Cannot find prediction file for measurement: " + measurement.getName(), fileNotFoundException);
            }
        }

        @Override
        protected boolean isSegmentation() {
            return false;
        }

        @Override
        protected File saveSample(BreezeProgress breezeProgress, RawFile rawFile, PPExportSegmentation.ExportSegmentations.ExportOutput exportOutput, PPExportSegmentation.OutputFormat outputFormat, PPExportSegmentation.OutputData outputData, RtFramePredictor.ReferenceConvertTo referenceConvertTo, boolean bl) {
            Iterable<String> iterable;
            Object object;
            int n;
            BandNames bandNames;
            File file = exportOutput.folder();
            String string = exportOutput.name();
            String string2 = exportOutput.ext();
            Measurement measurement = exportOutput.measurement();
            Sample sample = exportOutput.sample();
            File file2 = file;
            Rectangle rectangle = sample.getPath().getOrCreateGeneralPath().getBounds();
            SampleImageMask sampleImageMask = new SampleImageMask(sample, rectangle);
            if (outputData.equals((Object)PPExportSegmentation.OutputData.Sample)) {
                sampleImageMask.addSampleValues(sample, this.node);
                bandNames = new BandNames(this.node.getAliasOrNodeString());
                n = 1;
            } else {
                object = rawFile.header();
                iterable = ((RawHeader)object).bandNames();
                bandNames = this.getRealBandNames((BandNames)iterable);
                n = this.getBand(outputFormat, (BandNames)iterable);
            }
            object = rawFile.readFrames();
            iterable = this.createMaskFrames((List<RawFrame>)object, rectangle, sampleImageMask, n, outputData, bl);
            if (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.Matlab)) {
                file2 = new File(file, string + ".mat");
                new MatExport(file2).export(breezeProgress, (List<? extends Frame>)iterable, string);
            } else if (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.EnviClassificationImage)) {
                if (!(this.factor instanceof CategoryFactor)) {
                    throw new DataNotFoundException("Incorrect factor type for classification");
                }
                this.writeRawAndHeader(null, sample, sampleImageMask.getBounds(), file, string, string2, new BandNames(this.factor.getName()), (List<? extends Frame>)iterable, null, "Exported from Breeze", ExportPredictedSegmentations.createExtra(measurement, this.factor, outputFormat, rectangle, bl), null, RtInterleave.BSQ);
            } else if (this.factor != null && outputFormat.equals((Object)PPExportSegmentation.OutputFormat.Envi)) {
                this.writeRawAndHeader(null, sample, sampleImageMask.getBounds(), file, string, string2, new BandNames(this.factor.getName()), (List<? extends Frame>)iterable, null, "Exported from Breeze", ExportPredictedSegmentations.createExtra(measurement, this.factor, outputFormat, rectangle, bl), null, RtInterleave.BSQ);
            } else {
                this.writeRawAndHeader(null, sample, sampleImageMask.getBounds(), file, string, string2, bandNames, (List<? extends Frame>)iterable, null, "Exported from Breeze", ExportPredictedSegmentations.createExtra(measurement, this.factor, outputFormat, rectangle, bl), null, null);
            }
            this.writeXml(file, file.getName(), new MetaDataProperties());
            return file2;
        }

        @Override
        protected String getAnalyseInfo(PPExportSegmentation.OutputFormat outputFormat) {
            if (this.analyse == null) {
                return "";
            }
            String string = outputFormat.equals((Object)PPExportSegmentation.OutputFormat.EnviClassificationImage) ? String.format("_%s", this.analyse.getName()) : String.format("_%s_%s", this.analyse.getName(), this.factor.getName());
            return FileHelper.sanitizeFileSystemName(string);
        }

        private int getBand(PPExportSegmentation.OutputFormat outputFormat, BandNames bandNames) {
            if (this.analyse != null && this.factor != null && (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.EnviClassificationImage) || outputFormat.equals((Object)PPExportSegmentation.OutputFormat.Envi))) {
                int n = this.getBand(bandNames, this.analyse, this.factor);
                if (n < 0) {
                    throw new DataNotFoundException("Cannot find predicted data for analysis " + this.analyse.getName());
                }
                return n;
            }
            return -1;
        }

        private int getBand(BandNames bandNames, BasicAnalyse basicAnalyse, Factor<T> factor) {
            String string = basicAnalyse.getUid() + "_" + factor.getUid();
            for (int i = 0; i < bandNames.size(); ++i) {
                if (!bandNames.get(i).equals(string)) continue;
                return i;
            }
            return -1;
        }

        private BandNames getRealBandNames(BandNames bandNames) {
            AnalyseList analyseList = BreezeMasterCache.getInstance().getAnalyseList();
            RtAnalyseList rtAnalyseList = BreezeMasterCache.getInstance().getRtAnalyseList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : bandNames) {
                arrayList.add(this.getRealName(analyseList, rtAnalyseList, string));
            }
            return new BandNames(arrayList);
        }

        private String getRealName(BasicAnalyseList<?> basicAnalyseList, BasicAnalyseList<RtAnalyse> basicAnalyseList2, String string) {
            int n = string.lastIndexOf("_");
            if (n >= 0) {
                String string2 = string.substring(0, n);
                BasicAnalyse basicAnalyse = (BasicAnalyse)basicAnalyseList.byId(string2);
                if (basicAnalyse == null) {
                    basicAnalyse = (BasicAnalyse)basicAnalyseList2.byId(string2);
                }
                if (basicAnalyse != null) {
                    if (!basicAnalyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.SamplePca)) {
                        Object f;
                        String string3 = string.substring(n + 1);
                        FactorList factorList = basicAnalyse.getFactorList();
                        if (factorList != null && (f = factorList.getByUid(string3)) != null) {
                            string3 = ((Factor)f).getName();
                        }
                        if (!string3.isEmpty()) {
                            return string3.replace(" ", "_");
                        }
                    }
                    return basicAnalyse.getName();
                }
            }
            return string;
        }

        public static class DataNotFoundException
        extends Exception {
            public DataNotFoundException(String string) {
                super(string);
            }
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getName() {
            return "Predicted pixel data";
        }

        @Override
        public String getDescription() {
            return "All data for a sample segmentation, or an single category or quantitative property";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportPredictedSegmentation(entryMainPanel, string, object);
        }
    }
}

