/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportWorkflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;

public class PPExportProject
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox includeStudyFilesCheckBox = new BreezeCheckBox("Include Record measurements", true);
    private final BreezeCheckBox includeConnectedModelFilesCheckBox = new BreezeCheckBox("Include Connected models", true);
    private final BreezeCheckBox includeConnectedEndMemberFilesCheckBox = new BreezeCheckBox("Include Connected end member files and groupings", true);
    private final BreezeCheckBox includePlayFilesCheckBox = new BreezeCheckBox("Include Play measurements", true);
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportProject(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Zip file (*.zip)");
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getDataPath(), PPExportHtml.createDefaultExportFileName(Workflow.getWorkflow(object), "zip", true));
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Press Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export Study", pPDescriptionPanel));
        this.includeStudyFilesCheckBox.setName("includeStudyFiles");
        pPDescriptionPanel.addOption(this.includeStudyFilesCheckBox);
        this.includePlayFilesCheckBox.setName("includePlayFiles");
        pPDescriptionPanel.addOption(this.includePlayFilesCheckBox);
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        this.setLists(this.viewClassList);
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportProject this$0;
                {
                    this.this$0 = pPExportProject;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file.getParentFile());
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting study, connected models and play workflows to archive file");
                    this.this$0.export(this.getProgressManager(), Workflow.getWorkflow(this.this$0.entryData), file);
                }
            }, "Export study");
        }
    }

    protected void export(BreezeProgress breezeProgress, Workflow workflow, File file) {
        ZipManager zipManager = new ZipManager(file);
        boolean bl = this.includeStudyFilesCheckBox.isSelected();
        boolean bl2 = this.includeConnectedModelFilesCheckBox.isSelected();
        boolean bl3 = this.includePlayFilesCheckBox.isSelected();
        boolean bl4 = this.includeConnectedEndMemberFilesCheckBox.isSelected();
        PPExportWorkflow.addFolderOrXmlFile(workflow, bl, bl4, zipManager);
        if (bl2) {
            PPExportWorkflow.includeAllModels(true, zipManager, workflow);
        }
        for (BasicWorkflow basicWorkflow : BreezeMasterCache.getInstance().getWorkflowList().filter(new BreezeFilter.AnalyseStudy(workflow))) {
            PPExportWorkflow.addFolderOrXmlFile((Workflow)basicWorkflow, bl3, bl4, zipManager);
        }
        zipManager.perform(breezeProgress);
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Project with recorded measurements, connected models and workflows";
        }

        @Override
        public String getName() {
            return "Project";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportProject(entryMainPanel, string, object);
        }
    }
}

