/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.WizardComponents;
import se.prediktera.breeze.frontend.common.report.CsvReportCreator;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.map.dataexport.ExportCSV;

public class PPExportProperties
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final ArrayList<BreezeCheckBox> segmentationCheckBoxes = new ArrayList();
    private final WizardComponents.ExportOptionCheckBox shouldMergeCheckBox = new MergeDepthCheckBox();
    private final WizardComponents.ExportOptionCheckBox includeSubsampleNamesCheckbox = new IncludeSubsampleNamesCheckBox();
    private final WizardComponents.ExportOptionCheckBox includeWavelengthCheckBox = new IncludeWavelengthCheckBox();
    private final WizardComponents.ExportOptionCheckBox openInEvinceCheckBox = new WizardComponents.OpenInEvinceCheckBox();
    private final WizardComponents.OpenInExplorerCheckBox openExplorerCheckBox = new WizardComponents.OpenInExplorerCheckBox();
    private final WizardComponents.ExportTextField delimiterInputField = new WizardComponents.ExportTextField("csvDelimiter", "Column delimiter", ";");
    private final WizardComponents.ExportTextField decimalFormatInputField = new WizardComponents.ExportTextField("decimal", "Decimal separator", ".");

    public PPExportProperties(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        ExportCSV exportCSV = new ExportCSV();
        this.fileSelectionPanel.addExtension(new String[]{exportCSV.getExt()}, exportCSV.getDescription());
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = PPExportHtml.createDefaultExportFile((Entry)object, "csv");
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Provide settings for export to a CSV text file. Press Finish to perform the export.\n\n");
        Workflow workflow = Workflow.getWorkflow(object);
        FunctionTreeNode functionTreeNode = workflow.getRoot();
        int n = workflow.getSegmentationLevel();
        int n2 = 0;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        pPDescriptionPanel.addSeparator("Segmentations:");
        BreezeCheckBox.CheckBoxCallback checkBoxCallback = bl -> {
            boolean bl2 = this.segmentationCheckBoxes.stream().skip(1L).anyMatch(AbstractButton::isSelected);
            this.includeSubsampleNamesCheckbox.setEnabled(bl2);
            if (!bl2) {
                this.includeSubsampleNamesCheckbox.setSelected(false);
            }
        };
        BreezeCheckBox breezeCheckBox = new BreezeCheckBox(functionTreeNode.getAliasOrNodeString(), false, checkBoxCallback);
        breezeCheckBox.setItem(Pair.of((Object)n2, (Object)functionTreeNode));
        breezeCheckBox.setSelected(n == n2);
        arrayList.add(breezeCheckBox);
        this.segmentationCheckBoxes.add(breezeCheckBox);
        pPDescriptionPanel.addHorizontalSiblings(arrayList);
        for (SegmentationNodeList segmentationNodeList : SegmentationNode.getSegmentationLists(functionTreeNode)) {
            ++n2;
            arrayList = new ArrayList();
            for (SegmentationNode segmentationNode : segmentationNodeList) {
                BreezeCheckBox breezeCheckBox2 = new BreezeCheckBox(segmentationNode.getAliasOrNodeString(), false, checkBoxCallback);
                breezeCheckBox2.setItem(Pair.of((Object)n2, (Object)(segmentationNodeList.size() > 1 ? segmentationNode : null)));
                breezeCheckBox2.setSelected(n == n2);
                arrayList.add(breezeCheckBox2);
                this.segmentationCheckBoxes.add(breezeCheckBox2);
            }
            pPDescriptionPanel.addHorizontalSiblings(arrayList);
        }
        pPDescriptionPanel.addSeparator("Options");
        this.shouldMergeCheckBox.setVisible(workflow.getDepthRegistration());
        pPDescriptionPanel.addOptionIndent(this.shouldMergeCheckBox);
        pPDescriptionPanel.addOptionIndent(this.includeSubsampleNamesCheckbox);
        pPDescriptionPanel.addOptionIndent(this.includeWavelengthCheckBox);
        pPDescriptionPanel.addSeparator("Output file options");
        pPDescriptionPanel.addOptionIndentNoFill(this.delimiterInputField);
        pPDescriptionPanel.addOptionIndentNoFill(this.decimalFormatInputField);
        pPDescriptionPanel.addOptionIndent(this.openInEvinceCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openExplorerCheckBox);
        pPDescriptionPanel.addBottomOption(new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, ((Entry)object).formatNumberGroupsAndMeasurements() + " will be exported"));
        this.viewClassList.add(new ViewClass("Settings", "Setting for export properties", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    public void enterStep(int n) {
        super.enterStep(n);
        if (n == 1) {
            this.openExplorerCheckBox.setFolder(this.fileSelectionPanel.approveSelectionAndGetSelectedFolder());
        }
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportProperties this$0;
                {
                    this.this$0 = pPExportProperties;
                    super(abstractWizardPanel);
                }

                @Override
                public void runAction() {
                    this.setInfoText("Exporting to CSV file");
                    ArrayList<SegmentationIdentifier> arrayList = new ArrayList<SegmentationIdentifier>();
                    for (BreezeCheckBox breezeCheckBox : this.this$0.segmentationCheckBoxes) {
                        if (!breezeCheckBox.isSelected()) continue;
                        int n = (Integer)((Pair)breezeCheckBox.getItem()).getKey();
                        Object object = ((Pair)breezeCheckBox.getItem()).getValue();
                        if (object instanceof SegmentationNode) {
                            SegmentationNode segmentationNode = (SegmentationNode)object;
                            arrayList.add(new SegmentationIdentifier(n, segmentationNode.getUid()));
                            continue;
                        }
                        arrayList.add(new SegmentationIdentifier(n, null));
                    }
                    new CsvReportCreator(file, Measurement.getMeasurements(this.this$0.entryData), this.this$0.delimiterInputField.getValue(), this.this$0.decimalFormatInputField.getValue(), this.this$0.includeWavelengthCheckBox.isSelected(), arrayList, this.this$0.shouldMergeCheckBox.isVisibleAndSelected(), this.this$0.includeSubsampleNamesCheckbox.isVisibleAndSelected()).write();
                    this.this$0.delimiterInputField.store();
                    this.this$0.decimalFormatInputField.store();
                    this.this$0.includeWavelengthCheckBox.store();
                    this.this$0.shouldMergeCheckBox.store();
                    this.this$0.includeSubsampleNamesCheckbox.store();
                    this.this$0.includeWavelengthCheckBox.store();
                    this.this$0.openInEvinceCheckBox.store();
                    this.this$0.openExplorerCheckBox.store();
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openInEvinceCheckBox.isEnabled() && this.this$0.openInEvinceCheckBox.isSelected()) {
                        EvinceHelper.startEvince(file);
                    }
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file.getParentFile());
                    }
                }
            }, "Export values");
        }
    }

    public static class MergeDepthCheckBox
    extends WizardComponents.ExportOptionCheckBox {
        public MergeDepthCheckBox() {
            super("mergeDepth", "Merge objects in the same Depth Registration interval", true, null);
        }
    }

    public static class IncludeSubsampleNamesCheckBox
    extends WizardComponents.ExportOptionCheckBox {
        public IncludeSubsampleNamesCheckBox() {
            super("include", "Add column with object (sub-sample) names", true, null);
        }
    }

    public static class IncludeWavelengthCheckBox
    extends WizardComponents.ExportOptionCheckBox {
        public IncludeWavelengthCheckBox() {
            super("includeWavelength", "Add columns with average values for the spectrum wavelengths", true, null);
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Table data and average spectrum to comma separated text file";
        }

        @Override
        public String getName() {
            return "CSV";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportProperties(entryMainPanel, string, object);
        }
    }
}

