/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import se.prediktera.breeze.backend.measure.writers.FileImageWriter;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.realtime.segmentation.SampleImageMask;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthIntervalSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.QgisLauncher;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.entry.sample.MergedSample;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.WizardComponents;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.mat.MatExport;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHeaderHelper;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class PPExportSegmentation
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final SegmentationInputField segmentationComboBox = new SegmentationInputField();
    private final WizardComponents.ExportInputField<OutputFormat> formatInputField = new WizardComponents.ExportInputField("File format");
    private final WizardComponents.ExportInputField<RtFramePredictor.ReferenceConvertTo> typeInputField = new WizardComponents.ExportInputField("Spectral data");
    private final WizardComponents.ExportInputField<CategoryFactor> categoryComboBox = new WizardComponents.ExportInputField("Category");
    private final BreezeLabel objectProcessingLabel = new BreezeLabel("Objects identified by the segmentation can be exported as separate files, or per measurement image:");
    private final WizardComponents.ExportOptionCheckBox keepOriginalSizeCheckBox = new WizardComponents.KeepOriginalSizeCheckBox();
    private final WizardComponents.ExportOptionCheckBox mergeSamplesCheckBox = new WizardComponents.MergeSamplesCheckBox();
    private final WizardComponents.ExportOptionCheckBox createFoldersCheckBox = new WizardComponents.CreateFoldersCheckBox();
    private final WizardComponents.ExportOptionCheckBox openInEvinceCheckBox = new WizardComponents.OpenInEvinceCheckBox();
    private final WizardComponents.ExportOptionCheckBox openInQgisCheckBox = new WizardComponents.OpenInQgisCheckBox();
    private final WizardComponents.OpenInExplorerCheckBox openExplorerCheckBox = new WizardComponents.OpenInExplorerCheckBox();
    private final BreezeInputField yoloTestNumberInputField = new BreezeInputField.Number("Test images", 5.0, "");
    private final List<Measurement> selectedMeasurements;
    private boolean hasReferences = false;

    public PPExportSegmentation(EntryMainPanel entryMainPanel, String string, Object object2) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object2);
        Measurement measurement;
        this.fileSelectionPanel = new FileChooserPanel(this, "Select folder to Export into and press Next", false);
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(1);
        File file = new File(((Entry)object2).getFolder(), "Export");
        file.mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file);
        this.viewClassList.add(new ViewClass("Export file", "Select folder to export into", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Settings for export spectral pixel data. Press Finish to complete export");
        Workflow workflow = Workflow.getWorkflow(object2);
        this.selectedMeasurements = Measurement.getMeasurements(entryMainPanel.getSelectedEntries());
        Measurement measurement2 = measurement = !this.selectedMeasurements.isEmpty() ? this.selectedMeasurements.getFirst() : null;
        if (measurement != null) {
            this.hasReferences = measurement.hasReferences();
        }
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.setChangedListener(object -> {
            boolean bl = this.segmentationComboBox.getSegmentationLevel() > 0;
            this.objectProcessingLabel.setVisible(bl);
            this.mergeSamplesCheckBox.setVisible(bl);
            this.keepOriginalSizeCheckBox.setVisible(bl);
        });
        this.segmentationComboBox.init(workflow);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        pPDescriptionPanel.addOption(this.objectProcessingLabel);
        pPDescriptionPanel.addOptionIndent(this.mergeSamplesCheckBox);
        pPDescriptionPanel.addOptionIndent(this.keepOriginalSizeCheckBox);
        pPDescriptionPanel.addSeparator("Output file options");
        this.formatInputField.addItem(OutputFormat.Envi);
        this.formatInputField.addItem(OutputFormat.HySpex);
        this.formatInputField.addItem(OutputFormat.Matlab);
        this.formatInputField.addItem(OutputFormat.Image);
        this.formatInputField.addItem(OutputFormat.YoloAnnotation);
        this.formatInputField.setChangedListener(outputFormat -> {
            this.formatInputField.setUsage(outputFormat.getUsage());
            this.formatInputField.reformat();
            this.updateTypes((OutputFormat)((Object)outputFormat), measurement);
        });
        pPDescriptionPanel.addOption(this.formatInputField);
        this.typeInputField.getComboBox().setName("exportType");
        this.updateTypes((OutputFormat)((Object)this.formatInputField.getSelectedItem()), measurement);
        for (CategoryFactor categoryFactor : workflow.getCategoryFactors()) {
            this.categoryComboBox.addItem(categoryFactor);
        }
        this.categoryComboBox.setVisible(false);
        pPDescriptionPanel.addOption(this.categoryComboBox);
        this.yoloTestNumberInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        this.yoloTestNumberInputField.setLabelWidth(120);
        pPDescriptionPanel.addOption(this.yoloTestNumberInputField);
        this.formatInputField.setChangedListener(outputFormat -> this.categoryComboBox.setVisible(OutputFormat.YoloAnnotation.equals(this.formatInputField.getValue())));
        pPDescriptionPanel.addOption(this.typeInputField);
        pPDescriptionPanel.addOptionIndent(this.createFoldersCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openInEvinceCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openInQgisCheckBox);
        pPDescriptionPanel.addOptionIndent(this.openExplorerCheckBox);
        pPDescriptionPanel.addBottomOption(new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, ((Entry)object2).formatNumberGroupsAndMeasurements() + " will be exported"));
        this.viewClassList.add(new ViewClass("Settings", "Settings for export", pPDescriptionPanel));
        this.formatInputField.selectAndRemember(OutputFormat.Envi);
        this.setLists(this.viewClassList);
    }

    private void updateTypes(OutputFormat outputFormat, Measurement measurement) {
        this.typeInputField.removeAllItems();
        if (outputFormat.isImageOnly()) {
            this.typeInputField.addItem(this.hasReferences ? RtFramePredictor.ReferenceConvertTo.Reflectance : RtFramePredictor.ReferenceConvertTo.None);
        } else {
            if (outputFormat.isEnviFormat() || !this.hasReferences) {
                this.typeInputField.addItem(RtFramePredictor.ReferenceConvertTo.None);
            }
            if (measurement.isHySpex()) {
                this.typeInputField.addItem(RtFramePredictor.ReferenceConvertTo.Radiance);
            }
            if (this.hasReferences) {
                this.typeInputField.addItem(RtFramePredictor.ReferenceConvertTo.Reflectance);
                this.typeInputField.addItem(RtFramePredictor.ReferenceConvertTo.Absorbance);
                if (outputFormat.equals((Object)OutputFormat.Matlab)) {
                    this.typeInputField.setSelectedItem(RtFramePredictor.ReferenceConvertTo.Absorbance);
                }
            }
        }
        this.typeInputField.setVisible(!outputFormat.isImageOnly() && !outputFormat.equals((Object)OutputFormat.HySpex));
        boolean bl = outputFormat.equals((Object)OutputFormat.YoloAnnotation);
        this.createFoldersCheckBox.setVisible(!bl);
        this.openInEvinceCheckBox.setVisible(!bl);
        this.yoloTestNumberInputField.setVisible(bl);
    }

    @Override
    public void enterStep(int n) {
        super.enterStep(n);
        if (n == 1) {
            this.openExplorerCheckBox.setFolder(this.fileSelectionPanel.approveSelectionAndGetSelectedFolder());
        }
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFolder();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                private List<File> fileOrFolders;
                final /* synthetic */ PPExportSegmentation this$0;
                {
                    this.this$0 = pPExportSegmentation;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openInEvinceCheckBox.isVisibleAndSelected() && this.fileOrFolders != null) {
                        EvinceHelper.startEvince(this.fileOrFolders, null);
                    }
                    if (this.this$0.openExplorerCheckBox.isVisibleAndSelected()) {
                        FileHelper.openExplorerOnPath(file);
                    }
                }

                @Override
                public void runAction() {
                    this.setInfoText("Exporting segmentations");
                    this.fileOrFolders = new ExportSegmentations(file).perform(this.getProgressManager(), this.this$0.selectedMeasurements, (OutputFormat)((Object)this.this$0.formatInputField.getSelectedItem()), OutputData.Pixels, (RtFramePredictor.ReferenceConvertTo)((Object)this.this$0.typeInputField.getSelectedItem()), this.this$0.segmentationComboBox.getSelectedIndex(), (CategoryFactor)this.this$0.categoryComboBox.getSelectedItem(), this.this$0.yoloTestNumberInputField.getNumberInt(), this.this$0.keepOriginalSizeCheckBox.isSelected(), this.this$0.mergeSamplesCheckBox.isSelected(), this.this$0.createFoldersCheckBox.isSelected());
                    if (this.this$0.openInQgisCheckBox.isVisibleAndSelected()) {
                        QgisLauncher.builder().build().openNewProjectWithLayers(FileHelper.listRawAndImgFiles(this.fileOrFolders));
                    }
                    this.this$0.formatInputField.remember();
                    this.this$0.keepOriginalSizeCheckBox.store();
                    this.this$0.mergeSamplesCheckBox.store();
                    this.this$0.createFoldersCheckBox.store();
                    this.this$0.openInEvinceCheckBox.store();
                    this.this$0.openInQgisCheckBox.store();
                    this.this$0.openExplorerCheckBox.store();
                }
            }, "Export spectral pixel data");
        }
    }

    @Generated
    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    public static class SegmentationInputField
    extends BreezeComboBoxInputField {
        public SegmentationInputField() {
            super("Segmentation", "", BreezeInputFieldHelper.Format.OneRow);
            this.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        }

        public void init(Workflow workflow) {
            FunctionTreeNode functionTreeNode = workflow.getRoot();
            this.addItem(functionTreeNode);
            for (SegmentationNodeList segmentationNodeList : SegmentationNode.getSegmentationLists(functionTreeNode)) {
                this.addItem(segmentationNodeList);
            }
            this.setSelectedIndexAndTrigger(workflow.getSegmentationLevel());
        }

        public int getSegmentationLevel() {
            return this.getSelectedIndex();
        }

        public List<DescriptorTreeNode> getSelectedNodes(Workflow workflow, boolean bl) {
            Object t = this.getSelectedItem();
            if (t instanceof SegmentationNodeList) {
                SegmentationNodeList segmentationNodeList = (SegmentationNodeList)t;
                return segmentationNodeList.getNodes(workflow, bl);
            }
            return workflow.getSegmentationLevelDescriptorNodes(new SegmentationIdentifier(0, null), bl);
        }

        public boolean shouldOfferMergeIntervalChoice() {
            Object t = this.getSelectedItem();
            if (t instanceof SegmentationNodeList && ((SegmentationNodeList)t).size() == 1) {
                SegmentationNode segmentationNode = ((SegmentationNodeList)t).getFirst();
                if (segmentationNode.getFunction() instanceof DepthIntervalSegmentation) {
                    return true;
                }
                FunctionTreeNode functionTreeNode = SegmentationNode.getParentNode(segmentationNode);
                while (functionTreeNode != null) {
                    if (functionTreeNode.getFunction() instanceof DepthIntervalSegmentation) {
                        return true;
                    }
                    if (functionTreeNode.isRoot()) {
                        return false;
                    }
                    functionTreeNode = SegmentationNode.getParentNode(functionTreeNode);
                }
            }
            return false;
        }
    }

    public static enum OutputFormat {
        Envi("raw/img"),
        HySpex("hyspex"),
        EnviClassificationImage("img"),
        Matlab("mat"),
        Image("png"),
        YoloAnnotation("png/txt");

        private final String extension;

        private OutputFormat(String string2) {
            this.extension = string2;
        }

        public String toString() {
            return StringHelper.formatLabel(this.name()) + " (." + this.extension + ")";
        }

        public String getUsage() {
            if (this.equals((Object)Matlab)) {
                return "Note. Data will be converted to reflectance or absorbance when using dark and white references";
            }
            return "";
        }

        public boolean writeXml() {
            return !this.isImageOnly();
        }

        public boolean isEnviFormat() {
            return this.equals((Object)Envi) || this.equals((Object)HySpex);
        }

        private boolean isImageOnly() {
            return this.equals((Object)Image) || this.equals((Object)YoloAnnotation);
        }
    }

    private static class AnnotationExport {
        private AnnotationExport() {
        }

        public static void saveLabels(File file, String string, RawHeader rawHeader, List<Sample> list, CategoryFactor categoryFactor) {
            File file2 = new File(new File(file, "labels"), "train");
            file2.mkdirs();
            File file3 = new File(file2, string + ".txt");
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3, true));){
                int n = rawHeader.pixelWidth().value;
                int n2 = rawHeader.frameCount().value;
                for (Sample sample : list) {
                    Shape shape = sample.getSamplePath().getOrCreateGeneralPath();
                    Rectangle rectangle = shape.getBounds();
                    Float f = sample.getSampleValues().getValue(categoryFactor);
                    int n3 = f != null ? f.intValue() : 0;
                    bufferedWriter.write(n3 + "\t" + RtDataFormat.toString((rectangle.x + rectangle.width / 2) / n) + "\t" + RtDataFormat.toString((rectangle.y + rectangle.height / 2) / n2) + "\t" + RtDataFormat.toString(rectangle.width / n) + "\t" + RtDataFormat.toString(rectangle.height / n2));
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public static void copyToFolder(File file, String string, int n, boolean bl) {
            BreezeProgressImpl breezeProgressImpl = BreezeProgressImpl.createEmpty();
            File file2 = new File(file, "labels");
            AnnotationExport.copyFiles(breezeProgressImpl, new File(file2, "train"), new File(file2, string), n, bl);
            File file3 = new File(file, "images");
            AnnotationExport.copyFiles(breezeProgressImpl, new File(file3, "train"), new File(file3, string), n, bl);
        }

        private static void copyFiles(BreezeProgress breezeProgress, File file, File file2, int n, boolean bl) {
            File[] fileArray = file.listFiles();
            ArrayList<File> arrayList = new ArrayList<File>();
            double d = (double)fileArray.length / (double)n;
            for (double d2 = 0.0; d2 < (double)fileArray.length; d2 += d) {
                arrayList.add(fileArray[(int)d2]);
            }
            FileHelper.copyFiles(breezeProgress, arrayList, file2);
            if (bl) {
                for (File file3 : arrayList) {
                    file3.delete();
                }
            }
        }

        public static void saveCocoNames(File file, CategoryFactor categoryFactor) {
            List<CatClass> list = categoryFactor.getAllClasses();
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(file, "coco.names"), true));){
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.write(list.get(i).getName());
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public static void saveYaml(File file, CategoryFactor categoryFactor) {
            try (FileWriter fileWriter = new FileWriter(new File(file, "data.yaml"));){
                DumperOptions dumperOptions = new DumperOptions();
                Representer representer = new Representer(dumperOptions);
                representer.addClassTag(YamlSetup.class, Tag.MAP);
                Yaml yaml = new Yaml(representer, dumperOptions);
                yaml.dump((Object)new YamlSetup(file, categoryFactor), (Writer)fileWriter);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private static class YamlSetup {
            public String path;
            public String train;
            public String val;
            public String test;
            public int nc;
            public List<String> names;

            public YamlSetup(File file, CategoryFactor categoryFactor) {
                this.path = file.getAbsolutePath();
                this.train = "images/train";
                this.val = "images/val";
                this.test = "images/test";
                List<CatClass> list = categoryFactor.getAllClasses();
                this.nc = list.size();
                this.names = list.stream().map(CatClass::getName).collect(Collectors.toList());
            }

            @Generated
            public String getPath() {
                return this.path;
            }

            @Generated
            public String getTrain() {
                return this.train;
            }

            @Generated
            public String getVal() {
                return this.val;
            }

            @Generated
            public String getTest() {
                return this.test;
            }

            @Generated
            public int getNc() {
                return this.nc;
            }

            @Generated
            public List<String> getNames() {
                return this.names;
            }

            @Generated
            public void setPath(String string) {
                this.path = string;
            }

            @Generated
            public void setTrain(String string) {
                this.train = string;
            }

            @Generated
            public void setVal(String string) {
                this.val = string;
            }

            @Generated
            public void setTest(String string) {
                this.test = string;
            }

            @Generated
            public void setNc(int n) {
                this.nc = n;
            }

            @Generated
            public void setNames(List<String> list) {
                this.names = list;
            }

            @Generated
            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof YamlSetup)) {
                    return false;
                }
                YamlSetup yamlSetup = (YamlSetup)object;
                if (!yamlSetup.canEqual(this)) {
                    return false;
                }
                if (this.getNc() != yamlSetup.getNc()) {
                    return false;
                }
                String string = this.getPath();
                String string2 = yamlSetup.getPath();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
                String string3 = this.getTrain();
                String string4 = yamlSetup.getTrain();
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    return false;
                }
                String string5 = this.getVal();
                String string6 = yamlSetup.getVal();
                if (string5 == null ? string6 != null : !string5.equals(string6)) {
                    return false;
                }
                String string7 = this.getTest();
                String string8 = yamlSetup.getTest();
                if (string7 == null ? string8 != null : !string7.equals(string8)) {
                    return false;
                }
                List<String> list = this.getNames();
                List<String> list2 = yamlSetup.getNames();
                return !(list == null ? list2 != null : !((Object)list).equals(list2));
            }

            @Generated
            protected boolean canEqual(Object object) {
                return object instanceof YamlSetup;
            }

            @Generated
            public int hashCode() {
                int n = 1;
                n = n * 59 + this.getNc();
                String string = this.getPath();
                n = n * 59 + (string == null ? 43 : string.hashCode());
                String string2 = this.getTrain();
                n = n * 59 + (string2 == null ? 43 : string2.hashCode());
                String string3 = this.getVal();
                n = n * 59 + (string3 == null ? 43 : string3.hashCode());
                String string4 = this.getTest();
                n = n * 59 + (string4 == null ? 43 : string4.hashCode());
                List<String> list = this.getNames();
                n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
                return n;
            }

            @Generated
            public String toString() {
                return "PPExportSegmentation.AnnotationExport.YamlSetup(path=" + this.getPath() + ", train=" + this.getTrain() + ", val=" + this.getVal() + ", test=" + this.getTest() + ", nc=" + this.getNc() + ", names=" + String.valueOf(this.getNames()) + ")";
            }
        }
    }

    public static class SegmentationIdInputField
    extends BreezeComboBoxInputField {
        public static String Default = "All";
        private Object obj;

        public SegmentationIdInputField() {
            super("", "", BreezeInputFieldHelper.Format.OneRow);
            this.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        }

        public boolean init(Object object) {
            this.obj = object;
            this.removeAllItems();
            if (object instanceof SegmentationNodeList) {
                SegmentationNodeList segmentationNodeList = (SegmentationNodeList)object;
                if (segmentationNodeList.size() > 1) {
                    this.addItem(Default);
                }
                for (SegmentationNode segmentationNode : segmentationNodeList) {
                    this.addItem(segmentationNode);
                }
                return segmentationNodeList.size() > 1;
            }
            return false;
        }

        public void setDefault(Workflow workflow) {
            String string = workflow.getSegmentationHashId();
            if (string == null) {
                this.setSelectedIndex(0);
            } else {
                for (int i = 1; i < this.getItemCount(); ++i) {
                    SegmentationNode segmentationNode;
                    Object t = this.getItemAt(i);
                    if (!(t instanceof SegmentationNode) || !(segmentationNode = (SegmentationNode)t).getUid().equals(string)) continue;
                    this.setSelectedIndex(i);
                    return;
                }
            }
        }

        public String getSegmentationHashId() {
            Object t;
            if (this.isVisible() && (t = this.getSelectedItem()) instanceof SegmentationNode) {
                SegmentationNode segmentationNode = (SegmentationNode)t;
                return segmentationNode.getUid();
            }
            return null;
        }

        public List<String> getUids() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Object t = this.getSelectedItem();
            if (t instanceof SegmentationNode) {
                SegmentationNode segmentationNode = (SegmentationNode)t;
                arrayList.add(segmentationNode.getUid());
            } else {
                Iterator iterator = this.obj;
                if (iterator instanceof SegmentationNodeList) {
                    SegmentationNodeList segmentationNodeList = (SegmentationNodeList)((Object)iterator);
                    for (SegmentationNode segmentationNode : segmentationNodeList) {
                        arrayList.add(segmentationNode.getUid());
                    }
                } else {
                    arrayList.add("");
                }
            }
            return arrayList;
        }
    }

    public static class ExportSegmentations {
        protected final File exportFolder;
        private final boolean doIterator = false;

        public ExportSegmentations(File file) {
            this.exportFolder = file;
            file.mkdirs();
        }

        public final List<File> perform(BreezeProgress breezeProgress, List<Measurement> list, OutputFormat outputFormat, OutputData outputData, RtFramePredictor.ReferenceConvertTo referenceConvertTo, int n, CategoryFactor categoryFactor, int n2, boolean bl, boolean bl2, boolean bl3) {
            ArrayList<ExportOutput> arrayList = this.getExportOutputs(outputFormat, referenceConvertTo, bl2, bl3, list, n);
            ExportOutput exportOutput = null;
            for (ExportOutput exportOutput2 : arrayList) {
                if (!exportOutput2.exits()) continue;
                exportOutput = exportOutput2;
                break;
            }
            if (exportOutput != null && !BreezeOptionDialog.showDialogAndWait(BreezeFrame.getInstance(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "File exists", "One or more files with the same name already exist in the export folder.\nDo you want to overwrite them?")) {
                throw new ToastHandler.ToasterMessageException("Export aborted", Toast.IconType.Info);
            }
            ArrayList arrayList2 = new ArrayList();
            int n3 = breezeProgress.setGroupMaximumAndReset(list.size());
            for (ExportOutput exportOutput3 : arrayList) {
                if (breezeProgress.isAborted()) {
                    return arrayList2;
                }
                if (bl3) {
                    exportOutput3.deleteAndMkdirs();
                }
                Measurement measurement = exportOutput3.measurement();
                breezeProgress.setInfoText("Exporting segmentations from measurement: " + measurement.getName());
                RawFile rawFile = this.getRawFile(measurement);
                File file = this.saveSample(breezeProgress, rawFile, exportOutput3, outputFormat, outputData, referenceConvertTo, bl);
                arrayList2.add(file);
                if (outputFormat.equals((Object)OutputFormat.YoloAnnotation)) {
                    SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(n);
                    AnnotationExport.saveLabels(this.exportFolder, FileHelper.getFileName(file), rawFile.header(), sampleSegmentationColumn, categoryFactor);
                }
                breezeProgress.incStepGroup(n3);
            }
            if (outputFormat.equals((Object)OutputFormat.YoloAnnotation)) {
                AnnotationExport.copyToFolder(this.exportFolder, "val", n2, false);
                AnnotationExport.copyToFolder(this.exportFolder, "test", n2, true);
                if (categoryFactor != null) {
                    AnnotationExport.saveCocoNames(this.exportFolder, categoryFactor);
                    AnnotationExport.saveYaml(this.exportFolder, categoryFactor);
                }
            }
            return arrayList2;
        }

        public ArrayList<ExportOutput> getExportOutputs(OutputFormat outputFormat, RtFramePredictor.ReferenceConvertTo referenceConvertTo, boolean bl, boolean bl2, List<Measurement> list, int n) {
            ArrayList<ExportOutput> arrayList = new ArrayList<ExportOutput>();
            for (Measurement measurement : list) {
                SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(n);
                if (outputFormat.equals((Object)OutputFormat.YoloAnnotation)) {
                    arrayList.add(this.getOutput(measurement, measurement.getRootSample(), outputFormat, referenceConvertTo, sampleSegmentationColumn.size() > 1, bl2));
                    continue;
                }
                if (bl) {
                    MergedSample mergedSample = new MergedSample(sampleSegmentationColumn);
                    arrayList.add(this.getOutput(measurement, mergedSample, outputFormat, referenceConvertTo, sampleSegmentationColumn.size() > 1, bl2));
                    continue;
                }
                for (Sample sample : sampleSegmentationColumn) {
                    arrayList.add(this.getOutput(measurement, sample, outputFormat, referenceConvertTo, sampleSegmentationColumn.size() > 1, bl2));
                }
            }
            return arrayList;
        }

        protected RawFile getRawFile(Measurement measurement) {
            return measurement.rawFile();
        }

        protected boolean isSegmentation() {
            return true;
        }

        protected ExportOutput getOutput(Measurement measurement, Sample sample, OutputFormat outputFormat, RtFramePredictor.ReferenceConvertTo referenceConvertTo, boolean bl, boolean bl2) {
            String string = this.getExportName(measurement, sample, bl, this.getAnalyseInfo(outputFormat));
            File file = this.exportFolder;
            if (outputFormat.equals((Object)OutputFormat.YoloAnnotation)) {
                file = new File(new File(this.exportFolder, "images"), "train");
            } else if (bl2) {
                file = new File(this.exportFolder, string);
            }
            Object object = string;
            String string2 = "img";
            if (this.isSegmentation()) {
                if (!referenceConvertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.None)) {
                    object = (String)object + "_" + referenceConvertTo.getPrefix();
                }
                string2 = referenceConvertTo.getExt(outputFormat);
            } else if (outputFormat.equals((Object)OutputFormat.Matlab)) {
                string2 = "mat";
            }
            return new ExportOutput(file, (String)object, string2, measurement, sample);
        }

        protected String getAnalyseInfo(OutputFormat outputFormat) {
            return "";
        }

        protected File saveSample(BreezeProgress breezeProgress, RawFile rawFile, ExportOutput exportOutput, OutputFormat outputFormat, OutputData outputData, RtFramePredictor.ReferenceConvertTo referenceConvertTo, boolean bl) {
            Serializable serializable;
            Object object;
            Object object2;
            File file = exportOutput.folder();
            String string = exportOutput.name();
            String string2 = exportOutput.ext();
            Measurement measurement = exportOutput.measurement();
            Sample sample = exportOutput.sample();
            Workflow workflow = measurement.getWorkflow();
            RawHeader rawHeader = rawFile.header();
            RgbBands rgbBands = rawHeader.rgbBands();
            BandNames bandNames = rawHeader.bandNames();
            Object object3 = rawHeader.getDescription();
            if (object3 == null) {
                object3 = "";
            }
            object3 = (String)object3 + "\n Data format = " + referenceConvertTo.toString();
            MaxSignal maxSignal = this.getMaxSignal(measurement, rawFile, rgbBands);
            Object object4 = file;
            Rectangle rectangle = sample.getPath().getOrCreateGeneralPath().getBounds();
            SampleImageMask sampleImageMask = new SampleImageMask(sample, rectangle);
            List<RawFrame> list = this.createMaskFrames(rawFile, rectangle, sampleImageMask, -1, outputData, bl);
            RawFrame rawFrame = list.getFirst();
            if (outputFormat.writeXml()) {
                object2 = new MetaDataProperties();
                ((MetaDataProperties)object2).addProperty("Frames", list.size());
                ((MetaDataProperties)object2).addProperty("Wavelength", rawFrame.getRows().value);
                ((MetaDataProperties)object2).addProperty("PixelsPerLine", rawFrame.getColumns().value);
                ((MetaDataProperties)object2).addProperty("MaxSignal", maxSignal.value);
                ((MetaDataProperties)object2).addProperty("ConvertedTo", referenceConvertTo.name());
                object = measurement.getMetaProperties();
                serializable = ((MetaDataProperties)object).getMetaNumberNullIfMissing("Resolution");
                if (serializable != null) {
                    ((MetaDataProperties)object2).addProperty("FieldOfView", new FieldOfView((Resolution)new Resolution((float)((Double)serializable).floatValue()), (PixelWidth)rawFrame.columns).value);
                }
                for (String object5 : new String[]{"Resolution", "Speed", "MaxSaturatedBand", "Version", "FrameRate", "IntegrationTime", "CameraName", "Type", "RgbBands"}) {
                    ((MetaDataProperties)object2).addPropertyIfExist(object5, (MetaDataProperties)object);
                }
                this.writeXml(file, string, (MetaDataProperties)object2);
            }
            object2 = new File(file, string + ".png");
            if (measurement.hasReferences()) {
                RtFrameStackList.RealtimeFrameList realtimeFrameList;
                boolean bl2;
                object = measurement.darkReference().readFrames();
                serializable = new Rectangle(rectangle.x, 0, rectangle.width, object.size());
                String[] stringArray = this.createMaskFrames((List<RawFrame>)object, (Rectangle)serializable, null, -1, outputData, bl);
                SpectralReference.WhiteReference whiteReference = measurement.whiteReference();
                List<RawFrame> list2 = whiteReference.readFrames();
                Rectangle rectangle2 = new Rectangle(rectangle.x, 0, rectangle.width, list2.size());
                List<RawFrame> list3 = this.createMaskFrames(list2, rectangle2, null, -1, outputData, bl);
                RtFramePredictor.RefSettings refSettings = list2.isEmpty() ? new RtFramePredictor.RefSettings(RtFramePredictor.ReferenceType.OnlyDark) : new RtFramePredictor.RefSettings(RtFramePredictor.ReferenceType.KeepReflectance);
                boolean bl3 = bl2 = referenceConvertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Reflectance) || outputFormat.isImageOnly();
                if (referenceConvertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.Radiance)) {
                    refSettings.convertTo = RtFramePredictor.ReferenceConvertTo.Radiance;
                    refSettings.useDarkReferenceAfter = true;
                } else if (bl2) {
                    refSettings.convertTo = RtFramePredictor.ReferenceConvertTo.Reflectance;
                }
                refSettings.bounds = serializable;
                RtFrameStackList rtFrameStackList = this.predictFrameStacks(breezeProgress, workflow, list, (List<RawFrame>)stringArray, list3, whiteReference.getReferenceTarget(), maxSignal, refSettings, measurement);
                RtFrameStackList.RealtimeFrameList realtimeFrameList2 = realtimeFrameList = bl2 ? rtFrameStackList.getReflectanceOrRawFrameList() : rtFrameStackList.getReferenceOrRawFrameList();
                if (outputFormat.isEnviFormat()) {
                    if (referenceConvertTo.equals((Object)RtFramePredictor.ReferenceConvertTo.None)) {
                        this.writeRawAndHeader(rawFile, sample, sampleImageMask.getBounds(), file, string, string2, bandNames, list, null, (String)object3, ExportSegmentations.createExtra(measurement, null, outputFormat, rectangle, bl), null, null);
                        if (!stringArray.isEmpty()) {
                            this.writeRawAndHeader(rawFile, sample, (Rectangle)serializable, file, "darkref_" + string, string2, bandNames, (List<? extends Frame>)stringArray, null, (String)object3, null, null, null);
                        }
                        if (!list3.isEmpty()) {
                            this.writeRawAndHeader(rawFile, sample, rectangle2, file, "whiteref_" + string, string2, bandNames, list3, null, (String)object3, null, whiteReference.getReferenceTarget(), null);
                        }
                    } else {
                        this.writeRawAndHeader(rawFile, sample, sampleImageMask.getBounds(), file, string, string2, bandNames, realtimeFrameList, DataSize.FLOAT_4, (String)object3, null, null, null);
                    }
                } else if (outputFormat.equals((Object)OutputFormat.Matlab)) {
                    object4 = new File(file, string + "." + string2);
                    new MatExport((File)object4).export(breezeProgress, realtimeFrameList, string);
                }
                new FileImageWriter(rawFrame.columns, rgbBands, MaxSignal.ForVisalization, workflow.getHistogramSettings()).write((File)object2, rtFrameStackList);
            } else {
                if (outputFormat.isEnviFormat()) {
                    this.writeRawAndHeader(rawFile, sample, sampleImageMask.getBounds(), file, string, string2, bandNames, list, null, (String)object3, ExportSegmentations.createExtra(measurement, null, outputFormat, rectangle, bl), null, null);
                } else if (outputFormat.equals((Object)OutputFormat.Matlab)) {
                    object4 = new File(file, string + "." + string2);
                    new MatExport((File)object4).export(breezeProgress, list, string);
                }
                new FileImageWriter(rawFrame.columns, rgbBands, maxSignal, workflow.getHistogramSettings()).write((File)object2, list);
            }
            if (outputFormat.equals((Object)OutputFormat.Matlab)) {
                MatExport.writeBandNames(bandNames, new File(file, string + "_layers." + string2));
            }
            if (outputFormat.isImageOnly()) {
                object4 = object2;
            }
            return object4;
        }

        protected String getExportName(Measurement measurement, Sample sample, boolean bl, String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(measurement.getName());
            if (bl) {
                stringBuilder.append("_");
                stringBuilder.append(sample.getIndexString().replace(':', '_'));
            }
            IdentifierList identifierList = measurement.getWorkflow().getIdentifiers();
            for (Identifier identifier : identifierList) {
                String string2 = identifier.getTextValue(sample);
                if (string2 == null || (string2 = string2.replaceAll("[^a-zA-Z0-9]", "")).isEmpty()) continue;
                stringBuilder.append("_");
                stringBuilder.append(identifier.getName());
                stringBuilder.append("=");
                stringBuilder.append(string2);
            }
            if (!string.isEmpty()) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        protected void writeXml(File file, String string, MetaDataProperties metaDataProperties) {
            File file2 = new File(file, string + ".xml");
            Document document = XmlParserHelper.createXMLdoc();
            Element element = XmlParserHelper.addRoot("measurement", document);
            EntryData entryData = new EntryData(null, "measurement", file2.getParentFile());
            entryData.writeXmlAttributes(element, "Measurement");
            DefaultXmlProperties defaultXmlProperties = new DefaultXmlProperties("settings");
            defaultXmlProperties.setPropertyBoolLocal("changed", true);
            XmlProperties.addProperties(defaultXmlProperties, document, element);
            metaDataProperties.writeMetadataToXml(element);
            XmlProperties.createDirectoriesAndOutputXML(file2, document);
        }

        protected final void writeRawAndHeader(RawFile rawFile, Sample sample, Rectangle rectangle, File file, String string, String string2, BandNames bandNames, List<? extends Frame> list, DataSize dataSize, String string3, ExtraHeaderValues extraHeaderValues, RtReferenceTarget rtReferenceTarget, RtInterleave rtInterleave) {
            RawHeader rawHeader;
            File file2 = new File(file, string + "." + string2);
            File file3 = new File(file, string + ".hdr");
            RgbBands rgbBands = null;
            ByteBuffer byteBuffer = null;
            if (rawFile != null) {
                rawHeader = rawFile.header();
                rgbBands = rawHeader.rgbBands();
                byteBuffer = rawFile.readRawHeader();
            }
            if (dataSize == null) {
                dataSize = list.getFirst().getType();
            }
            rawHeader = new RawHeader(file3, new FrameCount(list.size()), new BandCount(bandNames.size()), new PixelWidth(rectangle.width), dataSize, rgbBands, bandNames);
            rawHeader.setDescription(string3);
            rawHeader.setReferenceTarget(rtReferenceTarget);
            if (rtInterleave != null) {
                rawHeader.setInterleave(rtInterleave);
            }
            if (byteBuffer != null && byteBuffer.limit() > 0) {
                try {
                    HySpexHeader hySpexHeader = new HySpexHeader(byteBuffer);
                    hySpexHeader.crop(rectangle.y, rectangle.y + rectangle.height, rectangle.x, rectangle.x + rectangle.width, 0, hySpexHeader.spectralSize);
                    HySpexHeaderHelper.checkValues(hySpexHeader, rawHeader);
                    byteBuffer = hySpexHeader.createHeader();
                    if (extraHeaderValues != null) {
                        extraHeaderValues.add("data ignore value", RtDataFormat.toString(hySpexHeader.dataIgnoreValue));
                    }
                }
                catch (Exception exception) {
                    Logg.error((String)("Error parsing HySpex header: " + exception.getMessage()), (Object[])new Object[0]);
                }
            }
            RawFileWriter.writeFramesAndHeader(file2, list, rawHeader, string3 + "\n Breeze export of segmentation = " + ExportSegmentations.formatSample(sample) + "\n", null, extraHeaderValues, byteBuffer);
        }

        private static String formatSample(Sample sample) {
            if (sample instanceof RootSample) {
                return "Measurement";
            }
            return sample.toString();
        }

        private RtFrameStackList predictFrameStacks(BreezeProgress breezeProgress, Workflow workflow, List<RawFrame> list, List<RawFrame> list2, List<RawFrame> list3, RtReferenceTarget rtReferenceTarget, MaxSignal maxSignal, RtFramePredictor.RefSettings refSettings, Measurement measurement) {
            RawFrame rawFrame = list.getFirst();
            RtFramePredictor rtFramePredictor = new RtFramePredictor(breezeProgress, rawFrame.getRows(), rawFrame.getColumns(), rawFrame.getBandNames(), maxSignal, RtFramePredictor.FramePoolSettings.fromMin(true, list.size()), workflow, refSettings);
            SpectralReference.WhiteReference whiteReference = !list3.isEmpty() ? new SpectralReference.WhiteReference(list3) : new SpectralReference.EmptyWhiteReference();
            whiteReference.header().setReferenceTarget(rtReferenceTarget);
            SpectralReference.DarkReference darkReference = list2.isEmpty() ? new SpectralReference.EmptyDarkReference() : new SpectralReference.DarkReference(list2);
            int n = 0;
            ArrayList<RtFrameStack> arrayList = new ArrayList<RtFrameStack>();
            for (RawFrame rawFrame2 : list) {
                RtFrameStack rtFrameStack = rtFramePredictor.apply(rawFrame2, n, whiteReference, darkReference, measurement);
                arrayList.add(rtFrameStack);
                ++n;
            }
            rtFramePredictor.stop();
            return new RtFrameStackList(arrayList);
        }

        protected final List<RawFrame> createMaskFrames(RawFile rawFile, Rectangle rectangle, SampleImageMask sampleImageMask, int n, OutputData outputData, boolean bl) {
            return this.createMaskFrames(rawFile.readFrames(), rectangle, sampleImageMask, n, outputData, bl);
        }

        protected final List<RawFrame> createMaskFrames(List<RawFrame> list, Rectangle rectangle, final SampleImageMask sampleImageMask, final int n, OutputData outputData, final boolean bl) {
            ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
            if (list == null || list.isEmpty()) {
                return arrayList;
            }
            int n2 = list.size();
            final int n3 = list.get((int)0).columns.value;
            int n4 = bl ? n2 : rectangle.height;
            int n5 = bl ? n3 : rectangle.width;
            final int n6 = sampleImageMask != null ? sampleImageMask.getWidth() : 0;
            final int n7 = sampleImageMask != null ? sampleImageMask.getHeight() : 0;
            final boolean bl2 = outputData == OutputData.Sample;
            final int n8 = rectangle.x;
            final int n9 = rectangle.y;
            final int n10 = n8 + rectangle.width;
            final int n11 = n9 + rectangle.height;
            for (int i = 0; i < n4; ++i) {
                final int n12 = bl ? i : n9 + i;
                RawFrame rawFrame = list.get(Math.min(Math.max(0, n12 >= 0 && n12 < n2 ? n12 : 0), n2 - 1));
                BandCount bandCount = n < 0 ? rawFrame.getRows() : new BandCount(1);
                final int n13 = bandCount.value;
                BandNames bandNames = rawFrame.getBandNames();
                final RawFrame rawFrame2 = Frame.createFrame(rawFrame.getType(), bandCount, new PixelWidth(n5), n < 0 ? bandNames : new BandNames(bandNames.get(n)));
                if (n12 >= 0 && n12 < n2) {
                    final RawFrame rawFrame3 = list.get(n12);
                    new RtThreader(this){

                        @Override
                        protected void doOp(boolean bl3, int n14, int n2) {
                            for (int i = n14; i < n2; ++i) {
                                int n32;
                                int n4;
                                int n5;
                                int n62 = n5 = bl ? i : n8 + i;
                                if (n5 < 0 || n5 >= n3) {
                                    if (n < 0) {
                                        for (n4 = 0; n4 < n13; ++n4) {
                                            rawFrame2.setFrameValue(n4, i, 0.0f);
                                        }
                                        continue;
                                    }
                                    rawFrame2.setFrameValue(0, i, 0.0f);
                                    continue;
                                }
                                n4 = n5 >= n8 && n5 < n10 && n12 >= n9 && n12 < n11 ? 1 : 0;
                                boolean bl22 = false;
                                float f = 0.0f;
                                if (n4 != 0) {
                                    if (sampleImageMask != null) {
                                        n32 = n5 - n8;
                                        int n72 = n12 - n9;
                                        if (n32 >= 0 && n32 < n6 && n72 >= 0 && n72 < n7) {
                                            int n82 = n72 * n6 + n32;
                                            bl22 = sampleImageMask.hasData(n82);
                                            if (bl2 && bl22) {
                                                f = sampleImageMask.sampleValue(n82);
                                            }
                                        }
                                    } else {
                                        bl22 = true;
                                    }
                                }
                                if (bl22) {
                                    if (bl2) {
                                        rawFrame2.setFrameValue(0, i, f);
                                        continue;
                                    }
                                    if (n < 0) {
                                        for (n32 = 0; n32 < n13; ++n32) {
                                            rawFrame2.setFrameValue(n32, i, rawFrame3.getFrameValue(n32, n5));
                                        }
                                        continue;
                                    }
                                    rawFrame2.setFrameValue(0, i, rawFrame3.getFrameValue(n, n5));
                                    continue;
                                }
                                if (n < 0) {
                                    for (n32 = 0; n32 < n13; ++n32) {
                                        rawFrame2.setFrameValue(n32, i, 0.0f);
                                    }
                                    continue;
                                }
                                rawFrame2.setFrameValue(0, i, 0.0f);
                            }
                        }
                    }.execute(n5);
                }
                arrayList.add(rawFrame2);
            }
            return arrayList;
        }

        private MaxSignal getMaxSignal(Measurement measurement, RawFile rawFile, RgbBands rgbBands) {
            MetaDataProperties metaDataProperties = measurement.getMetaProperties();
            String string = metaDataProperties.getMetaValueNullIfMissing("MaxSignal");
            if (string != null && NiceDataFormat.isNumber((String)string)) {
                return new MaxSignal((float)NiceDataFormat.toNumber((String)string));
            }
            MaxSignal maxSignal = new MaxSignal(rawFile, rgbBands);
            metaDataProperties.addProperty("MaxSignal", RtDataFormat.toString(maxSignal.value));
            return maxSignal;
        }

        protected static ExtraHeaderValues createExtra(Measurement measurement, Factor factor, OutputFormat outputFormat, Rectangle rectangle, boolean bl) {
            Object object;
            ExtraHeaderValues extraHeaderValues = null;
            if (outputFormat.equals((Object)OutputFormat.EnviClassificationImage) && factor instanceof CategoryFactor) {
                object = (CategoryFactor)factor;
                extraHeaderValues = new ExtraHeaderValues("ENVI Classification");
                ((CategoryFactor)object).addExtraHeaderValues(extraHeaderValues);
            } else {
                extraHeaderValues = new ExtraHeaderValues("ENVI");
            }
            extraHeaderValues.add("\n");
            object = measurement.rawFile().header().getParser();
            if (bl) {
                extraHeaderValues.addValues(extraHeaderValues.updateParserGeoValues((RtHdrParser)object, 0, 0));
            } else {
                extraHeaderValues.addValues(extraHeaderValues.updateParserGeoValues((RtHdrParser)object, rectangle.x, rectangle.y));
            }
            extraHeaderValues.setBandKeyName("band names");
            return extraHeaderValues;
        }

        public record ExportOutput(File folder, String name, String ext, Measurement measurement, Sample sample) {
            public void deleteAndMkdirs() {
                if (this.folder.exists()) {
                    try {
                        FileUtils.deleteDirectory((File)this.folder);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
                this.folder.mkdirs();
            }

            public File file() {
                return new File(this.folder, this.name + "." + this.ext);
            }

            public boolean exits() {
                return this.file().exists();
            }
        }
    }

    public static enum OutputData {
        Pixels("Pixel predictions"),
        Sample("Object descriptor");

        private final String name;

        private OutputData(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getName() {
            return "Spectral pixel data";
        }

        @Override
        public String getDescription() {
            return "Hypercube from selected sample segmentation in (raw, radiance, reflectance, absorbance), mat or image format";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportSegmentation(entryMainPanel, string, object);
        }
    }
}

