/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.ConstrainedSpectralUnmixerDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.SpectralAngleMapperDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsMicaFile;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.RecordWorkflowPanel;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;

public class PPExportWorkflow
extends AbstractWizardPanel.AbstractExportWizard {
    private static final String endMemberDestinationFolder = "Data/Customize/Spectral libraries";
    private static final String endMemberWorkspaceRelative = "$workspace/Data/Customize/Spectral libraries/";
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeCheckBox includeStudyFilesCheckBox = new BreezeCheckBox("Include Record measurements", false);
    private final BreezeCheckBox includeConnectedModelFilesCheckBox = new BreezeCheckBox("Include Connected models", true);
    private final BreezeCheckBox includeConnectedEndMemberFilesCheckBox = new BreezeCheckBox("Include Connected end member files and groupings", true);
    private final BreezeCheckBox includePlayFilesCheckBox = new BreezeCheckBox("Include Workflow measurements", false);
    private final BreezeCheckBox openExplorerCheckBox = new BreezeCheckBox("Open file location after export", true);

    public PPExportWorkflow(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, PPTextHelper.getChooseWriteFilenameFolderDefaultText(), true);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Zip file (*.zip)");
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getDataPath(), PPExportHtml.createDefaultExportFileName((Entry)object, "zip"));
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("The export includes the workflow and connected models.\nUse options below to include more items\n\nPress Finish to complete export");
        this.viewClassList.add(new ViewClass("Settings", "Setting for export workflow", pPDescriptionPanel));
        this.includeStudyFilesCheckBox.setName("includeStudyFiles");
        pPDescriptionPanel.addOption(this.includeStudyFilesCheckBox);
        pPDescriptionPanel.addOption(this.includeConnectedModelFilesCheckBox);
        this.includePlayFilesCheckBox.setName("includePlayFiles");
        pPDescriptionPanel.addOption(this.includePlayFilesCheckBox);
        this.openExplorerCheckBox.setName("openExplorer");
        pPDescriptionPanel.addOption(this.openExplorerCheckBox);
        pPDescriptionPanel.addBottomOption(new BreezeInfoPanel(BreezeInfoPanel.InfoType.Note, Workflow.getWorkflow(object).formatNumberGroupsAndMeasurements() + " will be exported"));
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportWorkflow this$0;
                {
                    this.this$0 = pPExportWorkflow;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    if (this.this$0.openExplorerCheckBox.isSelected()) {
                        FileHelper.openExplorerOnPath(file.getParentFile());
                    }
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Exporting workflow and connected models to archive file");
                    PPExportWorkflow.export(this.getProgressManager(), Workflow.getWorkflow(this.this$0.entryData), file, true, this.this$0.includeStudyFilesCheckBox.isSelected(), this.this$0.includeConnectedModelFilesCheckBox.isSelected(), this.this$0.includePlayFilesCheckBox.isSelected(), this.this$0.includeConnectedEndMemberFilesCheckBox.isSelected());
                }
            }, "Export workflow");
        }
    }

    protected static void export(BreezeProgress breezeProgress, Workflow workflow, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ZipManager zipManager = new ZipManager(file);
        Workflow workflow2 = BreezeMasterCache.getInstance().getStudyList().byId(workflow.getStudyId());
        if (workflow2 != null) {
            PPExportWorkflow.addFolderOrXmlFile(workflow2, bl2, bl5, zipManager);
        }
        if (bl3) {
            for (BasicAnalyse basicAnalyse : workflow.getConnectedAnalysis()) {
                PPExportWorkflow.addModel(bl, zipManager, basicAnalyse);
            }
        }
        PPExportWorkflow.addFolderOrXmlFile(workflow, bl4, bl5, zipManager);
        zipManager.perform(breezeProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFolderOrXmlFile(Workflow workflow, boolean bl, boolean bl2, ZipManager zipManager) {
        String string = workflow.getType().name();
        File file = workflow.getXml();
        ArrayList<Pair<TextParameter, String>> arrayList = new ArrayList<Pair<TextParameter, String>>();
        try {
            Pair<TextParameter, String> pair;
            boolean bl3 = false;
            if (bl2) {
                bl3 = PPExportWorkflow.setFilesToWorkflowRelative(workflow, zipManager, arrayList);
            }
            if (bl2 && FileHelper.exists((File)(pair = GroupingUtils.getGroupingsDirectory()))) {
                zipManager.addFolder((File)pair, "Data/Customize");
            }
            if (bl3) {
                file = FileHelper.createTempFileInWorkspace("xml");
                workflow.saveNoChangeIndex(file);
            }
            if (bl) {
                zipManager.addFolder(workflow.getFolder(), string);
            }
            zipManager.addFile(file, string + "/" + workflow.getName(), workflow.getXml().getName(), true);
        }
        catch (Throwable throwable) {
            for (Pair pair : arrayList) {
                ((TextParameter)pair.getLeft()).setValueStr((String)pair.getRight());
            }
            throw throwable;
        }
        for (Pair<TextParameter, String> pair : arrayList) {
            ((TextParameter)pair.getLeft()).setValueStr((String)pair.getRight());
        }
    }

    private static boolean setFilesToWorkflowRelative(Workflow workflow, ZipManager zipManager, ArrayList<Pair<TextParameter, String>> arrayList) {
        boolean bl = false;
        for (DescriptorTreeNode descriptorTreeNode : workflow.getAllDescriptorNodes()) {
            AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
            if (abstractBreezeFunction instanceof SpectralAngleMapperDescriptor || abstractBreezeFunction instanceof ConstrainedSpectralUnmixerDescriptor) {
                bl = PPExportWorkflow.updateEndMemberFiles(workflow, abstractBreezeFunction, zipManager, arrayList);
                continue;
            }
            if (!(abstractBreezeFunction instanceof UsgsDescriptor)) continue;
            UsgsDescriptor usgsDescriptor = (UsgsDescriptor)abstractBreezeFunction;
            for (int i = 1; i <= 5; ++i) {
                FileParameter fileParameter;
                String string = "library" + (String)(i > 1 ? "" + i : "");
                Object object = usgsDescriptor.getParameterByName(string);
                if (!(object instanceof FileParameter) || FileHelper.notExists((File)(object = (fileParameter = (FileParameter)object).getFile(workflow)))) continue;
                UsgsMicaFile usgsMicaFile = new UsgsMicaFile((File)object, workflow);
                File file = new File(((File)object).getParentFile(), usgsMicaFile.getDnColorsFile().getName());
                if (usgsMicaFile.getDnColorsFile().exists()) {
                    zipManager.addFile(usgsMicaFile.getDnColorsFile(), endMemberDestinationFolder);
                } else if (file.exists()) {
                    zipManager.addFile(file, endMemberDestinationFolder);
                }
                if (usgsMicaFile.getSpecprFile().exists()) {
                    zipManager.addFile(usgsMicaFile.getSpecprFile(), endMemberDestinationFolder);
                }
                zipManager.addFile((File)object, endMemberDestinationFolder);
                arrayList.add((Pair<TextParameter, String>)Pair.of((Object)fileParameter, (Object)fileParameter.getText()));
                fileParameter.setValueStr(endMemberWorkspaceRelative + ((File)object).getName());
                bl = true;
            }
        }
        return bl;
    }

    private static boolean updateEndMemberFiles(Workflow workflow, AbstractBreezeFunction abstractBreezeFunction, ZipManager zipManager, ArrayList<Pair<TextParameter, String>> arrayList) {
        boolean bl = false;
        for (int i = 1; i <= 10; ++i) {
            MembersSetting.EndMemberFileParameter endMemberFileParameter;
            String string = "endMember" + i;
            Object object = abstractBreezeFunction.getParameterByName(string);
            if (!(object instanceof MembersSetting.EndMemberFileParameter) || FileHelper.notExists((File)(object = (endMemberFileParameter = (MembersSetting.EndMemberFileParameter)object).getFile(workflow)))) continue;
            if (!zipManager.addFile((File)object, endMemberDestinationFolder) && zipManager.addFile((File)(object = FileHelper.copyToTempFile((File)object, string + "_")), endMemberDestinationFolder)) {
                throw new FileAlreadyExistsException("File already exists: " + ((File)object).getName());
            }
            arrayList.add((Pair<TextParameter, String>)Pair.of((Object)endMemberFileParameter, (Object)endMemberFileParameter.getText()));
            endMemberFileParameter.setValueStr(endMemberWorkspaceRelative + ((File)object).getName());
            bl = true;
        }
        return bl;
    }

    public static void includeAllModels(boolean bl, ZipManager zipManager, Workflow workflow) {
        List<BasicAnalyse> list = RecordWorkflowPanel.filter(BreezeMasterCache.getInstance().getAnalyseList(), new BreezeFilter.AnalyseStudy(workflow));
        for (BasicAnalyse basicAnalyse : workflow.getConnectedAnalysis()) {
            PPExportWorkflow.addModel(bl, zipManager, basicAnalyse);
            list.remove(basicAnalyse);
        }
        for (BasicAnalyse basicAnalyse : list) {
            PPExportWorkflow.addModel(bl, zipManager, basicAnalyse);
        }
    }

    public static void addModel(boolean bl, ZipManager zipManager, BasicAnalyse basicAnalyse) {
        if (basicAnalyse instanceof Analyse) {
            File file;
            Analyse analyse = (Analyse)basicAnalyse;
            zipManager.addFile(analyse.getXml(), "Model/" + analyse.getName());
            File file2 = analyse.getProjectFile();
            if (bl && file2.exists()) {
                zipManager.addFile(file2, "Model/" + analyse.getName());
            }
            if ((file = analyse.getOnnxFile()).exists()) {
                zipManager.addFile(file, "Model/" + analyse.getName());
            }
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "Project workflow with connected models";
        }

        @Override
        public String getName() {
            return "Project";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportWorkflow(entryMainPanel, string, object);
        }
    }
}

