/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportWorkflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.test.MockBreezePropertiesAndMasterCache;
import se.prediktera.breeze.util.ZipManager;

public class PPExportWorkflowTest
extends MockBreezePropertiesAndMasterCache {
    @Test
    public void exportWorkflow() {
        BreezeMasterCache.clearInstance();
        BreezeProgressManager breezeProgressManager = BreezeProgressManager.createEmpty();
        File file = this.tempFolder.getRoot();
        File file2 = new File(file, "Record");
        file2.mkdirs();
        Workflow workflow = new Workflow("studyA", file2);
        workflow.save();
        Group group = new Group("groupA", workflow);
        group.save();
        Measurement measurement = new Measurement("m1", group);
        measurement.save();
        BreezeMasterCache.getInstance().getStudyList().add(workflow);
        File file3 = new File(file, "Play");
        file3.mkdirs();
        Workflow workflow2 = new Workflow("workflowA", file3);
        workflow2.setStudyId(workflow.getUid());
        workflow2.save();
        Analyse analyse = new Analyse("modelA");
        analyse.save();
        this.add(workflow2, analyse);
        File file4 = new File(file, "archive.zip");
        PPExportWorkflow.export(breezeProgressManager, workflow2, file4, false, false, true, false, false);
        ZipManager zipManager = new ZipManager(file4);
        File file5 = new File(file, "test");
        zipManager.extractAll(breezeProgressManager, file5.toPath(), true);
        MatcherAssert.assertThat((String)"study", (Object)new File(file5, "Record/studyA/workflow.xml").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"studyGroup", (Object)new File(file5, "Record/studyA/groupA").exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"studyMeasurement", (Object)new File(file5, "Record/studyA/groupA/m1").exists(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"analyse", (Object)new File(file5, "Model/modelA/model.xml").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"workflow", (Object)new File(file5, "Play/workflowA/workflow.xml").exists(), (Matcher)Matchers.is((Object)true));
        PPExportWorkflow.export(breezeProgressManager, workflow2, file4, false, true, true, false, false);
        ZipManager zipManager2 = new ZipManager(file4);
        File file6 = new File(file, "test");
        zipManager2.extractAll(breezeProgressManager, file6.toPath(), true);
        MatcherAssert.assertThat((String)"study", (Object)new File(file6, "Record/studyA/workflow.xml").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"studyGroup", (Object)new File(file6, "Record/studyA/groupA").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"studyMeasurement", (Object)new File(file6, "Record/studyA/groupA/m1").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"analyse", (Object)new File(file6, "Model/modelA/model.xml").exists(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"workflow", (Object)new File(file6, "Play/workflowA/workflow.xml").exists(), (Matcher)Matchers.is((Object)true));
    }

    private void add(Workflow workflow, Analyse analyse) {
        FunctionTreeNode functionTreeNode = FunctionHelper.createNew(new PlsPredQuantificationDescriptor.Info());
        PlsPredQuantificationDescriptor plsPredQuantificationDescriptor = (PlsPredQuantificationDescriptor)functionTreeNode.getFunction();
        plsPredQuantificationDescriptor.setAnalyse(analyse);
        workflow.getRoot().addChild(functionTreeNode);
        BreezeMasterCache.getInstance().getAnalyseList().add(analyse);
    }
}

