/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.swing.filechooser.FileTools;

public class PPImportGroup
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel = new FileChooserPanel(this, "Select group file and press Finish.", false);

    public PPImportGroup(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, null);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Zip files (*.zip)");
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getDataPath());
        this.viewClassList.add(new ViewClass("Select file(s)", "Select group file", this.fileSelectionPanel));
        this.setLists(this.viewClassList);
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void runAction() throws IOException {
                this.setInfoText("Importing...");
                Workflow workflow = Workflow.getWorkflow(PPImportGroup.this.mainPanel.getSelectedEntry());
                for (File file2 : PPImportGroup.this.fileSelectionPanel.getSelectedFiles()) {
                    if (!FileTools.hasExtension((File)file2, (String)"zip")) {
                        long l = FileUtils.sizeOfDirectory((File)file2) / 1024L;
                        this.getProgressManager().setMaximumAndReset((int)l);
                        FileFilter fileFilter = file -> {
                            this.getProgressManager().incStep((int)(file.length() / 1024L));
                            return true;
                        };
                        if (!1.isGroupFolder(file2)) continue;
                        FileUtils.copyDirectory((File)file2, (File)new File(workflow.getFolder(), file2.getName()), (FileFilter)fileFilter);
                        continue;
                    }
                    new ZipManager(file2).extractAllShowWarning(PPImportGroup.this.frame, this.getProgressManager(), workflow.getFolder().toPath(), true, "group.xml", 2);
                }
                workflow.clearChildList();
                PPImportGroup.this.mainPanel.setEntryListModel(workflow.getChildList());
                PPImportGroup.this.mainPanel.selectEntry(PPImportGroup.this.mainPanel.getEntryList().getEntryByNameOrFirst(FileHelper.getFileName(PPImportGroup.this.fileSelectionPanel.getSelectedFile())));
            }

            private static boolean isGroupFolder(File file) {
                if (file.isDirectory()) {
                    return new File(file, "group.xml").exists();
                }
                return false;
            }
        }, "Importing groups");
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getName() {
            return "Groups";
        }

        @Override
        public String getDescription() {
            return "Groups (exported by Breeze)";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportGroup(entryMainPanel, string, object);
        }
    }
}

