/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.swing.filechooser.FileTools;

public class PPImportMeasurement
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel = new FileChooserPanel(this, "Select measurement file and press Finish.", false);

    public PPImportMeasurement(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, null);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Zip files (*.zip)");
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getDataPath());
        this.viewClassList.add(new ViewClass("Select file(s)", "Select measurement file", this.fileSelectionPanel));
        this.setLists(this.viewClassList);
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    @Override
    protected void finishWizard() {
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void runAction() throws IOException {
                this.setInfoText("Importing...");
                Group group = Group.getGroup(PPImportMeasurement.this.mainPanel.getSelectedEntry());
                for (File file2 : PPImportMeasurement.this.fileSelectionPanel.getSelectedFiles()) {
                    if (!FileTools.hasExtension((File)file2, (String)"zip")) {
                        long l = FileUtils.sizeOfDirectory((File)file2) / 1024L;
                        this.getProgressManager().setMaximumAndReset((int)l);
                        FileFilter fileFilter = file -> {
                            this.getProgressManager().incStep((int)(file.length() / 1024L));
                            return true;
                        };
                        if (!1.isMeasurementFolder(file2)) continue;
                        FileUtils.copyDirectory((File)file2, (File)new File(group.getFolder(), file2.getName()), (FileFilter)fileFilter);
                        continue;
                    }
                    new ZipManager(file2).extractAllShowWarning(PPImportMeasurement.this.frame, this.getProgressManager(), group.getFolder().toPath(), true, "measurement.xml", 2);
                }
                group.syncToExisting(this.getProgressManager());
                PPImportMeasurement.this.mainPanel.selectEntry(PPImportMeasurement.this.mainPanel.getEntryList().getEntryByNameOrFirst(FileHelper.getFileName(PPImportMeasurement.this.fileSelectionPanel.getSelectedFile())));
            }

            private static boolean isMeasurementFolder(File file) {
                if (file.isDirectory()) {
                    return new File(file, "measurement.xml").exists();
                }
                return false;
            }
        }, "Importing measurements");
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getName() {
            return "Measurements";
        }

        @Override
        public String getDescription() {
            return "Breeze Measurements";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportMeasurement(entryMainPanel, string, object);
        }
    }
}

