/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.ImportSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.swing.filechooser.FileTools;

public class PPImportModel
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeMasterCache masterCache = BreezeMasterCache.getInstance();
    private final OnnxImportData onnxImportDataSettings = new OnnxImportData();

    public PPImportModel(EntryMainPanel entryMainPanel, String string) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, null);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select model file and press Finish.", false);
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Archive model");
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getDataPath());
        this.viewClassList.add(new ViewClass("Select file(s)", "Select model file", this.fileSelectionPanel));
        ImportSettingsPanel importSettingsPanel = new ImportSettingsPanel(this.fileSelectionPanel, this.onnxImportDataSettings);
        this.viewClassList.add(new ViewClass("Settings", "Setting for file import", importSettingsPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.getSelectedFile();
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        final File file2 = workspace.getFolder();
        final File file3 = workspace.getModelPath();
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
            final /* synthetic */ PPImportModel this$0;
            {
                this.this$0 = pPImportModel;
                super(abstractWizardPanel);
            }

            @Override
            public void runAction() throws IOException {
                Analyse analyse = this.importAnalyse(file, file2, file3);
                if (analyse != null) {
                    this.this$0.setAnalyseValues(analyse);
                }
            }

            private Analyse importAnalyse(File file22, File file32, File file4) throws IOException {
                if (this.this$0.onnxImportDataSettings.modelMethod != null) {
                    Analyse analyse = new Analyse(FilenameUtils.getBaseName((String)file22.getName()), this.this$0.onnxImportDataSettings.modelMethod);
                    analyse.save();
                    FileUtils.copyFile((File)file22, (File)analyse.getOnnxFile());
                    return analyse;
                }
                this.setInfoText("Importing...");
                if (!FileTools.hasExtension((File)file22, (String)"zip")) {
                    long l = FileUtils.sizeOfDirectory((File)file22) / 1024L;
                    this.getProgressManager().setMaximumAndReset((int)l);
                    FileFilter fileFilter = file -> {
                        this.getProgressManager().incStep((int)(file.length() / 1024L));
                        return true;
                    };
                    FileUtils.copyDirectory((File)file22, (File)file4, (FileFilter)fileFilter);
                    return new Analyse(new File(file4, FilenameUtils.getBaseName((String)file22.getName())));
                }
                List<File> list = new ZipManager(file22).extractAllShowWarning(this.this$0.getFrame(), this.getProgressManager(), file32.toPath(), true, "model.xml", 3);
                if (list.size() > 0) {
                    return new Analyse(list.get(0).getParentFile());
                }
                return null;
            }
        }, "Importing model");
    }

    private void setAnalyseValues(Analyse analyse) {
        analyse.setStudyId(((ModelMainPanel)this.mainPanel).getStudyContext().getUid());
        analyse.save();
        this.masterCache.getAnalyseList().add(analyse);
        this.mainPanel.selectEntry(analyse);
    }

    @Generated
    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    public static class OnnxImportData {
        private BasicAnalyse.ModelMethod modelMethod;

        @Generated
        public void setModelMethod(BasicAnalyse.ModelMethod modelMethod) {
            this.modelMethod = modelMethod;
        }
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Archived model from file";
        }

        @Override
        public String getName() {
            return "Model";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportModel(entryMainPanel, string);
        }
    }
}

