/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportEvinceModel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTabbedPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.wizard.WizardPageClass;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.AbstractImportPanel;
import se.prediktera.map.dataimport.ImportInterface;
import se.prediktera.map.dataimport.MultiImportPanel;
import se.prediktera.map.dataimport.identifier.CellIdentifierPanel;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataContainer;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.simpletableeditor.CellIdentifierModel;

public class PPImportSpectra
extends AbstractWizardPanel.AbstractImportWizard
implements ImportInterface {
    private final BreezeCheckBox applyCheckBox;
    private final FileChooserPanel fileSelectionPanel;
    private AbstractImportPanel importPanel;
    private AbstractImportInfo importInfo;
    private final Group group;
    private MultiImportPanel multiImportPanel;

    public PPImportSpectra(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.group = this.getGroup(object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select files to import. Use Shift or Ctrl + click to multi select. Click Next to continue.", false){

            @Override
            public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
                if (super.checkValidContent(wizardControlCallback).ok()) {
                    List<File> list = PPImportSpectra.this.fileSelectionPanel.getSelectedFiles();
                    if (list != null) {
                        PPImportSpectra.this.setImportPanel(PPImportSpectra.this.fileSelectionPanel.getMatchingFilter(), list);
                    }
                    return WizardStep.LeaveResult.Ok;
                }
                return WizardStep.LeaveResult.Failed;
            }
        };
        this.fileSelectionPanel.addDataFileFilters(FileChooserPanel.FilterType.DATA2D);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Settings for file import. Press Finish to complete import");
        this.viewClassList.add(new ViewClass("Select file(s)", "Select files to import. Use Shift or Ctrl + click to multi select. Click Next to continue.", this.fileSelectionPanel));
        this.applyCheckBox = new BreezeCheckBox("Automatically apply workflow to imported files", true);
        pPDescriptionPanel.addOption(this.applyCheckBox);
        this.applyCheckBox.setName("applychanges");
        this.viewClassList.add(new ViewClass("Settings", "Setting for file import", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    public void setImportPanel(AbstractImportInfo abstractImportInfo, List<File> list) {
        this.importInfo = abstractImportInfo;
        while (this.viewClassList.size() > 1) {
            this.viewClassList.remove(1);
        }
        this.multiImportPanel = null;
        if (list.size() > 1) {
            if (abstractImportInfo.getMultipleMergeTypes() == 0) {
                throw new ErrorHandler.InformationMessageException("Merge of multiple files is not supported for selected file format(s).\nPlease try to use the \"Merge different files\" tab instead");
            }
            this.multiImportPanel = new MultiImportPanel(abstractImportInfo, this.getFiles());
            this.viewClassList.add(new ImportPageViewClass("Merge", "Merge multiple files", "", (WizardPageClass)this.multiImportPanel));
        }
        this.importPanel = abstractImportInfo.getImportPanel((ImportInterface)this, null);
        if (this.importPanel.hasSettings()) {
            this.viewClassList.add(new ImportPageViewClass(this.importPanel.getType(), "Settings for file import", "", (WizardPageClass)this.importPanel));
        }
        this.viewClassList.add(new ImportPageViewClass("Identify", "Identify data", "", (WizardPageClass)new CellIdentifierPanel(null, abstractImportInfo.isMultiLayer(), false, true)));
        this.setLists(this.viewClassList);
        if (this.viewClassList.size() > 1) {
            this.enterFirstStep();
            this.enterStep(1);
        }
    }

    public Group getGroup(Object object) {
        Group group = Group.getGroup(object);
        if (group != null) {
            return group;
        }
        throw new ErrorHandler.InformationMessageException("No Group to import into.\nPlease add a Group and try again.");
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void onFinish() {
                PPImportSpectra.this.mainPanel.selectTab("Table");
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Importing...");
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                Project_GUI project_GUI = PPImportSpectra.this.importData(this.getProgressManager());
                DataSet dataSet = project_GUI.getPrimaryCase().getOriginalDataSet();
                dataSet.getOriginalMatrix().setName(FileHelper.getFileName(PPImportSpectra.this.fileSelectionPanel.getSelectedFile()));
                List<Measurement> list = new PPImportEvinceModel.ImportFromEvince(PPImportSpectra.this.group).apply(breezeProgressManager, dataSet, PPImportEvinceModel.ImportFromEvince.ImportDataType.Single);
                if (PPImportSpectra.this.applyCheckBox.isSelected()) {
                    ApplyChanges.applyChanges((BreezeProgress)breezeProgressManager, list);
                }
                project_GUI.closeProject(false);
                System.gc();
            }
        }, "Importing data");
    }

    private Project_GUI importData(ProgressManager progressManager) {
        Project_GUI project_GUI = Project_GUI.createNewProject((boolean)false);
        Case case_ = project_GUI.getPrimaryCase();
        progressManager.setInfoText("Checking file");
        CellIdentifierModel cellIdentifierModel = this.importPanel.getCellIdentifierModel(progressManager);
        this.importPanel.finishIdentify(progressManager);
        boolean bl = case_.importCaseFromModel(cellIdentifierModel, project_GUI, progressManager, new Properties());
        if (bl) {
            DataContainer dataContainer;
            if (this.importInfo != null) {
                this.importInfo.finishImport(progressManager, project_GUI, case_, null);
            }
            if ((dataContainer = case_.getDsContainer()) != null && dataContainer.getTreeNodeCount() > 0) {
                project_GUI.updateDataTree(dataContainer.getTreeNodeAt(0));
            }
            if (!cellIdentifierModel.isDataSource()) {
                if (this.importInfo.supportDataSource()) {
                    cellIdentifierModel.closeConnections();
                } else {
                    cellIdentifierModel.cleanUp();
                }
            }
        }
        return project_GUI;
    }

    public File[] getFiles() {
        List<File> list = this.fileSelectionPanel.getSelectedFiles();
        return list.toArray(new File[0]);
    }

    public byte getMergeType() {
        if (this.multiImportPanel != null) {
            return this.multiImportPanel.getMergeType();
        }
        return 0;
    }

    public boolean includeFileNames() {
        return true;
    }

    public static void setTheme(Component component) {
        JComponent jComponent;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        component.setForeground(breezeTheme.getLabelForeground());
        component.setBackground(breezeTheme.getPanelBackground());
        if (component instanceof JTable) {
            jComponent = (JTable)component;
            ((JTable)jComponent).setSelectionBackground(breezeTheme.getSelectionBackground());
            ((JTable)jComponent).setGridColor(breezeTheme.getTableGridColor());
            var7_3 = ((JTable)jComponent).getTableHeader();
            ((JComponent)var7_3).setBackground(breezeTheme.getSettingPanelBackground());
            ((JComponent)var7_3).setForeground(breezeTheme.getLabelForegroundDifuse());
        } else if (component instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)component;
            var8_6 = jScrollPane.getBorder();
            if (var8_6 instanceof TitledBorder) {
                var7_3 = (TitledBorder)var8_6;
                ((TitledBorder)var7_3).setTitleColor(breezeTheme.getLabelForeground());
            }
            PPImportSpectra.setTheme(jScrollPane.getViewport());
        } else if (component instanceof JPanel) {
            JPanel jPanel = (JPanel)component;
            var8_6 = jPanel.getBorder();
            if (var8_6 instanceof TitledBorder) {
                var7_3 = (TitledBorder)var8_6;
                ((TitledBorder)var7_3).setTitleColor(breezeTheme.getLabelForeground());
            }
        } else if (component instanceof JTabbedPane) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            jTabbedPane.setUI(new BreezeTabbedPanel.BreezeTabbedPaneUI());
        } else if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            jButton.setForeground(Color.red);
            jButton.setBackground(Color.green);
        }
        if (component instanceof JComponent) {
            jComponent = (JComponent)component;
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                PPImportSpectra.setTheme(jComponent.getComponent(i));
            }
        }
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    private class ImportPageViewClass
    extends ViewClass {
        public ImportPageViewClass(String string, String string2, String string3, final WizardPageClass wizardPageClass) {
            super(string, string2, null);
            PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel(this, string3, false){
                final /* synthetic */ ImportPageViewClass this$1;
                {
                    this.this$1 = importPageViewClass;
                    super(string, bl);
                }

                @Override
                public void showEntry(Object object, Object object2) {
                    if (wizardPageClass instanceof AbstractImportPanel) {
                        AbstractImportPanel abstractImportPanel = (AbstractImportPanel)wizardPageClass;
                        abstractImportPanel.updateInfo((ImportInterface)this.this$1.PPImportSpectra.this);
                    } else if (wizardPageClass instanceof CellIdentifierPanel) {
                        CellIdentifierModel cellIdentifierModel;
                        CellIdentifierPanel cellIdentifierPanel = (CellIdentifierPanel)wizardPageClass;
                        if (this.this$1.PPImportSpectra.this.importPanel != null && (cellIdentifierModel = this.this$1.PPImportSpectra.this.importPanel.getCashedCiModel()) != null) {
                            cellIdentifierPanel.setLayoutFromLayers(cellIdentifierModel.isMultiLayer(), cellIdentifierModel.isMultiImport());
                        }
                        BreezeProgressDialog.startProgress(this.this$1.PPImportSpectra.this.mainPanel.getFrame(), breezeProgressManager -> {
                            breezeProgressManager.setInfoText("Checking file");
                            if (this.this$1.PPImportSpectra.this.importPanel != null) {
                                cellIdentifierPanel.setTableModel((ProgressManager)breezeProgressManager, this.this$1.PPImportSpectra.this.importPanel.getCellIdentifierModel((ProgressManager)breezeProgressManager, false), true);
                            }
                        }, "Checking file");
                    }
                }
            };
            pPDescriptionPanel.addOptionFillBoth((JComponent)wizardPageClass);
            this.setPanel(pPDescriptionPanel);
        }
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Single spectrum (i.e. txt or csv files)";
        }

        @Override
        public String getName() {
            return "Spectrum";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportSpectra(entryMainPanel, string, object);
        }
    }
}

