/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.ImportFromEvince;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;

public class PPImportValues
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final BreezeCheckBoxInputField caseSensitiveCheckBox = new BreezeCheckBoxInputField("Case sensitive", false, null);
    private final BreezeComboBoxInputField<Delimiter> delimiterComboBox = new BreezeComboBoxInputField("Delimeter", "", BreezeInputFieldHelper.Format.OneRow);
    private final DataPanel dataPanel = new DataPanel();
    private final List<DataSet> dataSets = new ArrayList<DataSet>();
    private final Workflow workflow;

    public PPImportValues(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, BreezeType.Project, string, object);
        this.workflow = Workflow.getWorkflow(object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select file and delimiter for value import and press Next", false){

            @Override
            public WizardStep.LeaveResult checkValidContent(final WizardStep.WizardControlCallback wizardControlCallback) {
                if (super.checkValidContent(wizardControlCallback).ok()) {
                    PPImportValues.this.enabledNextButton(false);
                    BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void runAction() throws Exception {
                            this.this$1.PPImportValues.this.closeDataSet();
                            for (File file : this.this$1.PPImportValues.this.fileSelectionPanel.getSelectedFiles()) {
                                this.this$1.PPImportValues.this.dataSets.add(ImportFromEvince.loadFile(this.getProgressManager(), file, this.this$1.PPImportValues.this.delimiterComboBox.getSelectedItem()));
                            }
                            this.this$1.PPImportValues.this.dataPanel.setData(this.this$1.PPImportValues.this.workflow, this.this$1.PPImportValues.this.dataSets.get(0), ImportFromEvince.ImportType.MeasurementName);
                            wizardControlCallback.leaveWithControl();
                        }
                    }, "Loading data", 0);
                }
                return WizardStep.LeaveResult.Failed;
            }
        };
        this.fileSelectionPanel.addDataFileFilters(FileChooserPanel.FilterType.DATA2D);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        this.fileSelectionPanel.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getImportPath());
        this.delimiterComboBox.setLabelWidth(120);
        for (Delimiter delimiter : Delimiter.values()) {
            this.delimiterComboBox.addItem(delimiter);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 20, 0);
        this.fileSelectionPanel.add(this.delimiterComboBox, gridBagConstraints);
        this.viewClassList.add(new ViewClass("Select file", "Select file for value import", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Select to automatically create Properties or Categories that does not exist in study.\nNote. The matching column in the data file should be the first column or have the header name \"Measurement\"\nPress Finish to complete import");
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.init(this.workflow);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        this.caseSensitiveCheckBox.setLabelWidth(120);
        pPDescriptionPanel.addOption(this.caseSensitiveCheckBox);
        pPDescriptionPanel.addOption(new BreezeLabel("Select data columns to import"));
        pPDescriptionPanel.addOption(this.dataPanel);
        this.viewClassList.add(new ViewClass("Settings", "Setting for file value import", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    public void backButtonClicked() {
        super.backButtonClicked();
        this.closeDataSet();
    }

    private void closeDataSet() {
        this.dataSets.forEach(DataSet::close);
        this.dataSets.clear();
    }

    @Override
    protected void finishWizard() {
        BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void onFinish() {
                PPImportValues.this.mainPanel.selectTab("Table");
            }

            @Override
            public void runAction() throws Exception {
                List<Measurement> list = this.getMeasurements();
                if (list.size() > 0) {
                    Workflow workflow = list.get(0).getWorkflow();
                    new ImportFromEvince(PPImportValues.this.dataSets, workflow, list, PPImportValues.this.dataPanel.getDataInfoList(), PPImportValues.this.segmentationComboBox.getSelectedIndex(), PPImportValues.this.caseSensitiveCheckBox.isSelected());
                    PPImportValues.this.closeDataSet();
                    workflow.save();
                }
            }

            private List<Measurement> getMeasurements() {
                ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
                if (PPImportValues.this.entryData instanceof Measurement) {
                    arrayList.add((Measurement)PPImportValues.this.entryData);
                } else if (PPImportValues.this.entryData instanceof Group) {
                    arrayList.addAll(MeasurementDataSource.getSortedMeasurements((Group)PPImportValues.this.entryData));
                } else if (PPImportValues.this.entryData instanceof Workflow) {
                    for (Group group : ((Workflow)PPImportValues.this.entryData).getChildList()) {
                        arrayList.addAll(MeasurementDataSource.getSortedMeasurements(group));
                    }
                }
                return arrayList;
            }
        }, "Import values");
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    public static class DataPanel
    extends JPanel {
        public DataPanel() {
            super(new GridBagLayout());
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        }

        public List<ImportFromEvince.DataInfo> getDataInfoList() {
            ArrayList<ImportFromEvince.DataInfo> arrayList = new ArrayList<ImportFromEvince.DataInfo>();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof DataRowPanel)) continue;
                arrayList.add(((DataRowPanel)component).getDataInfo());
            }
            return arrayList;
        }

        public void setData(Workflow workflow, DataSet dataSet, ImportFromEvince.ImportType importType) {
            String string;
            this.removeAll();
            AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
            int n = this.getMeasurementColumn(abstractDataMatrix);
            Description description = abstractDataMatrix.getRowDescription();
            for (int i = 0; i < description.getColumnCount(); ++i) {
                string = description.getColumnName(i);
                ImportFromEvince.ImportType importType2 = i == n ? importType : ImportFromEvince.ImportType.Category;
                this.add((Component)new DataRowPanel(workflow, string, importType2, false, i), GridBagHelper.create(this.getComponentCount(), new Insets(10, 20, 0, 0)));
            }
            Description description2 = abstractDataMatrix.getColumnDescription();
            string = (InnerColumnString)description2.getPrimaryColumn();
            for (int i = 0; i < string.getSize(); ++i) {
                this.add((Component)new DataRowPanel(null, string.getValueLocal(i), ImportFromEvince.ImportType.PropertyQuantification, true, i), GridBagHelper.create(this.getComponentCount(), new Insets(10, 20, 0, 0)));
            }
            this.add((Component)new JLabel(""), GridBagHelper.createLast(this.getComponentCount(), new Insets(10, 0, 0, 0)));
        }

        private int getMeasurementColumn(AbstractDataMatrix abstractDataMatrix) {
            Description description = abstractDataMatrix.getRowDescription();
            for (int i = 0; i < description.getColumnCount(); ++i) {
                String string = description.getColumnName(i);
                if (!string.equalsIgnoreCase("Measurement")) continue;
                return i;
            }
            return 0;
        }

        private static class DataRowPanel
        extends JPanel {
            private final BreezeLabel label = new BreezeLabel();
            private final BreezeComboBox comboBox = new BreezeComboBox();
            private final boolean data;
            private final int column;

            public DataRowPanel(Workflow workflow, String string, ImportFromEvince.ImportType importType, boolean bl, int n) {
                super(new GridBagLayout());
                this.data = bl;
                this.column = n;
                this.setBackground(BreezeTheme.getInstance().getPanelBackground());
                this.label.setText(string);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 20, 0, 0);
                this.add((Component)this.label, gridBagConstraints);
                this.label.setPreferredSize(new Dimension(300, 30));
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.fill = 0;
                gridBagConstraints2.anchor = 17;
                gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
                this.add((Component)this.comboBox, gridBagConstraints2);
                this.comboBox.setPreferredSize(new Dimension(200, 30));
                if (bl) {
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.PropertyQuantification));
                } else {
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.MeasurementName));
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.SampleIndex));
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.SampleName));
                    if (workflow != null) {
                        if (workflow.getIdentifiers().size() > 0) {
                            this.comboBox.addSeparator();
                            for (ThingWithName thingWithName : workflow.getIdentifiers()) {
                                this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.SampleIdentifier, (Identifier)thingWithName));
                            }
                        }
                        if (workflow.getCategoryFactors().size() > 0) {
                            this.comboBox.addSeparator();
                            for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
                                this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.SampleClass, (CategoryFactor)thingWithName));
                            }
                        }
                    }
                    this.comboBox.addSeparator();
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.Identifier));
                    this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.Category));
                }
                this.comboBox.addSeparator();
                this.comboBox.addItem(new ImportItem(ImportFromEvince.ImportType.Exclude));
                this.comboBox.setSelectedIndex(this.getIndexOf(importType));
            }

            private int getIndexOf(ImportFromEvince.ImportType importType) {
                for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                    Object e = this.comboBox.getItemAt(i);
                    if (!(e instanceof ImportItem)) continue;
                    ImportItem importItem = (ImportItem)e;
                    if (!importItem.type.equals((Object)importType)) continue;
                    return i;
                }
                return 0;
            }

            public ImportFromEvince.DataInfo getDataInfo() {
                ImportFromEvince.DataInfo dataInfo = new ImportFromEvince.DataInfo();
                dataInfo.name = this.label.getText();
                dataInfo.data = this.data;
                dataInfo.column = this.column;
                ImportItem importItem = (ImportItem)this.comboBox.getSelectedItem();
                dataInfo.type = importItem.type;
                dataInfo.identifier = importItem.identifier;
                dataInfo.category = importItem.category;
                return dataInfo;
            }
        }

        public static class ImportItem {
            private final ImportFromEvince.ImportType type;
            private Identifier identifier;
            private CategoryFactor category;

            public ImportItem(ImportFromEvince.ImportType importType) {
                this.type = importType;
            }

            public ImportItem(ImportFromEvince.ImportType importType, Identifier identifier) {
                this(importType);
                this.identifier = identifier;
            }

            public ImportItem(ImportFromEvince.ImportType importType, CategoryFactor categoryFactor) {
                this(importType);
                this.category = categoryFactor;
            }

            public String toString() {
                if (this.category != null) {
                    return this.type.toString() + " - " + this.category.getName();
                }
                if (this.identifier != null) {
                    return this.type.toString() + " - " + this.identifier.getName();
                }
                return this.type.toString();
            }
        }
    }

    public static enum Delimiter {
        Auto('-', "Auto"),
        Tab('\t', "Tab (tab)"),
        Space(' ', "Space (' ')"),
        Comma(',', "Comma (',')"),
        Line('-', "Line ('-')"),
        Color(':', "Colon (':')"),
        SemiColon(';', "Semi-Colon (';')");

        private final char value;
        private final String text;

        private Delimiter(char c, String string2) {
            this.value = c;
            this.text = string2;
        }

        public boolean isAuto() {
            return this.equals((Object)Auto);
        }

        public String getStringValue() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return this.text;
        }

        public static Delimiter from(char c) {
            for (Delimiter delimiter : Delimiter.values()) {
                if (delimiter.value != c) continue;
                return delimiter;
            }
            return Auto;
        }
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Variables and id from separate spreadsheet file. Automatic matching based on measurement name";
        }

        @Override
        public String getName() {
            return "Variables and id data";
        }

        @Override
        public String getShortName() {
            return "Variables";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportValues(entryMainPanel, string, object);
        }
    }
}

