/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.util.List;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;

public class PPImportValuesIntoSegmentation
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final BreezeCheckBox autoCreatePropertiesCheckBox;
    private static File lastDirectory;

    public PPImportValuesIntoSegmentation(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, BreezeType.Project, string, object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select image file(s) for value import and press Next", false);
        this.fileSelectionPanel.addDataFileFilters(FileChooserPanel.FilterType.IMAGE);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        this.fileSelectionPanel.setCurrentDirectory(this.getCurrentDirectory());
        this.viewClassList.add(new ViewClass("Select image file(s)", "Select image file(s) for variables value import", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Select to automatically create Properties that does not exist in study.\nPress Finish to complete import");
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.init(Workflow.getWorkflow(object));
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        this.autoCreatePropertiesCheckBox = new BreezeCheckBox("Automatically create Properties (quantification variables)", true);
        pPDescriptionPanel.addOption(this.autoCreatePropertiesCheckBox);
        this.autoCreatePropertiesCheckBox.setName("autoCreateProperties");
        this.viewClassList.add(new ViewClass("Settings", "Setting for file(s) value import", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    private File getCurrentDirectory() {
        if (lastDirectory != null) {
            return lastDirectory;
        }
        return WorkspaceManager.getInstance().getWorkspace().getImportPath();
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final List<File> list = this.fileSelectionPanel.getSelectedFiles();
        if (list != null && list.size() > 0) {
            lastDirectory = list.get(0).getParentFile();
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPImportValuesIntoSegmentation this$0;
                {
                    this.this$0 = pPImportValuesIntoSegmentation;
                    super(abstractWizardPanel);
                }

                @Override
                public void onFinish() {
                    this.this$0.mainPanel.selectTab("Table");
                }

                @Override
                public void runAction() throws Exception {
                    List<Measurement> list2 = Measurement.getMeasurements(this.this$0.entryData);
                    if (list2.size() > 0) {
                        this.importIntoGroup(list2, list);
                    }
                }

                private void importIntoGroup(List<Measurement> list3, List<File> list2) {
                    BreezeProgressManager breezeProgressManager = this.getProgressManager();
                    int n = breezeProgressManager.setGroupMaximumAndReset(list2.size());
                    for (File file : list2) {
                        Measurement measurement = this.this$0.getMeasurementByName(list3, FileHelper.getFileName(file));
                        if (measurement != null) {
                            new ImportFromImageFile(breezeProgressManager, measurement, new RawFileImpl(file), this.this$0.autoCreatePropertiesCheckBox.isSelected(), this.this$0.segmentationComboBox.getSelectedIndex());
                        }
                        breezeProgressManager.incStepGroup(n);
                    }
                    list3.get(0).getWorkflow().save();
                }
            }, "Import values");
        }
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    private Measurement getMeasurementByName(List<Measurement> list, String string) {
        for (Measurement measurement : list) {
            if (!measurement.getName().equals(string)) continue;
            return measurement;
        }
        return null;
    }

    protected static class ImportFromImageFile {
        public ImportFromImageFile(BreezeProgressManager breezeProgressManager, Measurement measurement, RawFile rawFile, boolean bl, int n) {
            RawHeader rawHeader = rawFile.header();
            List<RawFrame> list = rawFile.readFrames();
            int n2 = 0;
            for (String string : rawHeader.bandNames()) {
                breezeProgressManager.setInfoText("Importing properties into " + measurement.getName() + " (" + string + ")");
                this.importPropertyFactors(measurement, string, list, n2, bl, n);
                ++n2;
            }
        }

        private void importPropertyFactors(Measurement measurement, String string, List<RawFrame> list, int n, boolean bl, int n2) {
            PropertyList propertyList = measurement.getParent().getPropertyFactors();
            PropertyFactor propertyFactor = (PropertyFactor)FactorHolder.getFactorByName(string, propertyList);
            if (propertyFactor == null && bl) {
                propertyFactor = propertyList.add(new PropertyFactor(string));
                propertyFactor.setUnit("");
            }
            if (propertyFactor != null) {
                this.setValues(measurement, propertyFactor, list, n, n2);
            }
        }

        private void setValues(Measurement measurement, Factor factor, List<RawFrame> list, int n, int n2) {
            SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(n2);
            for (Sample sample : sampleSegmentationColumn) {
                this.setFactorValueRecursive(factor, this.getAverageFromSamplePixels(list, sample, n), sample);
            }
            measurement.save();
        }

        private float getAverageFromSamplePixels(List<RawFrame> list, Sample sample, int n) {
            double d = 0.0;
            int n2 = 0;
            for (RtPixel2D rtPixel2D : sample.getSamplePath().getObjectPixels()) {
                d += (double)list.get(rtPixel2D.y).getFrameValue(n, rtPixel2D.x);
                ++n2;
            }
            if (n2 > 0) {
                return (float)d / (float)n2;
            }
            return 0.0f;
        }

        private void setFactorValueRecursive(Factor factor, float f, Sample sample) {
            sample.getSampleValues().setValue(factor, f);
            for (BasicSample basicSample : sample.getChildList()) {
                this.setFactorValueRecursive(factor, f, (Sample)basicSample);
            }
        }
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Variables values from image file(s)";
        }

        @Override
        public String getName() {
            return "Variables from image file(s)";
        }

        @Override
        public String getShortName() {
            return "Variables from image";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportValuesIntoSegmentation(entryMainPanel, string, object);
        }
    }
}

