/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.wizard.ImportFromEvince;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportValues;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.test.EvinceTestSetUp;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.util.FileWithStringContent;
import se.prediktera.map.datasetcontainer.dataset.DataSet;

@Category(value={SlowTestCategory.class})
public class PPImportValuesTest
extends EvinceTestSetUp {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    final String importValues = "Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n";
    final String importValuesWithValuesBeforeName = "Time;Sample;Measurement;ID;B;V;P;Type\r\n20171012105040;M0001(1);M0001;ID1;15;50;35;V\r\n20171012105040;M0002(1);M0002;ID2;5;5;90.5;P\r\n20171012105040;M0003(1);M0003;;80,4;12;7.6;B\r\n20171012105040;M0035(1);M0035;;,;;.;\r\n20171012105040;M0004(1);M0004;ID4;1;100;;\r\n";
    final String importSampleValues = "Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n";
    final String importSampleNameValues = "Sample;B;V;P;Type\r\nM0001 (1);15;50;35;V\r\nM0001 (2);5;5;90.5;P\r\nM0001 (3);80,4;12;7.6;B\r\nM0001 (4);1;100;;\r\n";
    final String importSampleClassValues = "SampleClass;B;V;P;Type\r\nA;15;50;35;V\r\nB;5;5;90.5;P\r\nC;80,4;12;7.6;B\r\nE;40,3;11;8.4;V\r\nD;1;100;;\r\n";
    final String importCategoryValues = "Measurement;Nut or shell;Nut type\r\nM0001;Shell;-\r\nM0002;Nut;Almond\r\nM0003;Nut;Hazelnut\r\nM0004;Shell;-\r\n";
    final String importPlasticValues = "Measurement;Plastic type\r\nMixed plastic;PVC\r\nMixed plastic;PVC\r\nMixed plastic;PET G\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Bottle\r\nMixed plastic;PC\r\nMixed plastic;PC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PVC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Sheet\r\nMixed plastic;PC\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PVC";

    @Test
    public void importRawData() throws IOException {
        this.importRawData("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n", PPImportValues.Delimiter.Auto);
    }

    @Test
    public void importRawDataWithComma() throws IOException {
        this.importRawData("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n".replace(',', '.').replace(';', ','), PPImportValues.Delimiter.Comma);
    }

    @Test
    public void importRawDataWithNamesBeforeMeasurement() throws IOException {
        this.importRawData("Time;Sample;Measurement;ID;B;V;P;Type\r\n20171012105040;M0001(1);M0001;ID1;15;50;35;V\r\n20171012105040;M0002(1);M0002;ID2;5;5;90.5;P\r\n20171012105040;M0003(1);M0003;;80,4;12;7.6;B\r\n20171012105040;M0035(1);M0035;;,;;.;\r\n20171012105040;M0004(1);M0004;ID4;1;100;;\r\n".replace(',', '.').replace(';', ','), PPImportValues.Delimiter.Comma);
    }

    private void importRawData(String string, PPImportValues.Delimiter delimiter) throws IOException {
        File file = this.createTmpFile(string);
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        for (int i = 0; i < 4; ++i) {
            this.addMeasurement(groupWithoutIO, i);
        }
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, delimiter, 0, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(0).getRootSample(), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(1).getRootSample(), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(2).getRootSample(), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(3).getRootSample(), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    @Test
    public void importRawDataFactorExist() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        for (int i = 0; i < 4; ++i) {
            this.addMeasurement(groupWithoutIO, i);
        }
        Workflow workflow = groupWithoutIO.getParent();
        workflow.getIdentifiers().add(new Identifier("ID"));
        workflow.getPropertyFactors().add(new PropertyFactor("v"));
        workflow.getPropertyFactors().add(new PropertyFactor("B"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        MatcherAssert.assertThat((Object)workflow.getPropertyFactors().size(), (Matcher)CoreMatchers.is((Object)3));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(0).getRootSample(), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(1).getRootSample(), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(2).getRootSample(), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(3).getRootSample(), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    @Test
    public void importSameDataValuesIntoMultipleSamples() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        measurement.getRootSample().addChild(new Sample());
        measurement.getRootSample().addChild(new Sample());
        groupWithoutIO.getParent().getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        for (BasicSample basicSample : measurement.getRootSample().getChildList()) {
            this.assertSample(groupWithoutIO, (Sample)basicSample, "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        }
    }

    @Test
    public void importDifferentDataValuesIntoOneSamplesSameNumber() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSamplesSameNumber() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(3), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSubSamplesSameNumber() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        Sample sample = new Sample();
        rootSample.addChild(sample);
        sample.addChild(new Sample());
        sample.addChild(new Sample());
        sample.addChild(new Sample());
        sample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 2, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, sample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, sample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, sample.getChild(1), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, sample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, sample.getChild(3), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSamplesLessNumber() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSamplesMoreNumber() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(3), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(4), null, null, null, null, null);
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSamplesOnlyOne() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, rootSample, "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
    }

    @Test
    public void importDifferentDataValuesIntoMultipleSamplesMoreNumberUsingSampleIndex() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0001;ID2;5;5;90.5;P\r\nM0001;;80,4;12;7.6;B\r\nM0001;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.SampleIndex);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(3), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(4), null, null, null, null, null);
    }

    @Test
    public void importDifferentDataValuesIntoOneSamplesUsingSampleName() throws IOException {
        File file = this.createTmpFile("Sample;B;V;P;Type\r\nM0001 (1);15;50;35;V\r\nM0001 (2);5;5;90.5;P\r\nM0001 (3);80,4;12;7.6;B\r\nM0001 (4);1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.SampleName);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), null, Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), null, Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(3), null, Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(4), null, null, null, null, null);
    }

    @Test
    public void importDifferentDataValuesIntoOneSamplesUsingSampleClass() throws IOException {
        File file = this.createTmpFile("SampleClass;B;V;P;Type\r\nA;15;50;35;V\r\nB;5;5;90.5;P\r\nC;80,4;12;7.6;B\r\nE;40,3;11;8.4;V\r\nD;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        Workflow workflow = groupWithoutIO.getParent();
        CategoryFactor categoryFactor = workflow.getCategoryFactors().add(new CategoryFactor("Category"));
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        categoryFactor.addClass("C");
        categoryFactor.addClass("D");
        Measurement measurement = this.addMeasurement(groupWithoutIO, 0);
        RootSample rootSample = measurement.getRootSample();
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.addChild(new Sample());
        rootSample.getChild(0).getSampleValues().setValue(categoryFactor, 1.0f);
        rootSample.getChild(1).getSampleValues().setValue(categoryFactor, 2.0f);
        rootSample.getChild(2).getSampleValues().setValue(categoryFactor, 3.0f);
        rootSample.getChild(3).getSampleValues().setValue(categoryFactor, 4.0f);
        rootSample.getChild(5).getSampleValues().setValue(categoryFactor, 4.0f);
        groupWithoutIO.getIdentifiers().add(new Identifier("ID"));
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.SampleClass);
        this.assertSample(groupWithoutIO, rootSample, null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(0), null, Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(1), null, Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(2), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, rootSample.getChild(3), null, Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(4), null, null, null, null, null);
        this.assertSample(groupWithoutIO, rootSample.getChild(5), null, Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    @Test
    public void importCategoriesOnly() throws IOException {
        File file = this.createTmpFile("Measurement;Nut or shell;Nut type\r\nM0001;Shell;-\r\nM0002;Nut;Almond\r\nM0003;Nut;Hazelnut\r\nM0004;Shell;-\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        for (int i = 0; i < 4; ++i) {
            this.addMeasurement(groupWithoutIO, i);
        }
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(0).getRootSample(), "Shell", "-");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(1).getRootSample(), "Nut", "Almond");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(2).getRootSample(), "Nut", "Hazelnut");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(3).getRootSample(), "Shell", "-");
    }

    @Test
    public void importCategoriesOnlyFactorExist() throws IOException {
        File file = this.createTmpFile("Measurement;Nut or shell;Nut type\r\nM0001;Shell;-\r\nM0002;Nut;Almond\r\nM0003;Nut;Hazelnut\r\nM0004;Shell;-\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        for (int i = 0; i < 4; ++i) {
            this.addMeasurement(groupWithoutIO, i);
        }
        Workflow workflow = groupWithoutIO.getParent();
        CategoryFactor categoryFactor = new CategoryFactor("Nut or shell");
        categoryFactor.addClass("Shell");
        categoryFactor.addClass("nut");
        workflow.getCategoryFactors().add(categoryFactor);
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(0).getRootSample(), "Shell", "-");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(1).getRootSample(), "nut", "Almond");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(2).getRootSample(), "nut", "Hazelnut");
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(3).getRootSample(), "Shell", "-");
    }

    @Test
    public void getDelimiterFromFirstLine() {
        MatcherAssert.assertThat((Object)((Object)ImportFromEvince.getDelimiter(Arrays.asList("Sample;Measurement;ID"))), (Matcher)CoreMatchers.is((Object)((Object)PPImportValues.Delimiter.SemiColon)));
        MatcherAssert.assertThat((Object)((Object)ImportFromEvince.getDelimiter(Arrays.asList("Measurement"))), (Matcher)CoreMatchers.is((Object)((Object)PPImportValues.Delimiter.Auto)));
        MatcherAssert.assertThat((Object)((Object)ImportFromEvince.getDelimiter(Arrays.asList("Sample"))), (Matcher)CoreMatchers.is((Object)((Object)PPImportValues.Delimiter.Auto)));
        MatcherAssert.assertThat((Object)((Object)ImportFromEvince.getDelimiter(Arrays.asList("Measurement;ID"))), (Matcher)CoreMatchers.is((Object)((Object)PPImportValues.Delimiter.SemiColon)));
        MatcherAssert.assertThat((Object)((Object)ImportFromEvince.getDelimiter(Arrays.asList("Sample,Measurement"))), (Matcher)CoreMatchers.is((Object)((Object)PPImportValues.Delimiter.Comma)));
    }

    @Test
    public void importPlasticDataValues() throws IOException {
        File file = this.createTmpFile("Measurement;Plastic type\r\nMixed plastic;PVC\r\nMixed plastic;PVC\r\nMixed plastic;PET G\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Bottle\r\nMixed plastic;PC\r\nMixed plastic;PC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PVC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Sheet\r\nMixed plastic;PC\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PVC");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO("Mixed plastic", (Group)groupWithoutIO);
        RootSample rootSample = new RootSample();
        measurementWithoutIO.replaceRootSample(rootSample);
        groupWithoutIO.addChild(measurementWithoutIO);
        String[] stringArray = "Measurement;Plastic type\r\nMixed plastic;PVC\r\nMixed plastic;PVC\r\nMixed plastic;PET G\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Bottle\r\nMixed plastic;PC\r\nMixed plastic;PC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PVC\r\nMixed plastic;PET Bottle\r\nMixed plastic;PET Sheet\r\nMixed plastic;PET Sheet\r\nMixed plastic;PC\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PET G\r\nMixed plastic;PVC".split("\r\n");
        for (int i = 1; i < stringArray.length; ++i) {
            rootSample.addChild(new Sample());
        }
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 1, ImportFromEvince.ImportType.MeasurementName);
        CategoryFactor categoryFactor = groupWithoutIO.getParent().getCategoryFactors().get(0);
        for (int i = 1; i < stringArray.length; ++i) {
            MatcherAssert.assertThat((Object)categoryFactor.getStringValue(rootSample.getChild(i - 1)), (Matcher)CoreMatchers.is((Object)stringArray[i].split(";")[1]));
        }
    }

    @Test
    public void importRawDataAutoIdentifiers() throws IOException {
        File file = this.createTmpFile("Meas;ID;B;V;P;Type\r\nM0001;ID1;15;50;35;V\r\nM0002;ID2;5;5;90.5;P\r\nM0003;;80,4;12;7.6;B\r\nM0035;;;;;\r\nM0004;ID4;1;100;;\r\n");
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        for (int i = 0; i < 4; ++i) {
            this.addMeasurement(groupWithoutIO, i);
        }
        Workflow workflow = groupWithoutIO.getParent();
        this.doImport(file, groupWithoutIO, PPImportValues.Delimiter.Auto, 0, ImportFromEvince.ImportType.MeasurementName);
        MatcherAssert.assertThat((Object)workflow.getPropertyFactors().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)workflow.getIdentifiers().get(0).getName(), (Matcher)CoreMatchers.is((Object)"ID"));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(0).getRootSample(), "ID1", Float.valueOf(15.0f), Float.valueOf(50.0f), Float.valueOf(35.0f), Float.valueOf(1.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(1).getRootSample(), "ID2", Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(90.5f), Float.valueOf(2.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(2).getRootSample(), null, Float.valueOf(80.4f), Float.valueOf(12.0f), Float.valueOf(7.6f), Float.valueOf(3.0f));
        this.assertSample(groupWithoutIO, groupWithoutIO.getChild(3).getRootSample(), "ID4", Float.valueOf(1.0f), Float.valueOf(100.0f), null, null);
    }

    private void doImport(File file, Group group, PPImportValues.Delimiter delimiter, int n, ImportFromEvince.ImportType importType) {
        DataSet dataSet = ImportFromEvince.loadFile(BreezeProgressManager.createEmpty(), file, delimiter);
        PPImportValues.DataPanel dataPanel = new PPImportValues.DataPanel();
        dataPanel.setData(group.getParent(), dataSet, importType);
        List<ImportFromEvince.DataInfo> list = dataPanel.getDataInfoList();
        for (ImportFromEvince.DataInfo dataInfo : list) {
            if (!dataInfo.name.startsWith("ID")) continue;
            dataInfo.type = ImportFromEvince.ImportType.Identifier;
        }
        new ImportFromEvince(Collections.singletonList(dataSet), group.getParent(), group.getChildList(), list, n, true);
        dataSet.close();
    }

    private void assertSample(Group group, Sample sample, String string, String string2) {
        CategoryList categoryList = group.getParent().getCategoryFactors();
        MatcherAssert.assertThat((Object)categoryList.get(0).getStringValue(sample), (Matcher)CoreMatchers.is((Object)string));
        MatcherAssert.assertThat((Object)categoryList.get(1).getStringValue(sample), (Matcher)CoreMatchers.is((Object)string2));
    }

    private Measurement addMeasurement(Group group, int n) {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO("M000" + (n + 1), group);
        measurementWithoutIO.replaceRootSample(new RootSample());
        group.addChild(measurementWithoutIO);
        return measurementWithoutIO;
    }

    private File createTmpFile(String string) throws IOException {
        File file = new File(this.tempFolder.getRoot(), "test.csv");
        new FileWithStringContent(string).writtenTo(file);
        file.deleteOnExit();
        return file;
    }

    private void assertSample(Group group, Sample sample, String string, Float f, Float f2, Float f3, Float f4) {
        FactorHolder factorHolder = group.getFactorHolder();
        Identifier identifier = group.getIdentifiers().get(0);
        MatcherAssert.assertThat((Object)sample.getIdentifierProperties().getValue(identifier), (Matcher)(string != null ? CoreMatchers.is((Object)string) : CoreMatchers.nullValue()));
        SampleValues sampleValues = sample.getSampleValues();
        PropertyFactor propertyFactor = factorHolder.getPropertyFactors().getByName("B");
        MatcherAssert.assertThat((Object)sampleValues.getValue(propertyFactor), (Matcher)(f != null ? CoreMatchers.is((Object)f) : CoreMatchers.nullValue()));
        PropertyFactor propertyFactor2 = factorHolder.getPropertyFactors().getByName("V");
        MatcherAssert.assertThat((Object)sampleValues.getValue(propertyFactor2), (Matcher)(f2 != null ? CoreMatchers.is((Object)f2) : CoreMatchers.nullValue()));
        PropertyFactor propertyFactor3 = factorHolder.getPropertyFactors().getByName("P");
        MatcherAssert.assertThat((Object)sampleValues.getValue(propertyFactor3), (Matcher)(f3 != null ? CoreMatchers.is((Object)f3) : CoreMatchers.nullValue()));
        CategoryFactor categoryFactor = factorHolder.getCategoryFactors().getByName("Type");
        MatcherAssert.assertThat((Object)sampleValues.getValue(categoryFactor), (Matcher)(f4 != null ? CoreMatchers.is((Object)f4) : CoreMatchers.nullValue()));
    }
}

