/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.swing.filechooser.FileTools;

public class PPImportWorkflow
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeMasterCache masterCache;
    private boolean checkOverwrite = true;

    public PPImportWorkflow(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, null);
        this.masterCache = (BreezeMasterCache)object;
        this.fileSelectionPanel = new FileChooserPanel(this, "Select workflow project file and press Finish.", false){

            @Override
            public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
                if (super.checkValidContent(wizardControlCallback).ok()) {
                    List<String> list = ZipManager.getSubdirectoriesInFolder(PPImportWorkflow.this.fileSelectionPanel.getSelectedFile(), "Record");
                    if (list.isEmpty()) {
                        BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Invalid archive", "Not a valid project archive");
                        return WizardStep.LeaveResult.Failed;
                    }
                    if (PPImportWorkflow.this.checkOverwrite && PPImportWorkflow.this.masterCache.getStudyList().byName(list.getFirst()) != null) {
                        BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Project exists", "A project with the same name already exists. Do you want to overwrite it?", breezeActionEvent -> {
                            PPImportWorkflow.this.checkOverwrite = false;
                            wizardControlCallback.leaveWithControl();
                        });
                        return WizardStep.LeaveResult.Failed;
                    }
                    return WizardStep.LeaveResult.Ok;
                }
                return WizardStep.LeaveResult.Failed;
            }
        };
        this.fileSelectionPanel.addExtension(new String[]{"zip"}, "Zip file (*.zip)");
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getDataPath());
        this.viewClassList.add(new ViewClass("Select file(s)", "Select workflow project file", this.fileSelectionPanel));
        this.setLists(this.viewClassList);
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.getSelectedFile();
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
            final /* synthetic */ PPImportWorkflow this$0;
            {
                this.this$0 = pPImportWorkflow;
                super(abstractWizardPanel);
            }

            @Override
            public void onFinish() {
                this.this$0.mainPanel.selectTab("Table");
            }

            @Override
            public void runAction() throws IOException {
                this.setInfoText("Importing...");
                if (!FileTools.hasExtension((File)file, (String)"zip")) {
                    long l = FileUtils.sizeOfDirectory((File)file) / 1024L;
                    this.getProgressManager().setMaximumAndReset((int)l);
                    FileFilter fileFilter = file -> {
                        this.getProgressManager().incStep((int)(file.length() / 1024L));
                        return true;
                    };
                    if (2.isWorkflowFolder(file)) {
                        FileUtils.copyDirectory((File)file, (File)new File(WorkspaceManager.getInstance().getWorkspace().getRecordPath(), file.getName()), (FileFilter)fileFilter);
                    } else if (2.isExtractedZip(file)) {
                        FileUtils.copyDirectory((File)file, (File)WorkspaceManager.getInstance().getWorkspace().getFolder(), (FileFilter)fileFilter);
                    }
                } else {
                    new ZipManager(file).extractAllShowWarning(this.this$0.frame, this.getProgressManager(), WorkspaceManager.getInstance().getWorkspace().getPath(), true, "workflow.xml", 3);
                }
                this.this$0.masterCache.clearAllList();
                this.this$0.mainPanel.setEntryListModel(this.this$0.masterCache.getStudyList(), ListHelper.SortType.Created, false);
                this.this$0.mainPanel.selectEntry(this.this$0.mainPanel.getEntryList().getEntryByNameOrFirst(FileHelper.getFileName(file)));
            }

            private static boolean isWorkflowFolder(File file2) {
                if (file2.isDirectory()) {
                    return new File(file2, "workflow.xml").exists();
                }
                return false;
            }

            private static boolean isExtractedZip(File file2) {
                if (file2.isDirectory()) {
                    return new File(file2, "Record").exists();
                }
                return false;
            }
        }, "Importing workflow");
    }

    @Generated
    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Project with recorded measurements, connected models and play workflows from archive";
        }

        @Override
        public String getName() {
            return "Project";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportWorkflow(entryMainPanel, string, object);
        }
    }
}

