/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;

public class PPImportWorkflowSettings
extends AbstractWizardPanel.AbstractImportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final Workflow workflow;
    private static File lastDirectory;
    private final BreezeCheckBox copyVariablesCheckBox = new BreezeCheckBox("Include identifiers, categories and properties", false);

    public PPImportWorkflowSettings(EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, null);
        this.workflow = Workflow.getWorkflow(object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Select worklfow xml file and press Finish.", false);
        this.fileSelectionPanel.addExtension(new String[]{"xml"}, "Breeze workflow xml file");
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setCurrentDirectory(this.getCurrentDirectory());
        this.viewClassList.add(new ViewClass("Select file(s)", "Select file(s) for external data import", this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("Settings for import workflow Analyse Tree. Press Finish to complete import");
        this.viewClassList.add(new ViewClass("Settings", "Setting for file import", pPDescriptionPanel));
        pPDescriptionPanel.addOption(this.copyVariablesCheckBox);
        this.setLists(this.viewClassList);
    }

    private File getCurrentDirectory() {
        if (lastDirectory != null) {
            return lastDirectory;
        }
        return WorkspaceManager.getInstance().getWorkspace().getImportPath();
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.getSelectedFile();
        lastDirectory = file.getParentFile();
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
            final /* synthetic */ PPImportWorkflowSettings this$0;
            {
                this.this$0 = pPImportWorkflowSettings;
                super(abstractWizardPanel);
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Importing...");
                PPImportWorkflowSettings.perform(this.this$0.workflow, file, this.this$0.copyVariablesCheckBox.isSelected());
            }
        }, "Importing workflow Analyse Tree");
    }

    public static void perform(Workflow workflow, File file, boolean bl) {
        FunctionTreeListMap functionTreeListMap = workflow.getContextHolder();
        functionTreeListMap.clear();
        if (bl) {
            // empty if block
        }
        Node node = XmlParserHelper.parseXMLRoot(file, "workflow", "breezeapi");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName().toLowerCase();
            if (string.equals("settings")) {
                PPImportWorkflowSettings.syncSettings(workflow.getProperties().getRootProperty(), node2);
                continue;
            }
            if (string.equals("comments")) continue;
            if (string.equals("identifiers")) {
                if (!bl) continue;
                workflow.getIdentifiers().parseIdentifiers(node2);
                continue;
            }
            if (string.equals("variables")) {
                if (!bl) continue;
                workflow.getFactorHolder().parseVariables(node2);
                continue;
            }
            if (string.equals("descriptors")) {
                functionTreeListMap.parse(node2);
                continue;
            }
            if (!string.equals("graph")) continue;
            HashMap<String, AbstractBreezeFunction> hashMap = new HashMap<String, AbstractBreezeFunction>();
            EvaluationTree evaluationTree = new EvaluationTree(node2, hashMap);
            functionTreeListMap.addWorkflowTree(evaluationTree);
        }
        workflow.save();
    }

    private static void syncSettings(Node node, Node node2) {
        Object object;
        if (node.getNodeType() != 1) {
            return;
        }
        if (PPImportWorkflowSettings.isValueItem(node) && (object = PPImportWorkflowSettings.getNode(node2, node.getNodeName())) != null) {
            node.setTextContent(object.getTextContent());
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node3 = namedNodeMap.item(i);
                    String string = PPImportWorkflowSettings.getAttribute((Node)object, node3.getNodeName());
                    if (string == null) continue;
                    XmlParserHelper.setAttribute(node, node3.getNodeName(), string);
                }
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            PPImportWorkflowSettings.syncSettings(object.item(i), node2);
        }
    }

    private static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!node2.getNodeName().equals(string)) continue;
                return node2.getTextContent();
            }
        }
        return null;
    }

    private static boolean isValueItem(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    private static Node getNode(Node node, String string) {
        if (node.getNodeName().equals(string)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = PPImportWorkflowSettings.getNode(nodeList.item(i), string);
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "Workflow Analyse Tree";
        }

        @Override
        public String getName() {
            return "Analyse Tree";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportWorkflowSettings(entryMainPanel, string, object);
        }
    }
}

