/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportWorkflowSettings;

public class PPImportWorkflowSettingsTest {
    @Test
    public void importWorkflowSettings() throws IOException {
        File file = Files.createTempDirectory("importTest", new FileAttribute[0]).toFile();
        Workflow workflow = new Workflow("source", file);
        FunctionTreeNode functionTreeNode = workflow.getRoot();
        FunctionTreeNode functionTreeNode2 = FunctionHelper.createNew(new ModelSegmentation.Info());
        functionTreeNode.addChild(functionTreeNode2);
        FunctionTreeNode functionTreeNode3 = FunctionHelper.createNew(new PlsPredClassificationDescriptor.Info());
        functionTreeNode2.addChild(functionTreeNode3);
        PropertyFactor propertyFactor = PPImportWorkflowSettingsTest.addTestProperty(workflow, "property");
        CategoryFactor categoryFactor = PPImportWorkflowSettingsTest.addTestCategory(workflow);
        Identifier identifier = PPImportWorkflowSettingsTest.addTestIdentifier(workflow);
        workflow.getProperties().setPropertyLocal("measure/maxlines", "200");
        workflow.getProperties().setPropertyLocal("measure/maxSaturatedBand", "10");
        workflow.getProperties().setPropertyLocal("visualisation/colorScale", "Winter");
        workflow.setReferenceConvertTo(RtFramePredictor.ReferenceConvertTo.Reflectance);
        workflow.save();
        List<Node> list = XmlParserHelper.getNodeList(workflow.getProperties().getPropertyNodeLocal("measure"));
        Workflow workflow2 = new Workflow("target", file);
        PPImportWorkflowSettings.perform(workflow2, workflow.getXml(), true);
        PPImportWorkflowSettingsTest.assertAnalyseTree(workflow.getRoot(), workflow2.getRoot());
        List<Node> list2 = XmlParserHelper.getNodeList(workflow2.getProperties().getPropertyNodeLocal("measure"));
        for (Node node : list) {
            Node node2 = this.getNode(list2, node.getNodeName());
            if (node2 == null) {
                Assert.fail((String)("Target node missing " + node.getNodeName()));
            }
            MatcherAssert.assertThat((String)node2.getNodeName(), (Object)node2.getTextContent().toLowerCase(), (Matcher)Matchers.is((Object)node.getTextContent().toLowerCase()));
        }
        Assert.assertNotNull((Object)workflow2.getIdentifiers().getIdentifier(identifier.getName()));
        Assert.assertNotNull((Object)workflow2.getFactorHolder().getFactorByName(propertyFactor.getName()));
        Assert.assertNotNull((Object)workflow2.getFactorHolder().getFactorByName(categoryFactor.getName()));
    }

    @Test
    public void importRuntimeWorkflowSettings() throws IOException {
        File file = Files.createTempDirectory("importTest", new FileAttribute[0]).toFile();
        Workflow workflow = new Workflow("source", file);
        FunctionTreeNode functionTreeNode = workflow.getRoot();
        FunctionTreeNode functionTreeNode2 = FunctionHelper.createNew(new ModelSegmentation.Info());
        functionTreeNode.addChild(functionTreeNode2);
        FunctionTreeNode functionTreeNode3 = FunctionHelper.createNew(new PlsPredClassificationDescriptor.Info());
        functionTreeNode2.addChild(functionTreeNode3);
        PropertyFactor propertyFactor = PPImportWorkflowSettingsTest.addTestProperty(workflow, "property");
        CategoryFactor categoryFactor = PPImportWorkflowSettingsTest.addTestCategory(workflow);
        Identifier identifier = PPImportWorkflowSettingsTest.addTestIdentifier(workflow);
        workflow.getProperties().setPropertyLocal("measure/parallelMeasurementSegmentation", "false");
        workflow.getProperties().setPropertyLocal("measure/maxlines", "200");
        workflow.getProperties().setPropertyLocal("visualisation/colorScale", "Winter");
        workflow.setReferenceConvertTo(RtFramePredictor.ReferenceConvertTo.Reflectance);
        workflow.save();
        File file2 = new File(file, "runtime.xml");
        PPExportBreezeRuntime.export(BreezeProgressImpl.createEmpty(), workflow, "runtime", workflow.getDescription(), file2, -1, PPExportBreezeRuntime.ObjectProcessing.Sequential, false);
        List<Node> list = XmlParserHelper.getNodeList(workflow.getProperties().getPropertyNodeLocal("measure"));
        Workflow workflow2 = new Workflow("target", file);
        PPImportWorkflowSettings.perform(workflow2, file2, true);
        PPImportWorkflowSettingsTest.assertAnalyseTree(workflow.getRoot(), workflow2.getRoot());
        List<Node> list2 = XmlParserHelper.getNodeList(workflow2.getProperties().getPropertyNodeLocal("measure"));
        for (Node node : list) {
            Node node2 = this.getNode(list2, node.getNodeName());
            if (node2 == null) {
                Assert.fail((String)("Target node missing " + node.getNodeName()));
            }
            MatcherAssert.assertThat((String)node2.getNodeName(), (Object)node2.getTextContent().toLowerCase(), (Matcher)Matchers.is((Object)node.getTextContent().toLowerCase()));
        }
        Assert.assertNotNull((Object)workflow2.getIdentifiers().getIdentifier(identifier.getName()));
        Assert.assertNotNull((Object)workflow2.getFactorHolder().getFactorByName(propertyFactor.getName()));
        Assert.assertNotNull((Object)workflow2.getFactorHolder().getFactorByName(categoryFactor.getName()));
    }

    private Node getNode(List<Node> list, String string) {
        for (Node node : list) {
            if (!node.getNodeName().equals(string)) continue;
            return node;
        }
        return null;
    }

    private static Identifier addTestIdentifier(Workflow workflow) {
        Identifier identifier = new Identifier(EntryMainHelper.getUniqueName("Name", workflow.getIdentifiers().getList()));
        workflow.getIdentifiers().add(identifier);
        return identifier;
    }

    private static CategoryFactor addTestCategory(Workflow workflow) {
        CategoryFactor categoryFactor = new CategoryFactor("Category");
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        workflow.getCategoryFactors().add(categoryFactor);
        return categoryFactor;
    }

    private static PropertyFactor addTestProperty(Workflow workflow, String string) {
        PropertyFactor propertyFactor = new PropertyFactor(string);
        workflow.getPropertyFactors().add(propertyFactor);
        workflow.getPropertyFactors().add(propertyFactor);
        return propertyFactor;
    }

    private static void assertAnalyseTree(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        MatcherAssert.assertThat((Object)functionTreeNode2.getFunction().getName(), (Matcher)Matchers.is((Object)functionTreeNode.getFunction().getName()));
        MatcherAssert.assertThat((Object)functionTreeNode2.getChildCount(), (Matcher)Matchers.is((Object)functionTreeNode.getChildCount()));
        for (int i = 0; i < functionTreeNode.getChildCount(); ++i) {
            PPImportWorkflowSettingsTest.assertAnalyseTree(functionTreeNode.getChild(i), functionTreeNode2.getChild(i));
        }
    }
}

