/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Dimension;
import java.io.File;
import se.prediktera.breeze.common.util.raw.QgisLauncher;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.SelectionMemory;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public class WizardComponents {

    public static class ExportTextField
    extends BreezeInputField {
        public ExportTextField(String string, String string2, String string3) {
            super(string2, string3, "");
            this.setName(string);
            this.setLabelWidth(120);
            this.setUnitLabelWidth(100);
            this.getTextField().setPreferredSize(new Dimension(200, 30));
            this.setValue(BreezeProperties.getInstance().getExportOption(string, string3));
        }

        public void store() {
            BreezeProperties.getInstance().setExportOption(this.getName(), this.getValue());
        }
    }

    public static class ExportInputField<T>
    extends BreezeComboBoxInputField<T> {
        public ExportInputField(String string) {
            super(string, "", BreezeInputFieldHelper.Format.OneRow);
            this.setLabelWidth(120);
            this.setUnitLabelWidth(100);
            this.setName(string.toLowerCase());
        }

        public void selectAndRemember(T t) {
            SelectionMemory.applyComboBoxIdentity(this.getParent(), this.getComboBox(), this.getName(), t);
        }

        public void remember() {
            SelectionMemory.rememberIdentity(this.getParent(), this.getName(), this.getSelectedItem());
        }
    }

    public static class ExportOptionCheckBox
    extends BreezeCheckBox.BreezeCheckBoxWithUsage {
        public ExportOptionCheckBox(String string, String string2, boolean bl, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
            super(string, string2, bl, "", checkBoxCallback);
            this.setSelected(BreezeProperties.getInstance().isExportOption(this.getName(), this.isSelected()));
        }

        public void store() {
            BreezeProperties.getInstance().setExportOption(this.getName(), this.isSelected());
        }
    }

    public static class OpenInExplorerCheckBox
    extends ExportOptionCheckBox {
        public OpenInExplorerCheckBox() {
            super("openExplorer", "Open file location after export", true, null);
        }

        public void setFolder(File file) {
            this.setUsage("Folder: " + (file != null ? file.getAbsolutePath() : "N/A"));
        }
    }

    public static class OpenInQgisCheckBox
    extends ExportOptionCheckBox {
        public OpenInQgisCheckBox() {
            super("openQgis", "Open files in QGIS after export", false, null);
            boolean bl = QgisLauncher.isQgisInstalled();
            this.setEnabled(bl);
            if (!bl) {
                this.setText(this.getText() + " (Install QGIS to enable this option)");
            }
        }
    }

    public static class OpenInEvinceCheckBox
    extends ExportOptionCheckBox {
        public OpenInEvinceCheckBox() {
            super("openEvince", "Open files in Evince after export", false, null);
            boolean bl = EvinceHelper.exists();
            this.setEnabled(bl);
            if (!bl) {
                this.setText(this.getText() + " (Install Evince to enable this option)");
            }
        }
    }

    public static class CreateFoldersCheckBox
    extends ExportOptionCheckBox {
        public CreateFoldersCheckBox() {
            super("newFolder", "Create sub folder for each exported file", true, null);
        }
    }

    public static class MergeSamplesCheckBox
    extends ExportOptionCheckBox {
        public MergeSamplesCheckBox() {
            super("mergeSamples", "Put all objects from a measurement in the same exported image", false, null);
        }
    }

    public static class KeepOriginalSizeCheckBox
    extends ExportOptionCheckBox {
        public KeepOriginalSizeCheckBox() {
            super("keepOriginalSize", "Keep original measurement resolution (pixels outside objects are set to zero)", false, null);
        }
    }
}

