/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard.importdata;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.ExtraHeaderValues;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileConverter;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtHdrParser;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.legacy.LegacyFileFormat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.helper.DescriptorToPropertiesHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataCustomReferencePanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataPreviewPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataTabbedPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.DefaultXmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.image.hdr.HdrParser;

public class PPImportData
extends AbstractWizardPanel.AbstractImportWizard {
    private final Group group;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
    private final BreezeCheckBox applyCheckBox;
    private final BreezeInputField maxSignalInputField = new BreezeInputField("Camera max signal", "", " ");
    private final BreezeInputField fieldOfViewInputField = new BreezeInputField("Field of view", "", "mm");
    private final BreezeInputField integrationTimeInputField = new BreezeInputField("Integration time", "", "\u00b5s");
    private final PPImportDataCustomReferencePanel customReference;
    private PPImportDataTabbedPanel tabbedViewPanel;
    private PPImportDataPreviewPanel previewPanel;
    private final CollapsePanel hyspexFilePanel = new CollapsePanel("HySpex file settings", false);
    private final BreezeCheckBox extractDarkReferenceCheckBox = new BreezeCheckBox("Extract dark reference from binary header", true);
    private final BreezeCheckBox correctBadPixelsCheckBox = new BreezeCheckBox("Correct bad pixels based on binary header", true);
    private final CollapsePanel dataCorrectionPanel = new CollapsePanel("Data correction", false);
    private final BreezeComboBoxInputField<DataIgnoreAction> replaceDataIgnoreValuePixelsComboBox = new BreezeComboBoxInputField("Data ignore value");

    public PPImportData(final EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, object);
        this.group = this.getGroup(object);
        this.tabbedViewPanel = new PPImportDataTabbedPanel(entryMainPanel, this);
        this.viewClassList.add(new ViewClass("Select files", "Select file for data import", this.tabbedViewPanel));
        this.previewPanel = new PPImportDataPreviewPanel(this.tabbedViewPanel);
        this.viewClassList.add(new ViewClass("Preview and edit", "Optionally, preview and crop images before they are imported", this.previewPanel));
        this.customReference = new PPImportDataCustomReferencePanel(entryMainPanel.getFrame(), this);
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel(this, "Settings for file import. Press Finish to complete import"){
            final /* synthetic */ PPImportData this$0;
            {
                this.this$0 = pPImportData;
                super(string);
            }

            @Override
            public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
                Pair<String, WizardStep.LeaveResult> pair = this.this$0.customReference.checkValidContent(this.this$0.tabbedViewPanel.getSelectedFiles(), this.this$0.hyspexFilePanel.isVisible() && this.this$0.extractDarkReferenceCheckBox.isSelected());
                if (((WizardStep.LeaveResult)((Object)pair.getRight())).failed()) {
                    BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Reference", (String)pair.getLeft());
                    return WizardStep.LeaveResult.Failed;
                }
                if (((WizardStep.LeaveResult)((Object)pair.getRight())).control()) {
                    BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Reference", (String)pair.getLeft(), breezeActionEvent -> wizardControlCallback.leaveWithControl());
                    return WizardStep.LeaveResult.Control;
                }
                return super.checkValidContent(wizardControlCallback);
            }

            @Override
            public void showEntry(Object object, Object object2) {
                List<PPImportDataHelper.ImportFile> list = this.this$0.tabbedViewPanel.getSelectedFiles();
                boolean bl = PPImportDataHelper.isHySpexFileExtension(list);
                this.this$0.hyspexFilePanel.setVisible(bl);
                this.this$0.extractDarkReferenceCheckBox.setSelected(bl && HySpexHelper.getDataFormat(list.getFirst().getRawFile()).equals((Object)RtFramePredictor.ReferenceConvertTo.None));
                this.this$0.dataCorrectionPanel.setVisible(PPImportDataHelper.isRawFiles(list));
                this.this$0.customReference.showEntry(list);
            }
        };
        this.applyCheckBox = new BreezeCheckBox("Automatically apply workflow to imported files", true);
        pPDescriptionPanel.addOption(this.applyCheckBox);
        this.applyCheckBox.setName("applychanges");
        CollapsePanel collapsePanel = new CollapsePanel("Alternative reference settings", false);
        collapsePanel.setOpaque(false);
        collapsePanel.addPanel(this.customReference);
        pPDescriptionPanel.addOption(collapsePanel);
        this.hyspexFilePanel.setOpaque(false);
        this.hyspexFilePanel.addPanel(this.extractDarkReferenceCheckBox);
        this.hyspexFilePanel.addPanel(this.correctBadPixelsCheckBox);
        this.correctBadPixelsCheckBox.setName("correctbadpixels");
        pPDescriptionPanel.addOption(this.hyspexFilePanel);
        this.dataCorrectionPanel.setOpaque(false);
        this.dataCorrectionPanel.addPanel(this.replaceDataIgnoreValuePixelsComboBox);
        this.replaceDataIgnoreValuePixelsComboBox.setName("dataignorevalue");
        this.replaceDataIgnoreValuePixelsComboBox.addItems((DataIgnoreAction[])DataIgnoreAction.values());
        this.replaceDataIgnoreValuePixelsComboBox.setSelectedIndex(1);
        this.replaceDataIgnoreValuePixelsComboBox.setValueWidth(400);
        pPDescriptionPanel.addOptionNoFill(this.dataCorrectionPanel);
        CollapsePanel collapsePanel2 = new CollapsePanel("Metadata (Optional)", true);
        collapsePanel2.setOpaque(false);
        collapsePanel2.addPanel(this.maxSignalInputField);
        collapsePanel2.addPanel(this.fieldOfViewInputField);
        collapsePanel2.addPanel(this.integrationTimeInputField);
        pPDescriptionPanel.addOption(collapsePanel2);
        this.viewClassList.add(new ViewClass("Settings", "Setting for file import", pPDescriptionPanel));
        this.setLists(this.viewClassList);
    }

    private Group getGroup(Object object) {
        Group group = Group.getGroup(object);
        if (group != null) {
            return group;
        }
        throw new ErrorHandler.InformationMessageException("No Group to import into.\nPlease add a Group and try again.");
    }

    public File getCurrentDirectory() {
        return this.tabbedViewPanel.getCurrentDirectory();
    }

    public File getSelectedFile() {
        return this.tabbedViewPanel.getSelectedFile();
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void finishWizard() {
        BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this){

            @Override
            public void onFinish() {
                PPImportData.this.mainPanel.selectTab("Table");
            }

            @Override
            public void runAction() throws Exception {
                Measurement measurement;
                this.setInfoText("Importing...");
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
                List<PPImportDataHelper.ImportFile> list = PPImportData.this.tabbedViewPanel.getSelectedFiles();
                int n = breezeProgressManager.setGroupMaximumAndReset(list.size());
                try {
                    for (PPImportDataHelper.ImportFile object : list) {
                        if (!breezeProgressManager.isAborted()) {
                            measurement = this.importIntoMeasurement(breezeProgressManager, object);
                            this.addIdentifiers(measurement);
                            arrayList.add(measurement);
                            object.setMeasurement(measurement);
                            breezeProgressManager.incStepGroup(n);
                            continue;
                        }
                        break;
                    }
                }
                catch (BreezeProgress.ProgressActionCancelledException progressActionCancelledException) {
                    // empty catch block
                }
                if (!arrayList.isEmpty()) {
                    PPImportData.this.previewPanel.crop(breezeProgressManager, list, arrayList);
                    for (Measurement measurement2 : arrayList) {
                        measurement = PPImportData.this.group.getMeasurement(measurement2.getName());
                        if (measurement != null) {
                            PPImportData.this.group.removeChild(measurement);
                        }
                        PPImportData.this.group.addChild(measurement2);
                    }
                    if (PPImportData.this.applyCheckBox.isSelected()) {
                        ApplyChanges.applyChanges((BreezeProgress)breezeProgressManager, arrayList);
                    }
                    PPImportData.this.group.getParent().save();
                    if (PPImportData.this.mainPanel instanceof EntryMeasurementPanel && arrayList.size() > 0) {
                        PPImportData.this.mainPanel.setEntryListModel(PPImportData.this.group.getChildList(), ListHelper.SortType.Created, false);
                        PPImportData.this.mainPanel.selectEntry(arrayList.get(0));
                    }
                }
            }

            private void addIdentifiers(Measurement measurement) {
                try {
                    HdrParser hdrParser;
                    String string;
                    RawFile rawFile = measurement.rawFile();
                    if (rawFile != null && (string = rawFile.header().getDescription()) != null && (hdrParser = new HdrParser(string)).contains("corebox")) {
                        IdentifierList identifierList = PPImportData.this.group.getParent().getIdentifiers();
                        identifierList.addIdentifierOrGetExisting("Core box").setValue(hdrParser.get("corebox"), measurement.getRootSample());
                        if (hdrParser.contains("depth from")) {
                            identifierList.addIdentifierOrGetExisting("Depth from").setValue(hdrParser.get("depth from"), measurement.getRootSample());
                        }
                        if (hdrParser.contains("depth to")) {
                            identifierList.addIdentifierOrGetExisting("Depth to").setValue(hdrParser.get("depth to"), measurement.getRootSample());
                        }
                        measurement.save();
                    }
                }
                catch (Exception exception) {
                    Logg.error((String)"Error adding identifiers", (Throwable)exception);
                }
            }

            private Measurement importIntoMeasurement(BreezeProgressManager breezeProgressManager, PPImportDataHelper.ImportFile importFile) throws IOException {
                return switch (importFile.type) {
                    case PPImportDataHelper.ImportType.BreezeFolder, PPImportDataHelper.ImportType.SpecimFolder -> PPImportData.this.copyBreezeFolder(breezeProgressManager, importFile, PPImportData.this.group);
                    case PPImportDataHelper.ImportType.RawFile -> PPImportData.this.copyRawFiles(breezeProgressManager, importFile, PPImportData.this.group);
                    default -> PPImportData.this.importWithEvince(breezeProgressManager, importFile, PPImportData.this.group);
                };
            }
        }, "Importing data");
    }

    private Measurement copyRawFiles(BreezeProgress breezeProgress, PPImportDataHelper.ImportFile importFile, Group group) throws IOException {
        File file = importFile.fileOrFolder;
        String string = FileHelper.getFileName(file);
        File file2 = FileHelper.getFirstEnumerateFolder(new File(group.getFolder(), string));
        try {
            file2.mkdirs();
            this.copyRawFile(breezeProgress, file, file2, "measurement");
            File[] fileArray = HdrImageImportInfo.getReferenceFiles((File)file);
            if (fileArray != null) {
                if (!this.customReference.useOneDarkReference()) {
                    this.copyRawFile(breezeProgress, fileArray[0], file2, "darkref_measurement");
                }
                if (!this.customReference.useOneWhiteReference()) {
                    this.copyRawFile(breezeProgress, fileArray[1], file2, "whiteref_measurement");
                }
            }
            PPImportDataHelper.BadPixels badPixels = PPImportDataHelper.getSatMask(file);
            File file3 = new File(file2, "measurement.raw");
            RawHeader rawHeader = RawHeader.findByRaw(file3);
            if (badPixels != null && badPixels.totalCount > 0) {
                RawHelper.replacePixelsWithZero(breezeProgress, file3, badPixels);
            }
            this.additional(breezeProgress, file2, () -> {
                block10: {
                    float[] fArray;
                    File file4 = new File(file2, "whiteref_measurement.raw");
                    if (HySpexHelper.isHySpexFile(file)) {
                        try {
                            File file5;
                            Object object;
                            HySpexHeader hySpexHeader = new HySpexHeader(file);
                            File file6 = null;
                            if (this.extractDarkReferenceCheckBox.isVisibleAndSelected() && !this.customReference.useOneDarkReference() && (object = hySpexHeader.getBackgrounds()) != null && ((double[][])object).length > 0) {
                                file6 = new File(file2, "darkref_measurement.raw");
                                hySpexHeader.saveInEnvi(breezeProgress, file6, (double[][])object, rawHeader.bandNames());
                            }
                            if (!this.correctBadPixelsCheckBox.isVisibleAndSelected() || hySpexHeader.nobp <= 0) break block10;
                            object = hySpexHeader.getBadPixelMap();
                            HySpexHelper.applyBadPixels(breezeProgress, file3, (List<HySpexHelper.BadPixel>)object);
                            if (file6 != null) {
                                HySpexHelper.applyBadPixels(breezeProgress, file6, (List<HySpexHelper.BadPixel>)object);
                            }
                            if ((file5 = file4).exists() && this.customReference.hasWhiteSelected()) {
                                HySpexHelper.applyBadPixels(breezeProgress, file5, (List<HySpexHelper.BadPixel>)object);
                            }
                        }
                        catch (HySpexHeader.UnknowHySpexFormat unknowHySpexFormat) {
                            Logg.debug((String)"Cannot parse HySpex header", (Object[])new Object[]{unknowHySpexFormat});
                        }
                    } else if (!this.customReference.useOneWhiteReference() && !file4.exists() && (fArray = rawHeader.dataGainValues()) != null) {
                        PixelWidth pixelWidth = rawHeader.pixelWidth();
                        RawHeader rawHeader2 = new RawHeader(new FrameCount(fArray.length), new BandCount(fArray.length), pixelWidth, DataSize.FLOAT_4);
                        rawHeader2.setBandNames(rawHeader.bandNames());
                        FloatFrame floatFrame = new FloatFrame(new BandCount(fArray.length), pixelWidth, rawHeader.bandNames());
                        for (int i = 0; i < fArray.length; ++i) {
                            for (int j = 0; j < pixelWidth.value; ++j) {
                                floatFrame.setFrameValue(i, j, fArray[i]);
                            }
                        }
                        RawFileWriter.writeFramesAndHeader(file4, List.of(floatFrame), rawHeader2, "Created by Breeze");
                    }
                }
            });
        }
        catch (BreezeProgress.ProgressActionCancelledException progressActionCancelledException) {
            FileUtils.deleteDirectory((File)file2);
            throw progressActionCancelledException;
        }
        return new Measurement(file2, group);
    }

    private void copyRawFile(BreezeProgress breezeProgress, File file, File file2, String string) {
        File file3 = RawHeader.findHeaderFileByRaw(file);
        if (file3.exists()) {
            File file4 = this.copyIfExist(breezeProgress, file, file2, string + ".raw");
            this.copyIfExist(breezeProgress, file3, file2, string + ".hdr");
            RawHeader rawHeader = new RawHeader(file3);
            if (RawFileConverter.shouldConvert(rawHeader)) {
                RawFileConverter.convertToBil(breezeProgress, file4);
            }
            PPImportData.addOrigFile(file, new File(file2, string + ".hdr"));
        } else {
            this.copyIfExist(breezeProgress, file, file2, string + ".raw");
        }
    }

    public static void addOrigFile(File file, File file2) {
        if (file2.exists()) {
            try {
                RawHeader rawHeader = new RawHeader(file2);
                String string = rawHeader.getDescription();
                ExtraHeaderValues extraHeaderValues = new ExtraHeaderValues();
                extraHeaderValues.addValues(rawHeader.getParser());
                if (string == null || !string.contains("origfile")) {
                    rawHeader.setDescription((string != null ? string : "") + "\n origfile = " + file.getAbsolutePath());
                    rawHeader.save(extraHeaderValues);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot add orig file to header", exception);
            }
        }
    }

    private File copyIfExist(BreezeProgress breezeProgress, File file, File file2, String string) {
        File file3 = new File(file2, string);
        if (file.exists()) {
            breezeProgress.setMaximumAndReset(FileHelper.getFileChunkSize(file));
            FileHelper.copyFile(breezeProgress, file, file3);
            if (breezeProgress.isAborted()) {
                throw new BreezeProgress.ProgressActionCancelledException();
            }
        }
        return file3;
    }

    private Measurement copyBreezeFolder(BreezeProgress breezeProgress, PPImportDataHelper.ImportFile importFile, Group group) {
        Object object;
        File file = importFile.getFromFolder();
        String string = this.getFolderName(file, importFile.getGroupName());
        File file2 = FileHelper.getFirstEnumerateFolder(new File(group.getFolder(), string));
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File object2 : FileHelper.getFiles(file, false)) {
            object = FileHelper.getFileExtension(object2);
            if (((String)object).equalsIgnoreCase("raw")) {
                RawFileImpl rawFileImpl = new RawFileImpl(object2);
                RawHeader rawHeader = rawFileImpl.header();
                arrayList.add(rawFileImpl.file());
                arrayList.add(rawHeader.file());
                PPImportData.addOrigFile(object2, rawHeader.file());
                continue;
            }
            if (((String)object).equalsIgnoreCase("hdr")) continue;
            arrayList.add(object2);
        }
        breezeProgress.setMaximumAndReset(FileHelper.getFolderChunkSize(arrayList));
        FileHelper.copyFiles(breezeProgress, arrayList, file2);
        new LegacyFileFormat.MeasurementLegacyFileFormat().renameAdditionalFiles(file2, string);
        if (breezeProgress.isAborted()) {
            throw new BreezeProgress.ProgressActionCancelledException();
        }
        for (RawFile rawFile : FileHelper.getRawFiles(file2)) {
            object = rawFile.header();
            if (!RawFileConverter.shouldConvert((RawHeader)object)) continue;
            RawFileConverter.convertToBil(breezeProgress, rawFile.file());
        }
        this.additional(breezeProgress, file2, () -> {});
        DescriptorToPropertiesHelper.perform(file, group, file2);
        return new Measurement(file2, group);
    }

    private String getFolderName(File file, String string) {
        if (PPImportDataHelper.isBreezeFolder(file) || PPImportDataHelper.isLegacyFolder(file)) {
            return string;
        }
        File file2 = null;
        for (File file3 : file.listFiles()) {
            if (!"hdr".equalsIgnoreCase(FileHelper.getFileExtension(file3)) || file2 != null && file3.getName().length() >= file2.getName().length()) continue;
            file2 = file3;
        }
        if (file2 != null) {
            return FileHelper.getFileName(file2);
        }
        return string;
    }

    private void additional(BreezeProgress breezeProgress, File file, Runnable runnable) {
        String string;
        MetaDataProperties metaDataProperties = new MetaDataProperties();
        RawHeader rawHeader = new RawHeader(new File(file, "measurement.hdr"));
        if (this.customReference.useOneReference()) {
            this.customReference.copyFiles(breezeProgress, file, rawHeader);
        }
        runnable.run();
        RtHdrParser rtHdrParser = rawHeader.getParser();
        DataIgnoreAction dataIgnoreAction = this.replaceDataIgnoreValuePixelsComboBox.getSelectedItem();
        if (dataIgnoreAction.replace() && rtHdrParser.contains("data ignore value")) {
            RawHelper.replaceIgnoredPixelsWithZero(breezeProgress, new File(file, "measurement.raw"), rtHdrParser.getFloat("data ignore value"), dataIgnoreAction == DataIgnoreAction.ReplaceAllWavelength);
        }
        if ((string = rawHeader.getDescription()) != null) {
            HdrParser hdrParser = new HdrParser(string);
            if (hdrParser.contains("pixelsize x") && hdrParser.contains("lens")) {
                HySpexHelper.LensInfo lensInfo = HySpexHelper.getLensInfo(hdrParser.getInt("lens"));
                double d = HySpexHelper.getFieldOfView(lensInfo, hdrParser.getNumber("pixelsize x"), rawHeader.pixelWidth().value);
                metaDataProperties.addProperty("LensWorkDistance", lensInfo.name());
                metaDataProperties.addProperty("LensDegree", RtDataFormat.toString(lensInfo.degree()));
                if (d > 0.0) {
                    metaDataProperties.addProperty("FieldOfView", RtDataFormat.toString(d));
                }
            }
            if (hdrParser.contains("integration time")) {
                metaDataProperties.addProperty("IntegrationTime", hdrParser.get("integration time"));
            }
            if (hdrParser.contains("id")) {
                metaDataProperties.addProperty("CameraName", hdrParser.get("id"));
            }
            if (hdrParser.contains("serialnumber")) {
                metaDataProperties.addProperty("SerialNumber", hdrParser.get("serialnumber"));
            }
        }
        this.addMetaProperties(metaDataProperties);
        this.createXmlFileIfMissing(file, metaDataProperties);
    }

    private Measurement importWithEvince(BreezeProgressManager breezeProgressManager, PPImportDataHelper.ImportFile importFile, Group group) {
        File file = importFile.fileOrFolder;
        File file2 = FileHelper.getFirstEnumerateFolder(new File(group.getFolder(), FileHelper.getFileName(file)));
        Measurement measurement = new Measurement(FileHelper.getFileName(file2), group);
        if (FileHelper.getFileExtension(file).equalsIgnoreCase("sac")) {
            new PPImportDataHelper.SacFileExtractUtility(file, measurement);
            this.addMetaProperties(measurement.getMetaProperties(), measurement.getFolder(), measurement.getName());
        } else {
            EvinceHelper.importUsingEvince(breezeProgressManager, file, new MeasurementFileLocation.Raw().file(measurement));
            group.addChild(measurement);
            this.addMetaProperties(measurement.getMetaProperties(), measurement.getFolder(), "measurement");
            PPImportData.addOrigFile(file, measurement.rawFile().header().file());
            this.additional(breezeProgressManager, measurement.getFolder(), () -> {});
        }
        measurement.save();
        return measurement;
    }

    private void addMetaProperties(MetaDataProperties metaDataProperties, File file, String string) {
        metaDataProperties.addProperty("Time", format.format(new Date(file.lastModified())));
        this.addMetaProperties(metaDataProperties);
        File file2 = new File(file, string + ".hdr");
        if (file2.exists()) {
            RawHeader rawHeader = new RawHeader(file2);
            Resolution resolution = this.calcResolution(metaDataProperties.getMetaValueNullIfMissing("FieldOfView"), rawHeader);
            metaDataProperties.addProperty("Resolution", String.valueOf(resolution.value));
            metaDataProperties.addProperty("Length", String.valueOf(new LengthValue((Resolution)resolution, (FrameCount)rawHeader.frameCount()).value));
            metaDataProperties.addProperty("Frames", String.valueOf(rawHeader.frameCount().value));
            metaDataProperties.addProperty("PixelsPerLine", String.valueOf(rawHeader.pixelWidth().value));
            metaDataProperties.addProperty("Wavelength", String.valueOf(rawHeader.bandCount().value));
        }
    }

    private void addMetaProperties(MetaDataProperties metaDataProperties) {
        File file;
        if (!this.maxSignalInputField.isEmpty()) {
            metaDataProperties.addProperty("MaxSignal", this.maxSignalInputField.getValue());
        }
        if (!this.fieldOfViewInputField.isEmpty()) {
            metaDataProperties.addProperty("FieldOfView", this.fieldOfViewInputField.getValue());
        }
        if (!this.integrationTimeInputField.isEmpty()) {
            metaDataProperties.addProperty("IntegrationTime", this.integrationTimeInputField.getValue());
        }
        if ((file = this.customReference.calibratedReflectanceTargetFile()) != null) {
            metaDataProperties.addProperty("ReflectanceTarget", file.getAbsolutePath());
        }
    }

    private Resolution calcResolution(String string, RawHeader rawHeader) {
        if (string != null && NiceDataFormat.isNumber((String)string)) {
            return new Resolution(new FieldOfView((float)NiceDataFormat.toNumber((String)string)), rawHeader.pixelWidth());
        }
        return new Resolution(1.0f);
    }

    private void createXmlFileIfMissing(File file, MetaDataProperties metaDataProperties) {
        File file2 = new File(file, "measurement.xml");
        if (!file2.exists()) {
            Document document = XmlParserHelper.createXMLdoc();
            Element element = XmlParserHelper.addRoot("measurement", document);
            EntryData entryData = new EntryData(null, "measurement", file);
            entryData.writeXmlAttributes(element, "Measurement");
            DefaultXmlProperties defaultXmlProperties = new DefaultXmlProperties("settings");
            defaultXmlProperties.setPropertyBoolLocal("changed", true);
            XmlProperties.addProperties(defaultXmlProperties, document, element);
            this.addMetaProperties(metaDataProperties, file, "measurement");
            metaDataProperties.writeMetadataToXml(element);
            XmlProperties.createDirectoriesAndOutputXML(file2, document);
        } else if (metaDataProperties.size() > 0) {
            GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
            groupWithoutIO.setFolder(file.getParentFile());
            Measurement measurement = new Measurement(file, (Group)groupWithoutIO);
            MetaDataProperties metaDataProperties2 = measurement.getMetaProperties();
            metaDataProperties2.addProperties(metaDataProperties);
            this.addMetaProperties(metaDataProperties2, file, "measurement");
            measurement.save();
        }
    }

    public FileChooserPanel getFileSelectionPanel() {
        return this.tabbedViewPanel.getFileSelectionPanel();
    }

    public void setCustomReferences(File file, File file2) {
        this.customReference.setReferences(file, file2);
    }

    public void setReferenceInMeasurement(File file, int[] nArray) {
        this.customReference.setReferences(null, file);
        this.customReference.setValuesAndEnable(nArray);
    }

    public void setCalibratedReflectanceTarget(File file) {
        this.customReference.setCalibratedReflectanceTarget(file);
    }

    public void setCustom(MaxSignal maxSignal, FieldOfView fieldOfView, IntegrationTime integrationTime) {
        if (maxSignal != null) {
            this.maxSignalInputField.setValue(maxSignal.value);
        }
        if (fieldOfView != null) {
            this.fieldOfViewInputField.setValue(fieldOfView.value);
        }
        if (integrationTime != null) {
            this.integrationTimeInputField.setValue(integrationTime.value);
        }
    }

    public static enum DataIgnoreAction {
        Ignore("Ignore"),
        ReplaceAllWavelength("Replace with zeros for all wavelength"),
        Replace("Replace with zeros");

        private final String description;

        private DataIgnoreAction(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        boolean replace() {
            return this.equals((Object)ReplaceAllWavelength) || this.equals((Object)Replace);
        }
    }

    public static class Info
    extends PPInfo.PPImportInfo {
        @Override
        public String getDescription() {
            return "External measurements or image data files into group";
        }

        @Override
        public String getName() {
            return "Images";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPImportData(entryMainPanel, string, object);
        }
    }
}

