/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard.importdata;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.FrameCube;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileConverter;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.CustomReferenceInterface;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportData;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.CalibratedReflectanceTargetList;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.dataimport.image.hdr.HdrParser;

public class PPImportDataCustomReferencePanel
extends JPanel
implements CustomReferenceInterface {
    private final BreezeCheckBox checkBox = new BreezeCheckBox("Use the same references for all files", false);
    private final ReferenceInputField darkReference;
    private final ReferenceInputField whiteReference;
    private final HySpexCamera.CalibratedReflectanceTargetInputField calibratedReflectanceTarget;
    private final PPImportData ppImportData;
    private final ReferenceInMeasurement referenceInMeasurement;

    public PPImportDataCustomReferencePanel(JFrame jFrame, final PPImportData pPImportData) {
        super(new GridBagLayout());
        this.ppImportData = pPImportData;
        this.setOpaque(false);
        this.addComponent(this.checkBox);
        this.checkBox.addChangeListener(changeEvent -> this.setOneReference(this.checkBox.isSelected()));
        this.darkReference = new ReferenceInputField(jFrame, "Dark reference");
        this.addComponent(this.darkReference);
        this.whiteReference = new ReferenceInputField(jFrame, "White reference");
        this.addComponent(this.whiteReference);
        this.referenceInMeasurement = new ReferenceInMeasurement(jFrame, this);
        this.addComponent(this.referenceInMeasurement);
        this.calibratedReflectanceTarget = new HySpexCamera.CalibratedReflectanceTargetInputField(this, jFrame){
            final /* synthetic */ PPImportDataCustomReferencePanel this$0;
            {
                this.this$0 = pPImportDataCustomReferencePanel;
                super(component);
            }

            @Override
            protected File getDefaultDirectory() {
                return pPImportData.getCurrentDirectory();
            }
        };
        this.addComponent(this.calibratedReflectanceTarget);
        this.addComponent(new BreezeLabel(""));
        this.setOneReference(false);
    }

    public void showEntry(List<PPImportDataHelper.ImportFile> list) {
    }

    public void setReferences(File file, File file2) {
        this.checkBox.setSelected(true);
        if (file != null) {
            this.darkReference.setFile(file);
        }
        if (file2 != null) {
            this.whiteReference.setFile(file2);
        }
    }

    public void setCalibratedReflectanceTarget(File file) {
        this.calibratedReflectanceTarget.setFile(file);
    }

    private void addComponent(JComponent jComponent) {
        this.add((Component)jComponent, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 12, 0, 12)));
    }

    private void setOneReference(boolean bl) {
        this.darkReference.setEditable(bl);
        this.whiteReference.setEditable(bl);
        this.calibratedReflectanceTarget.setEditable(bl);
        this.referenceInMeasurement.enableFields();
    }

    @Override
    public boolean useOneReference() {
        return this.checkBox.isSelected();
    }

    public boolean useOneWhiteReference() {
        return this.useOneReference() && this.whiteReference.hasValue();
    }

    public boolean useOneDarkReference() {
        return this.useOneReference() && this.darkReference.hasValue();
    }

    public Pair<String, WizardStep.LeaveResult> checkValidContent(List<PPImportDataHelper.ImportFile> list, boolean bl) {
        Object object;
        if (this.useOneReference()) {
            object = this.validate(this.darkReference);
            if (object != null) {
                return Pair.of((Object)object, (Object)((Object)WizardStep.LeaveResult.Failed));
            }
            String string = this.validate(this.whiteReference);
            if (string != null) {
                return Pair.of((Object)string, (Object)((Object)WizardStep.LeaveResult.Failed));
            }
            String string2 = this.referenceInMeasurement.checkValidContent();
            if (string2 != null) {
                return Pair.of((Object)string2, (Object)((Object)WizardStep.LeaveResult.Failed));
            }
        }
        if (bl && !this.hasWhiteSelected()) {
            return Pair.of((Object)"Dark reference is extracted from .hyspex file. It is recommended to also select a white reference.\n\nPress Cancel and select white reference file or extract white reference from measurement.\n\nPress OK to continue without white reference", (Object)((Object)WizardStep.LeaveResult.Control));
        }
        object = this.calibratedReflectanceTargetFile();
        if (object == null) {
            if (bl) {
                // empty if block
            }
        } else if (!((File)object).exists()) {
            return Pair.of((Object)("Cannot locate calibrated reflectance target file: " + ((File)object).getAbsolutePath()), (Object)((Object)WizardStep.LeaveResult.Failed));
        }
        return Pair.of((Object)"", (Object)((Object)WizardStep.LeaveResult.Ok));
    }

    public boolean hasWhiteSelected() {
        if (this.useOneReference()) {
            if (this.referenceInMeasurement.useSplit()) {
                return true;
            }
            return this.whiteReference.getFile() != null;
        }
        return false;
    }

    private String validate(ReferenceInputField referenceInputField) {
        File file = referenceInputField.getFile();
        if (file != null && !file.exists()) {
            return referenceInputField.getDesc() + " file does not exist: (" + file.getAbsolutePath() + ")";
        }
        return null;
    }

    public void copyFiles(BreezeProgress breezeProgress, File file, RawHeader rawHeader) {
        try {
            Object object;
            Object object2;
            File file2;
            File file3 = new File(file, "measurement.raw");
            File file4 = new File(file, "darkref_measurement.raw");
            File file5 = new File(file, "darkref_measurement.hdr");
            if (this.useOneDarkReference()) {
                file2 = this.darkReferenceFile();
                PPImportDataCustomReferencePanel.importReference(breezeProgress, file2, file4);
                PPImportData.addOrigFile(file2, file5);
            }
            file2 = new File(file, "whiteref_measurement.raw");
            File file6 = new File(file, "whiteref_measurement.hdr");
            if (this.useOneWhiteReference()) {
                Object object3;
                object2 = this.whiteReferenceFile();
                PPImportDataCustomReferencePanel.importReference(breezeProgress, (File)object2, file2);
                object = new RawHeader(file6);
                int n = rawHeader.getXstart();
                int n2 = rawHeader.pixelWidth().value;
                int n3 = ((RawHeader)object).getXstart();
                int n4 = ((RawHeader)object).pixelWidth().value;
                if (n > 0 || n3 > 0 || n2 != n4) {
                    object3 = new File(file, "measurement.raw");
                    if (n > n3) {
                        var16_19 = n - n3;
                        var17_21 = Math.min(rawHeader.pixelWidth().value, ((RawHeader)object).pixelWidth().value - var16_19);
                        if (var17_21 < n4) {
                            RawHelper.crop(file2, var16_19, 0, var16_19 + var17_21, ((RawHeader)object).frameCount().value, file2, false, false);
                        }
                        if (var17_21 < n2) {
                            RawHelper.crop((File)object3, 0, 0, var17_21, rawHeader.frameCount().value, (File)object3, false, true);
                        }
                    } else {
                        var16_19 = n3 - n;
                        var17_21 = Math.min(rawHeader.pixelWidth().value - var16_19, ((RawHeader)object).pixelWidth().value);
                        if (var17_21 < n2) {
                            RawHelper.crop((File)object3, var16_19, 0, var16_19 + var17_21, rawHeader.frameCount().value, (File)object3, false, true);
                        }
                        if (var17_21 < n4) {
                            RawHelper.crop(file2, 0, 0, var17_21, ((RawHeader)object).frameCount().value, file2, false, false);
                        }
                    }
                }
                if (this.referenceInMeasurement.useSplit()) {
                    RawHelper.extractWhite(file2, file2, file4, this.referenceInMeasurement.getValues());
                }
                if (HySpexHelper.isHySpexFile((File)object2)) {
                    object3 = new HySpexHeader((File)object2);
                    double[] dArray = ((HySpexHeader)object3).background;
                    RawHeader rawHeader2 = new RawHeader(file5);
                    if (dArray != null && dArray.length == ((RawHeader)object).pixelWidth().value && dArray.length == rawHeader2.pixelWidth().value) {
                        RawHelper.switchDarkReference(file2, HySpexHelper.createFrame(((HySpexHeader)object3).background, ((HySpexHeader)object3).spectralSize, ((HySpexHeader)object3).spatialSize, FrameListFromRaw.Reduce.Original, ((HySpexHeader)object3).getBandNames()), file4);
                    }
                }
                PPImportData.addOrigFile((File)object2, file6);
            } else if (this.useOneReference() && this.referenceInMeasurement.useSplit()) {
                RawHelper.extractWhite(file3, file2, file4, this.referenceInMeasurement.getValues());
                if (!file4.exists()) {
                    object2 = RawHeader.findByRaw(new File(file, "measurement.raw"));
                    object = new FrameCount(25);
                    FrameCube frameCube = new FrameCube(((RawHeader)object2).bandCount(), ((RawHeader)object2).pixelWidth(), (FrameCount)object, ((RawHeader)object2).dataSize());
                    frameCube.setValue(0.0f);
                    RawFileWriter.writeFramesAndHeader(file, FileHelper.getFileName(file4), frameCube.getFrameList());
                }
            }
            object2 = this.calibratedReflectanceTargetFile();
            if (object2 != null && file6.exists()) {
                object = new RawHeader(file6);
                CalibratedReflectanceTargetList calibratedReflectanceTargetList = CalibratedReflectanceTargetList.fromTargetFile((File)object2);
                ((RawHeader)object).setReferenceTarget(calibratedReflectanceTargetList.getReferenceTarget(((RawHeader)object).bandNames()));
                ((RawHeader)object).save();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void importReference(BreezeProgress breezeProgress, File file, File file2) throws IOException {
        if (PPImportDataHelper.isRawFile(file)) {
            FileHelper.copyFileIfNotSame(file, file2);
            FileHelper.copyFileIfNotSame(RawHeader.findHeaderFileByRaw(file), RawHeader.getHeaderFileByRaw(file2));
            RawHeader rawHeader = RawHeader.findByRaw(file2);
            if (RawFileConverter.shouldConvert(rawHeader)) {
                RawFileConverter.convertToBil(breezeProgress, file2);
            }
        } else if (breezeProgress instanceof BreezeProgressManager) {
            BreezeProgressManager breezeProgressManager = (BreezeProgressManager)breezeProgress;
            EvinceHelper.importUsingEvince(breezeProgressManager, file, file2);
        } else {
            EvinceHelper.importUsingEvince(BreezeProgressManager.createEmpty(), file, file2);
        }
    }

    private File darkReferenceFile() {
        return this.darkReference.getFile();
    }

    private File whiteReferenceFile() {
        return this.whiteReference.getFile();
    }

    public File calibratedReflectanceTargetFile() {
        return this.calibratedReflectanceTarget.getFile();
    }

    public void setValuesAndEnable(int[] nArray) {
        this.checkBox.setEnabled(true);
        this.referenceInMeasurement.setValuesAndEnable(nArray);
    }

    @Override
    public File getWhiteRefOrSelectedFile() {
        if (this.useOneWhiteReference()) {
            return this.whiteReferenceFile();
        }
        return FileHelper.getRawFile(this.ppImportData.getSelectedFile());
    }

    @Override
    public String getExtractText() {
        return "Extract white reference from measurement or selected white reference file above";
    }

    private class ReferenceInputField
    extends FileInputField {
        public ReferenceInputField(Component component, String string) {
            super(component, string, (String)null, null, true);
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            FileChooserPanel.addDataFileFilters(jopensaveDialog2, FileChooserPanel.FilterType.IMAGE);
            if (PPImportDataCustomReferencePanel.this.ppImportData != null) {
                jopensaveDialog2.setCurrentDirectory(PPImportDataCustomReferencePanel.this.ppImportData.getCurrentDirectory());
            }
            jopensaveDialog2.addAllSupported();
        }
    }

    public static class ReferenceInMeasurement
    extends JPanel {
        private final BreezeCheckBox checkBox = new BreezeCheckBox("", false);
        private final BreezeInputField.Number startNumberField = new BreezeInputField.Number("Start frame", 100.0, "");
        private final BreezeInputField.Number endNumberField = new BreezeInputField.Number("End frame", 200.0, "");
        private final BreezeInputField startPixelNumberField = new BreezeInputField("Start pixel", "", "");
        private final BreezeInputField endPixelNumberField = new BreezeInputField("End pixel", "", "");
        private final BreezeLabel infoLabel = new BreezeLabel("Average will be calulcated for each line when using start and end pixel", false, 14);
        private final BreezeButton editButton;
        private final CustomReferenceInterface customReference;
        private BufferedImage cropImage;

        public ReferenceInMeasurement(final JFrame jFrame, CustomReferenceInterface customReferenceInterface) {
            super(new GridBagLayout());
            this.customReference = customReferenceInterface;
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.checkBox.setText(customReferenceInterface.getExtractText());
            this.addComponent(this.checkBox);
            this.checkBox.addChangeListener(changeEvent -> this.enableFields());
            this.startNumberField.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.startNumberField.setLabelWidth(100);
            this.startNumberField.getTextField().setDefaultValue("1");
            this.endNumberField.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.endNumberField.setLabelWidth(100);
            this.endNumberField.getTextField().setDefaultValue("1");
            this.startPixelNumberField.setText("");
            this.startPixelNumberField.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.startPixelNumberField.setLabelWidth(100);
            this.startPixelNumberField.getTextField().setDefaultValue("");
            this.startPixelNumberField.setNumberField(true);
            this.endPixelNumberField.setText("");
            this.endPixelNumberField.setFormat(BreezeInputFieldHelper.Format.OneRow);
            this.endPixelNumberField.setLabelWidth(100);
            this.endPixelNumberField.getTextField().setDefaultValue("");
            this.endPixelNumberField.setNumberField(true);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)this.startNumberField, GridBagHelper.create(0, 0, new Insets(0, 0, 0, 0)));
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, 1, new Insets(12, 0, 0, 0));
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)this.endNumberField, gridBagConstraints);
            jPanel.add((Component)this.startPixelNumberField, GridBagHelper.create(1, 0, new Insets(0, 20, 0, 0)));
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(1, 1, new Insets(12, 20, 0, 0));
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            jPanel.add((Component)this.endPixelNumberField, gridBagConstraints2);
            this.infoLabel.setIcon(ImageHelper.getResourceIcon("information"));
            this.infoLabel.setVisible(false);
            GridBagConstraints gridBagConstraints3 = GridBagHelper.create(0, 2, new Insets(12, 20, 0, 0));
            gridBagConstraints3.gridwidth = 0;
            jPanel.add((Component)this.infoLabel, gridBagConstraints3);
            this.startPixelNumberField.addChangeListener(textActionEvent -> this.infoLabel.setVisible(this.usePixelNumber()));
            this.endPixelNumberField.addChangeListener(textActionEvent -> this.infoLabel.setVisible(this.usePixelNumber()));
            this.editButton = EntryMainHelper.createSmallTextButton("Edit", () -> {
                final File file = customReferenceInterface.getWhiteRefOrSelectedFile();
                if (file == null || !file.exists()) {
                    throw new ErrorHandler.WarningMessageException("White reference raw file not found");
                }
                BreezeProgressDialog.startProgressWithCancel((BreezeFrame)jFrame, new ProgressAction(this){
                    final /* synthetic */ ReferenceInMeasurement this$0;
                    {
                        this.this$0 = referenceInMeasurement;
                    }

                    @Override
                    public void runAction() {
                        this.this$0.cropImage = TcpManager.getInstance().generateThumbnailFromRaw(this.getProgressManager(), file);
                    }

                    @Override
                    public void actionComplete() {
                        int n = this.this$0.cropImage.getHeight() - Math.min(this.this$0.endNumberField.getNumberInt(), this.this$0.cropImage.getHeight());
                        int n2 = Math.max(Math.min(this.this$0.startNumberField.getNumberInt(), n - 1), 0);
                        int n3 = this.this$0.usePixelNumber() ? this.this$0.cropImage.getWidth() - Math.min(this.this$0.endPixelNumberField.getNumberInt(), this.this$0.cropImage.getWidth()) : 0;
                        int n4 = this.this$0.usePixelNumber() ? Math.max(Math.min(this.this$0.startPixelNumberField.getNumberInt(), n3 - 1), 0) : 0;
                        CropImagePanel cropImagePanel = new CropImagePanel(this.this$0.cropImage, n2, n4, n, n3, InsetsPanel.InsetsType.WhiteReference);
                        cropImagePanel.setTopText(this.this$0.startNumberField.getDescription());
                        cropImagePanel.setBottomText(this.this$0.endNumberField.getDescription());
                        cropImagePanel.setLeftText(this.this$0.startPixelNumberField.getDescription());
                        cropImagePanel.setRightText(this.this$0.endPixelNumberField.getDescription());
                        BreezeOptionDialog.showDialog((BreezeFrame)jFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "White reference interval", "", (AbstractBreezeCustomPanel)cropImagePanel, null, breezeActionEvent -> {
                            CropImagePanel cropImagePanel = (CropImagePanel)breezeActionEvent.getBreezeCustomPanel();
                            this.this$0.startNumberField.setValue(cropImagePanel.top());
                            this.this$0.endNumberField.setValue(cropImagePanel.bottomPos());
                            if (cropImagePanel.left() == 0 && cropImagePanel.rightPos() == this.this$0.cropImage.getWidth()) {
                                this.this$0.startPixelNumberField.setText("");
                                this.this$0.endPixelNumberField.setText("");
                                this.this$0.infoLabel.setVisible(false);
                            } else {
                                this.this$0.startPixelNumberField.setValue(cropImagePanel.left());
                                this.this$0.endPixelNumberField.setValue(cropImagePanel.rightPos());
                                this.this$0.infoLabel.setVisible(true);
                            }
                        });
                    }
                }, "Generating thumbnail preview");
            });
            jPanel.add((Component)this.editButton, GridBagHelper.create(2, 0, new Insets(0, 10, 0, 10)));
            this.addComponent(jPanel);
            this.addComponent(new BreezeLabel(""));
            this.enableFields();
        }

        private boolean usePixelNumber() {
            return this.startPixelNumberField.hasValue() && this.endPixelNumberField.hasValue();
        }

        public void setFromHeader(File file) {
            RawHeader rawHeader = new RawHeader(file);
            String string = rawHeader.getDescription();
            if (string != null) {
                int n;
                HdrParser hdrParser = new HdrParser(string);
                if (!this.customReference.useOneReference() && hdrParser.contains("calibavailable") && (n = hdrParser.getInt("calibavailable")) != 0 && hdrParser.contains("number of background")) {
                    int n2 = hdrParser.getInt("number of background");
                    this.endNumberField.setValue(n2);
                    this.startNumberField.setValue(0.0);
                }
            }
        }

        public void setValuesAndEnable(int[] nArray) {
            this.startNumberField.setValue(nArray[0]);
            this.endNumberField.setValue(nArray[1]);
            if (nArray.length == 4) {
                this.startPixelNumberField.setValue(nArray[2]);
                this.endPixelNumberField.setValue(nArray[3]);
            }
            this.checkBox.setSelected(true);
            this.enableFields();
        }

        public void enableFields() {
            boolean bl = this.customReference.useOneReference();
            this.checkBox.setEnabled(bl);
            boolean bl2 = this.checkBox.isSelected() && bl;
            this.startNumberField.setEnabled(bl2);
            this.endNumberField.setEnabled(bl2);
            this.startPixelNumberField.setEnabled(bl2);
            this.endPixelNumberField.setEnabled(bl2);
            this.editButton.setEnabled(bl2);
        }

        public int[] getValues() {
            return new int[]{this.startNumberField.getNumberInt(), this.endNumberField.getNumberInt(), this.startPixelNumberField.hasValue() ? this.startPixelNumberField.getNumberInt() : -1, this.endPixelNumberField.hasValue() ? this.endPixelNumberField.getNumberInt() : -1};
        }

        public boolean useSplit() {
            return this.checkBox.isSelected();
        }

        private void addComponent(JComponent jComponent) {
            this.add((Component)jComponent, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(12, 12, 0, 12)));
        }

        public String checkValidContent() {
            int[] nArray;
            if (this.useSplit() && (nArray = this.getValues())[0] >= nArray[1]) {
                return "Start frame (" + nArray[0] + ") must be before End frame (" + nArray[1] + ")";
            }
            return null;
        }
    }
}

