/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard.importdata;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.datasource.image.BreezeImportInfo;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.org.apache.tools.zip.ZipEntry;
import se.prediktera.map.common.org.apache.tools.zip.ZipFile;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.image.hdr.HySpexImageImportInfo;
import se.prediktera.map.dataimport.image.sac.SacDataSource;
import se.prediktera.map.dataimport.image.sac.SacXMLImageImportInfo;

public class PPImportDataHelper {
    public static BadPixels getSaturatedPixels(File file) {
        File file2 = RawHeader.findHeaderFileByRaw(file);
        BadPixels badPixels = new BadPixels();
        if (file2 != null) {
            RawHeader rawHeader = new RawHeader(file2);
            int n = rawHeader.pixelWidth().value;
            FrameListFromRaw frameListFromRaw = new FrameListFromRaw(file, rawHeader);
            for (int i = 0; i < frameListFromRaw.size(); ++i) {
                RawFrame rawFrame = (RawFrame)frameListFromRaw.get(i);
                BadPixels.BadFramePixels badFramePixels = null;
                for (int j = 0; j < n; ++j) {
                    float f = rawFrame.getFrameValue(0, j);
                    if (!(f > 0.0f)) continue;
                    if (badFramePixels == null) {
                        badFramePixels = new BadPixels.BadFramePixels(i);
                        badPixels.add(badFramePixels);
                    }
                    badFramePixels.add(j);
                    ++badPixels.totalCount;
                }
            }
        }
        return badPixels;
    }

    public static List<ImportFile> getImportFiles(List<File> list) {
        ArrayList<ImportFile> arrayList = new ArrayList<ImportFile>();
        if (list == null) {
            return arrayList;
        }
        for (File file : list) {
            File file22;
            if (file.isDirectory()) {
                if (PPImportDataHelper.isBreezeOrLegacyFolder(file)) {
                    arrayList.add(new ImportFile(file, ImportType.BreezeFolder));
                    continue;
                }
                if (SacXMLImageImportInfo.isSpecimFolder((File)file)) {
                    arrayList.add(new ImportFile(file, ImportType.SpecimFolder));
                    continue;
                }
                for (File file22 : PPImportDataHelper.getRawFilesInFolder(file)) {
                    arrayList.add(new ImportFile(file22, ImportType.RawFile));
                }
                continue;
            }
            File file3 = file.getParentFile();
            if (PPImportDataHelper.isBreezeOrLegacyFolder(file3, file)) {
                arrayList.add(new ImportFile(file3, ImportType.BreezeFolder));
                continue;
            }
            file22 = file3.getParentFile();
            if (file22 != null && SacXMLImageImportInfo.isSpecimFolder((File)file22)) {
                arrayList.add(new ImportFile(file22, ImportType.SpecimFolder));
                continue;
            }
            if (PPImportDataHelper.isRawFile(file)) {
                arrayList.add(new ImportFile(file, ImportType.RawFile));
                continue;
            }
            arrayList.add(new ImportFile(file, ImportType.EvinceImport));
        }
        return arrayList;
    }

    public static boolean isRawFiles(List<ImportFile> list) {
        for (ImportFile importFile : list) {
            if (!PPImportDataHelper.isRawFile(importFile.getRawFile())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawFile(File file) {
        String string = FileHelper.getFileExtension(file);
        if (file.isDirectory()) {
            return false;
        }
        for (String string2 : new HdrImageImportInfo().getExt()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : new HySpexImageImportInfo().getExt()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferenceFile(File file) {
        String string = file.getName().toLowerCase();
        return string.contains("darkref_") || string.contains("whiteref_");
    }

    public static boolean isPredictionFile(File file) {
        return file.getName().toLowerCase().contains("_prediction");
    }

    public static boolean isBreezeOrLegacyFolder(File file, File file2) {
        if (!file.exists()) {
            return false;
        }
        String string = FileHelper.getFileName(file2);
        if (PPImportDataHelper.isBreezeFolder(file)) {
            return string.startsWith("measurement");
        }
        if (PPImportDataHelper.isLegacyFolder(file)) {
            return string.startsWith(file.getName());
        }
        return false;
    }

    public static boolean isBreezeOrLegacyFolder(File file) {
        return file.exists() && (PPImportDataHelper.isBreezeFolder(file) || PPImportDataHelper.isLegacyFolder(file));
    }

    public static boolean isBreezeFolder(File file) {
        return new File(file, "measurement.xml").exists();
    }

    public static boolean isLegacyFolder(File file) {
        return new File(file, file.getName() + ".raw").exists();
    }

    public static boolean isHySpexFileExtension(List<ImportFile> list) {
        for (ImportFile importFile : list) {
            if (!PPImportDataHelper.isHySpexFileExtension(importFile.getRawFile())) continue;
            return true;
        }
        return false;
    }

    public static boolean isHySpexFileExtension(File file) {
        return FileHelper.getFileExtension(file).equalsIgnoreCase("hyspex");
    }

    public static List<File> getRawFilesInFolder(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists()) {
            for (File file2 : file.listFiles()) {
                if (!PPImportDataHelper.isRawFile(file2) || PPImportDataHelper.isReferenceFile(file2) || PPImportDataHelper.isPredictionFile(file2)) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public static boolean isImageFile(File file) {
        String string = FileHelper.getFileExtension(file);
        if (string.length() > 0) {
            Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, false);
            while (iterator.hasNext()) {
                String[] stringArray;
                for (String string2 : stringArray = iterator.next().getFileSuffixes()) {
                    String string3 = string2.trim();
                    if (!string3.equalsIgnoreCase(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static BadPixels getSatMask(File file) {
        File file2 = PPImportDataHelper.getSatMaskFile(file);
        if (file2 != null && file2.exists()) {
            return PPImportDataHelper.getSaturatedPixels(file2);
        }
        return null;
    }

    private static File getSatMaskFile(File file) {
        String string = FileHelper.getFileName(file);
        File file2 = new File(file.getParentFile(), string + ".sat");
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(file.getParentFile(), string + "_satmask");
        if (file3.exists()) {
            return file3;
        }
        File file4 = new File(file.getParentFile(), string + "_sat.img");
        if (file4.exists()) {
            return file4;
        }
        return null;
    }

    public static class BadPixels {
        public int totalCount;
        public List<BadFramePixels> list = new ArrayList<BadFramePixels>();

        public void add(BadFramePixels badFramePixels) {
            this.list.add(badFramePixels);
        }

        public String toCommaSeparated() {
            StringBuilder stringBuilder = new StringBuilder();
            for (BadFramePixels badFramePixels : this.list) {
                for (Integer n : badFramePixels.list) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(n);
                    stringBuilder.append(";");
                    stringBuilder.append(badFramePixels.index);
                }
            }
            return stringBuilder.toString();
        }

        public static class BadFramePixels {
            public int index;
            public List<Integer> list = new ArrayList<Integer>();

            public BadFramePixels(int n) {
                this.index = n;
            }

            public void add(int n) {
                this.list.add(n);
            }
        }
    }

    public static class ImportFile {
        public File fileOrFolder;
        public ImportType type;
        private CollapsePanel panel;
        private CropImagePanel cropImagePanel;
        private Measurement measurement;
        private String lastErrorMessage;

        public ImportFile(File file, ImportType importType) {
            this.fileOrFolder = file;
            this.type = importType;
        }

        public String getGroupName() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> this.getName();
                case 2, 3 -> FileHelper.getFileName(this.fileOrFolder);
            };
        }

        public File getFromFolder() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.fileOrFolder;
                case 1 -> new File(this.fileOrFolder, "capture");
                case 2, 3 -> this.fileOrFolder.getParentFile();
            };
        }

        public File getRawFile() {
            switch (this.type.ordinal()) {
                case 0: {
                    File file = new File(this.getFromFolder(), "measurement.raw");
                    if (file.exists()) {
                        return file;
                    }
                    return new File(this.getFromFolder(), this.getName() + ".raw");
                }
                case 1: {
                    return new File(this.getFromFolder(), this.getName() + ".raw");
                }
                case 2: 
                case 3: {
                    return this.fileOrFolder;
                }
            }
            return null;
        }

        public File getImageFile() {
            switch (this.type.ordinal()) {
                case 0: {
                    return BreezeImportInfo.getImageFile(this.getFromFolder());
                }
                case 2: {
                    return BreezeImportInfo.getImageFile(this.getRawFile());
                }
                case 1: {
                    return new File(this.fileOrFolder, this.fileOrFolder.getName() + ".png");
                }
            }
            return null;
        }

        public String getName() {
            return this.fileOrFolder.getName();
        }

        public CollapsePanel getSettingsPanel() {
            if (this.panel == null) {
                this.panel = new CollapsePanel(this.getName());
            }
            return this.panel;
        }

        public CropImagePanel getCropImagePanel() {
            return this.cropImagePanel;
        }

        public boolean isLoaded() {
            return this.cropImagePanel != null;
        }

        public void setImage(BufferedImage bufferedImage) {
            this.cropImagePanel = new CropImagePanel(bufferedImage, 0, 0, 0, 0, InsetsPanel.InsetsType.Import);
        }

        public void load(BreezeProgressManager breezeProgressManager) {
            try {
                this.lastErrorMessage = null;
                this.setImage(this.getImage(breezeProgressManager));
            }
            catch (TcpManager.CommandErrorException commandErrorException) {
                this.lastErrorMessage = commandErrorException.getReply().getMessage();
            }
            catch (Exception exception) {
                this.lastErrorMessage = exception.getMessage();
            }
        }

        public String getLastErrorMessage() {
            return this.lastErrorMessage;
        }

        private BufferedImage getImage(BreezeProgressManager breezeProgressManager) throws IOException {
            File file = this.getImageFile();
            if (file != null && file.exists()) {
                return ImageIO.read(file);
            }
            File file2 = this.getRawFile();
            if (PPImportDataHelper.isImageFile(file2)) {
                return ImageIO.read(file2);
            }
            return TcpManager.getInstance().generateThumbnailFromRaw(breezeProgressManager, file2);
        }

        public void setMeasurement(Measurement measurement) {
            this.measurement = measurement;
        }

        public Measurement getMeasurement() {
            return this.measurement;
        }

        public ImportFile duplicate() {
            ImportFile importFile = new ImportFile(this.fileOrFolder, this.type);
            if (this.cropImagePanel != null) {
                importFile.setImage(this.cropImagePanel.getImage());
                this.cropImagePanel.getInsetsPanel().copyInsets(importFile.cropImagePanel.getInsetsPanel());
            }
            return importFile;
        }
    }

    public static enum ImportType {
        BreezeFolder,
        SpecimFolder,
        RawFile,
        EvinceImport;

    }

    public static class SacFileExtractUtility {
        private static final int BUFFER_SIZE = 4096;

        public SacFileExtractUtility(File file, Measurement measurement) {
            try {
                measurement.getFolder().mkdirs();
                ZipFile zipFile = new ZipFile(file);
                HashMap hashMap = new HashMap();
                SacDataSource.fillFileEntriesFromZipFile((ZipFile)zipFile, hashMap);
                this.writeFile(zipFile, new MeasurementFileLocation.Raw().file(measurement), (ZipEntry)hashMap.get("captraw"));
                this.writeFile(zipFile, new MeasurementFileLocation.Raw().header(measurement), (ZipEntry)hashMap.get("capthdr"));
                this.writeFile(zipFile, new MeasurementFileLocation.WhiteRef().file(measurement), (ZipEntry)hashMap.get("wrefraw"));
                this.writeFile(zipFile, new MeasurementFileLocation.WhiteRef().header(measurement), (ZipEntry)hashMap.get("wrefHDR"));
                this.writeFile(zipFile, new MeasurementFileLocation.DarkRef().file(measurement), (ZipEntry)hashMap.get("drefraw"));
                this.writeFile(zipFile, new MeasurementFileLocation.DarkRef().header(measurement), (ZipEntry)hashMap.get("drefHDR"));
                zipFile.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private void writeFile(ZipFile zipFile, File file, ZipEntry zipEntry) throws IOException {
            if (zipEntry != null) {
                int n;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                bufferedOutputStream.close();
            }
        }
    }
}

