/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard.importdata;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataTabbedPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.breeze.util.raw.GenericGridTiler;
import se.prediktera.breeze.util.raw.RawCropHelper;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.update.UpdateHelper;

public class PPImportDataPreviewPanel
extends PPDescriptionPanel {
    private final PPImportDataTabbedPanel tabbedPanel;
    private final BreezeTablePanel previewTable = new BreezeTablePanel();
    private final List<JComponent> buttons = new ArrayList<JComponent>();

    public PPImportDataPreviewPanel(final PPImportDataTabbedPanel pPImportDataTabbedPanel) {
        super("", false);
        this.tabbedPanel = pPImportDataTabbedPanel;
        this.previewTable.setEditable(false);
        this.previewTable.addRowHeader(50);
        ImportTableModel importTableModel = new ImportTableModel();
        final BreezeTable breezeTable = this.previewTable.getTable();
        breezeTable.setSelectionMode(2);
        breezeTable.setSelectOnFocus(false);
        breezeTable.setDefaultRenderer(PPImportDataHelper.ImportFile.class, new ImageFileCellRenderer());
        this.previewTable.initTable(importTableModel, null, false);
        breezeTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PPImportDataPreviewPanel this$0;
            {
                this.this$0 = pPImportDataPreviewPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n = breezeTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n < breezeTable.getRowCount()) {
                        breezeTable.setRowSelectionInterval(n, n);
                    }
                    BreezeFrame breezeFrame = pPImportDataTabbedPanel.getFrame();
                    BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
                    PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)this.this$0.previewTable.getSelectedVO();
                    if (importFile.getCropImagePanel() != null) {
                        breezeContextMenu.addButtonCloseClick("Crop image...", () -> this.this$0.cropSelected());
                        breezeContextMenu.addButtonCloseClick("Duplicate", () -> this.this$0.duplicateSelected());
                    }
                    breezeContextMenu.addButtonCloseClick("Remove", () -> this.this$0.deleteSelected());
                    breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                    breezeContextMenu.setPositionLater(mouseEvent);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                    this.this$0.cropSelected();
                }
            }
        });
        breezeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    PPImportDataPreviewPanel.this.deleteSelected();
                }
            }
        });
        ListSelectionModel listSelectionModel = breezeTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionEvent -> {
            for (JComponent jComponent : this.buttons) {
                boolean bl;
                boolean bl2 = breezeTable.getSelectedRowCount() == 1;
                boolean bl3 = bl = breezeTable.getSelectedRowCount() > 0;
                if (!(jComponent instanceof BreezeButton)) continue;
                BreezeButton breezeButton = (BreezeButton)jComponent;
                String string = breezeButton.getDesc();
                if (string.equals("Crop image...") || string.equals("Duplicate image") || string.equals("Split selected vertically...")) {
                    jComponent.setEnabled(bl2);
                }
                if (!string.equals("Remove")) continue;
                jComponent.setEnabled(bl);
            }
        });
        this.addOption(new BreezeLabel("Optionally, preview and edit images before they are imported"));
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 5));
        jPanel.setOpaque(false);
        this.buttons.add(EntryMainHelper.createButton("Add files", "add2", this::add));
        BreezeButton breezeButton = EntryMainHelper.createButton("Duplicate image", "duplicate", this::duplicateSelected);
        breezeButton.setEnabled(false);
        this.buttons.add(breezeButton);
        breezeButton = EntryMainHelper.createButton("Remove", "delete2", this::deleteSelected);
        breezeButton.setEnabled(false);
        this.buttons.add(breezeButton);
        this.buttons.add(new BreezeSeparator.Vertical());
        this.buttons.add(EntryMainHelper.createButton("loadAll", "Load all", "selectall", () -> BreezeProgressDialog.startProgressWithCancel(pPImportDataTabbedPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ PPImportDataPreviewPanel this$0;
            {
                this.this$0 = pPImportDataPreviewPanel;
            }

            @Override
            public void runAction() throws Exception {
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                List<PPImportDataHelper.ImportFile> list = pPImportDataTabbedPanel.getSelectedFiles();
                int n = breezeProgressManager.setGroupMaximumAndReset(list.size());
                for (PPImportDataHelper.ImportFile importFile : list) {
                    if (!importFile.isLoaded()) {
                        importFile.load(breezeProgressManager);
                    }
                    breezeProgressManager.incStepGroup(n);
                }
                this.this$0.previewTable.updateTable(list.isEmpty() ? null : list.getFirst(), false);
            }
        }, "Loading preview images")));
        this.buttons.add(EntryMainHelper.createButton("Table cell height", "material/height", () -> this.previewTable.showCellHeightDialog(pPImportDataTabbedPanel.getMainPanel(), false)));
        this.buttons.add(new BreezeSeparator.Vertical());
        breezeButton = EntryMainHelper.createButton("Crop image...", "crop", this::cropSelected);
        breezeButton.setEnabled(false);
        this.buttons.add(breezeButton);
        breezeButton = EntryMainHelper.createButton("Split selected vertically...", "vertical_split", () -> this.splitSelected(pPImportDataTabbedPanel));
        breezeButton.setEnabled(false);
        this.buttons.add(breezeButton);
        breezeButton = EntryMainHelper.createButton("Help", "help", () -> BrowserLauncher.open((String)"https://help.prediktera.com/breeze/import-data-guide"));
        this.buttons.add(breezeButton);
        this.previewTable.setRowHeight(180);
        this.addOption(jPanel);
        this.addOptionFillBoth((JComponent)((Object)this.previewTable));
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        for (JComponent jComponent : this.buttons) {
            breezeMainPanel.addRightButton(jComponent);
        }
    }

    private void cropSelected() {
        PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)this.previewTable.getSelectedVO();
        if (importFile != null) {
            InsetsPanel insetsPanel = importFile.getCropImagePanel().getInsetsPanel();
            int[] nArray = insetsPanel.getInsetsArray();
            BreezeOptionDialog.showDialog(this.tabbedPanel.getFrame(), this.tabbedPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Crop Image", "", (AbstractBreezeCustomPanel)new CropImagePanel(importFile.getCropImagePanel().getImage(), nArray[0], nArray[2], nArray[1], nArray[3], InsetsPanel.InsetsType.Import, insetsPanel.isGridEnabled(), insetsPanel.getGridRows(), insetsPanel.getGridColumns()), null, breezeActionEvent -> {
                CropImagePanel cropImagePanel = (CropImagePanel)breezeActionEvent.getBreezeCustomPanel();
                cropImagePanel.getInsetsPanel().copyInsets(insetsPanel);
                this.previewTable.updateTable();
            });
        }
    }

    private void duplicateSelected() {
        PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)this.previewTable.getSelectedVO();
        if (importFile != null) {
            List<PPImportDataHelper.ImportFile> list = this.tabbedPanel.getSelectedFiles();
            int n = list.indexOf(importFile);
            list.add(n, importFile.duplicate());
            this.previewTable.updateTable();
        }
    }

    private void splitSelected(final PPImportDataTabbedPanel pPImportDataTabbedPanel) {
        BreezeMainPanel breezeMainPanel = pPImportDataTabbedPanel.getMainPanel();
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Split image vertically", "Number of split pieces", "2", new BreezeActionListener(){
            final /* synthetic */ PPImportDataPreviewPanel this$0;
            {
                this.this$0 = pPImportDataPreviewPanel;
            }

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                int n = Integer.parseInt(breezeActionEvent.result().toString());
                PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)this.this$0.previewTable.getSelectedVO();
                if (importFile != null) {
                    List<PPImportDataHelper.ImportFile> list = pPImportDataTabbedPanel.getSelectedFiles();
                    int n2 = list.indexOf(importFile);
                    this.setCropSplit(importFile, n - 1, n);
                    for (int i = 1; i < n; ++i) {
                        PPImportDataHelper.ImportFile importFile2 = importFile.duplicate();
                        this.setCropSplit(importFile2, n - i - 1, n);
                        list.add(n2, importFile2);
                    }
                    this.this$0.previewTable.updateTable();
                }
            }

            private void setCropSplit(PPImportDataHelper.ImportFile importFile, int n, int n2) {
                CropImagePanel cropImagePanel = importFile.getCropImagePanel();
                int n3 = cropImagePanel.getImage().getHeight();
                int n4 = n3 / n2;
                int n5 = n4 * n;
                if (n == n2 - 1) {
                    n4 = n3 - n5;
                }
                InsetsPanel insetsPanel = cropImagePanel.getInsetsPanel();
                int[] nArray = insetsPanel.getInsetsArray();
                nArray[0] = n5;
                nArray[1] = n3 - (n5 + n4);
            }
        });
    }

    private void add() {
        BreezeMainPanel breezeMainPanel = this.tabbedPanel.getMainPanel();
        FileChooserPanel fileChooserPanel = new FileChooserPanel(breezeMainPanel, null, false);
        fileChooserPanel.addDataFileFilters(FileChooserPanel.FilterType.IMAGE);
        fileChooserPanel.addAllSupported();
        fileChooserPanel.setMultiSelectionEnabled(true);
        fileChooserPanel.trySetCurrentDirectory(this.tabbedPanel.getCurrentDirectory());
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Add files", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(fileChooserPanel, null, 0.85){

            @Override
            public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
                breezeButton2.setText("Add");
            }
        }, null, breezeActionEvent -> {
            List<PPImportDataHelper.ImportFile> list = this.tabbedPanel.getSelectedFiles();
            list.addAll(PPImportDataHelper.getImportFiles(fileChooserPanel.getSelectedFiles()));
            this.previewTable.updateTable();
        });
    }

    private void deleteSelected() {
        for (Object e : this.previewTable.getSelectedValues()) {
            List<PPImportDataHelper.ImportFile> list = this.tabbedPanel.getSelectedFiles();
            list.remove(e);
            this.previewTable.updateTable();
        }
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.previewTable.setTableList(this.tabbedPanel.getSelectedFiles(), null);
    }

    public void crop(BreezeProgressManager breezeProgressManager, List<PPImportDataHelper.ImportFile> list, List<Measurement> list2) {
        ArrayList<PPImportDataHelper.ImportFile> arrayList = new ArrayList<PPImportDataHelper.ImportFile>();
        for (PPImportDataHelper.ImportFile object : list) {
            if (!object.isLoaded() || !object.getCropImagePanel().shouldCrop()) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            breezeProgressManager.setInfoText("Cropping measurements");
            int n = breezeProgressManager.setGroupMaximumAndReset(arrayList.size());
            for (PPImportDataHelper.ImportFile importFile : arrayList) {
                Measurement measurement = importFile.getMeasurement();
                Group group = measurement.getParent();
                CropImagePanel cropImagePanel = importFile.getCropImagePanel();
                if (cropImagePanel.hasGrid()) {
                    int n8 = cropImagePanel.getGridColumns();
                    int n9 = cropImagePanel.getGridRows();
                    GenericGridTiler.split(cropImagePanel.left(), cropImagePanel.top(), cropImagePanel.rightPos(), cropImagePanel.bottomPos(), n8, n9, (n2, n3, n4, n5, n6, n7) -> {
                        String string = String.format("%s_r%02d_c%02d", measurement.getName(), n6 + 1, n7 + 1);
                        Measurement measurement2 = RawCropHelper.createMeasurementUniqueName(measurement, group.getChildList(), string);
                        RawCropHelper.cropImage(breezeProgressManager, n2, n3, n4, n5, measurement, measurement2);
                        if (!measurement.equals(measurement2)) {
                            list2.add(measurement2);
                        }
                        breezeProgressManager.incStepGroup(n);
                    });
                    list2.remove(measurement);
                    group.removeChild(measurement);
                    measurement.delete(false);
                } else {
                    RawCropHelper.cropImage(breezeProgressManager, cropImagePanel.left(), cropImagePanel.top(), cropImagePanel.rightPos(), cropImagePanel.bottomPos(), measurement, measurement);
                }
                breezeProgressManager.incStepGroup(n);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        EntryMainPanel entryMainPanel = new EntryMainPanel(){

            @Override
            public BreezeFrame getFrame() {
                return new BreezeFrame(UpdateHelper.Product.Unknown);
            }
        };
        final File file = new File("C:\\Prediktera\\evince\\BreezeIntegrationTest\\src\\main\\resources\\realtime\\play\\spectral\\spectral");
        PPImportDataPreviewPanel pPImportDataPreviewPanel = new PPImportDataPreviewPanel(new PPImportDataTabbedPanel(entryMainPanel, entryMainPanel){

            @Override
            public List<PPImportDataHelper.ImportFile> getSelectedFiles() {
                ArrayList<PPImportDataHelper.ImportFile> arrayList = new ArrayList<PPImportDataHelper.ImportFile>();
                for (int i = 1; i <= 7; ++i) {
                    File file2 = new File(file, "Measurement" + i);
                    PPImportDataHelper.ImportFile importFile = new PPImportDataHelper.ImportFile(file2, PPImportDataHelper.ImportType.BreezeFolder);
                    try {
                        importFile.setImage(ImageIO.read(new File(file2, "measurement_raw.png")));
                        importFile.getCropImagePanel().getInsetsPanel().setInsets(2, 2, 2, 2);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    arrayList.add(importFile);
                }
                return arrayList;
            }
        });
        pPImportDataPreviewPanel.showEntry(null, null);
        jFrame.getContentPane().add((Component)((Object)pPImportDataPreviewPanel));
        jFrame.setSize(1024, 800);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public class ImportTableModel
    extends DefaultBreezeTableImpl {
        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)object;
            vector.add(importFile.getName());
            vector.add(importFile);
            File file = importFile.getRawFile();
            if (file != null) {
                CropImagePanel cropImagePanel = importFile.getCropImagePanel();
                if (cropImagePanel != null) {
                    double d = cropImagePanel.getInsetsPanel().getPercentCropped();
                    vector.add(FileUtils.byteCountToDisplaySize((long)((long)((double)file.length() * d))));
                } else {
                    vector.add(FileUtils.byteCountToDisplaySize((long)file.length()));
                }
            } else {
                vector.add("N/A");
            }
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            return Arrays.asList("Name", "", "Size");
        }

        @Override
        public void putVOIntoFields(Object object) {
            final PPImportDataHelper.ImportFile importFile = (PPImportDataHelper.ImportFile)object;
            if (!importFile.isLoaded()) {
                BreezeProgressDialog.startProgressWithCancel(PPImportDataPreviewPanel.this.tabbedPanel.getFrame(), new ProgressAction(this){
                    final /* synthetic */ ImportTableModel this$1;
                    {
                        this.this$1 = importTableModel;
                    }

                    @Override
                    public void runAction() throws Exception {
                        importFile.load(this.getProgressManager());
                    }

                    @Override
                    public void actionComplete() {
                        this.this$1.PPImportDataPreviewPanel.this.previewTable.repaint();
                    }
                }, "Loading preview image");
            }
        }

        @Override
        public int[] getColumnWidth() {
            return new int[]{25, 60, 15};
        }
    }

    public class ImageFileCellRenderer
    extends BreezeTableCellRenderer {
        private PPImportDataHelper.ImportFile importFile;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.importFile = (PPImportDataHelper.ImportFile)object;
            super.getTableCellRendererComponent(jTable, "", bl, bl2, n, n2);
            this.setOpaque(true);
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            int n = this.getWidth();
            int n2 = this.getHeight();
            CropImagePanel cropImagePanel = this.importFile.getCropImagePanel();
            if (cropImagePanel != null) {
                InsetsPanel insetsPanel = cropImagePanel.getInsetsPanel();
                final BufferedImage bufferedImage = cropImagePanel.getImage();
                InsetsPanel insetsPanel2 = new InsetsPanel(this, bufferedImage.getWidth(), bufferedImage.getHeight(), InsetsPanel.InsetsType.Import){
                    final /* synthetic */ ImageFileCellRenderer this$1;
                    {
                        this.this$1 = imageFileCellRenderer;
                        super(n, n2, insetsType);
                    }

                    @Override
                    public void drawContent(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
                        graphics2D.drawImage(bufferedImage, n, n2, n3, n4, null);
                    }
                };
                insetsPanel2.setInsets(insetsPanel.getInsetsArray());
                insetsPanel2.setGrid(insetsPanel.isGridEnabled());
                insetsPanel2.setGrid(insetsPanel.getGridRows(), insetsPanel.getGridColumns());
                insetsPanel2.setHandleSize(0);
                int n3 = bufferedImage.getWidth(null);
                int n4 = bufferedImage.getHeight(null);
                int n5 = Math.max(1, n);
                int n6 = Math.max(1, n2);
                float f = (float)n5 / (float)n3;
                float f2 = (float)n6 / (float)n4;
                float f3 = Math.min(f, f2);
                int n7 = Math.round((float)n3 * f3);
                int n8 = Math.round((float)n4 * f3);
                int n9 = (n - n7) / 2;
                int n10 = (n2 - n8) / 2;
                insetsPanel2.setSize(n7, n8);
                insetsPanel2.setBounds(0, 0, n7, n8);
                insetsPanel2.recomputeBaseZooms();
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(n9, n10);
                insetsPanel2.drawContent(graphics2D);
                graphics2D.setTransform(affineTransform);
            } else {
                String string = this.importFile.getLastErrorMessage();
                String string2 = string != null ? string : "Click here to load preview image";
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n11 = fontMetrics.stringWidth(string2);
                int n12 = fontMetrics.getHeight();
                int n13 = (n - n11) / 2;
                int n14 = (n2 - n12) / 2 + fontMetrics.getAscent();
                graphics2D.setColor(string != null ? Color.RED : BreezeTheme.getInstance().getLabelForegroundDifuse());
                graphics2D.drawString(string2, n13, n14);
            }
        }
    }
}

