/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard.importdata;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ObjectWithChildren;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckedTree;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTabbedPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;

public class PPImportDataTabbedPanel
extends AbstractViewPanel {
    private static File cachedPath;
    private final FileChooserPanel fileSelectionPanel;
    private final BreezeTabbedPanel tabbedPanel;
    private List<PPImportDataHelper.ImportFile> files;
    private TreeImportPanel treeImportPanel;

    public PPImportDataTabbedPanel(EntryMainPanel entryMainPanel, BreezeMainPanel breezeMainPanel) {
        super(entryMainPanel);
        this.setLayout(new GridBagLayout());
        this.fileSelectionPanel = new FileChooserPanel(breezeMainPanel, "Select files to import. Use Shift or Ctrl + click to multi select. Click Next to continue.", false);
        this.fileSelectionPanel.addDataFileFilters(FileChooserPanel.FilterType.IMAGE);
        this.fileSelectionPanel.addAllSupported();
        this.fileSelectionPanel.setMultiSelectionEnabled(true);
        this.fileSelectionPanel.setCurrentDirectory(this.getCachedOrDefaultImportDirectory());
        this.tabbedPanel = new BreezeTabbedPanel();
        this.tabbedPanel.addTab("Image files", (Component)((Object)this.fileSelectionPanel));
        if (BreezeFrame.isStudyImportFeature()) {
            this.treeImportPanel = new TreeImportPanel(entryMainPanel);
            this.tabbedPanel.addTab("Measurements (Beta)", this.treeImportPanel);
        }
        this.tabbedPanel.setTabPlacement(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.tabbedPanel, gridBagConstraints);
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        if (this.tabbedPanel.getSelectedIndex() == 0) {
            return this.fileSelectionPanel.checkValidContent(wizardControlCallback);
        }
        return this.treeImportPanel.checkValidContent();
    }

    private File getCachedOrDefaultImportDirectory() {
        if (cachedPath == null || !cachedPath.exists()) {
            cachedPath = WorkspaceManager.getInstance().getWorkspace().getPath().toFile();
        }
        return cachedPath;
    }

    public List<PPImportDataHelper.ImportFile> getSelectedFiles() {
        if (this.files == null) {
            if (this.tabbedPanel.getSelectedIndex() == 0) {
                cachedPath = this.fileSelectionPanel.getCurrentDirectory();
                this.files = PPImportDataHelper.getImportFiles(this.fileSelectionPanel.getSelectedFiles());
            } else {
                this.files = this.treeImportPanel.getSelectedFiles();
            }
        }
        return this.files;
    }

    public File getCurrentDirectory() {
        if (this.tabbedPanel.getSelectedIndex() == 0) {
            return this.fileSelectionPanel.getCurrentDirectory();
        }
        return this.treeImportPanel.getCurrentDirectory();
    }

    public File getSelectedFile() {
        if (this.tabbedPanel.getSelectedIndex() == 0) {
            return this.fileSelectionPanel.getSelectedFile();
        }
        return this.treeImportPanel.getSelectedFile();
    }

    @Override
    public String getType() {
        return "TabbedPane";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.files = null;
    }

    @Generated
    public FileChooserPanel getFileSelectionPanel() {
        return this.fileSelectionPanel;
    }

    private static class TreeImportPanel
    extends JPanel {
        private final EntryMainPanel mainPanel;
        private final BreezeCheckedTree tree;

        public TreeImportPanel(EntryMainPanel entryMainPanel) {
            this.mainPanel = entryMainPanel;
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setLayout(new GridBagLayout());
            BreezeLabel breezeLabel = new BreezeLabel("Select measurement(s) to import and press Next.");
            breezeLabel.setFont(new Font("Tahoma", 0, 18));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 20, 0, 0);
            this.add((Component)breezeLabel, gridBagConstraints);
            this.tree = new BreezeCheckedTree();
            this.tree.setBackground(breezeTheme.getPanelBackground());
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            List<BasicWorkflow> list = this.getWorkflows(entryMainPanel);
            for (BasicWorkflow basicWorkflow : list) {
                this.addRecursive(defaultMutableTreeNode, (Workflow)basicWorkflow);
            }
            this.tree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
            this.tree.expandAll();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 20, 0, 0);
            this.add((Component)((Object)this.tree), gridBagConstraints);
        }

        private List<BasicWorkflow> getWorkflows(EntryMainPanel entryMainPanel) {
            Workflow workflow = ((EntryMainSwitchPanel)entryMainPanel).getStudyContext();
            BreezeType breezeType = entryMainPanel.getPageType();
            BreezeMasterCache breezeMasterCache = BreezeMasterCache.getInstance();
            if (breezeType.equals((Object)BreezeType.Project)) {
                return breezeMasterCache.getWorkflowList().filter(new BreezeFilter.AnalyseStudy(workflow));
            }
            return Collections.singletonList(workflow);
        }

        public WizardStep.LeaveResult checkValidContent() {
            List<Measurement> list = this.getSelectedMeasurements();
            if (!list.isEmpty()) {
                return WizardStep.LeaveResult.Ok;
            }
            BreezeOptionDialog.showDialog(this.mainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No measurements(s) selected", "At least one measurement must be selected");
            return WizardStep.LeaveResult.Failed;
        }

        private void addRecursive(DefaultMutableTreeNode defaultMutableTreeNode, ObjectWithChildren objectWithChildren) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(objectWithChildren);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!(objectWithChildren instanceof Measurement)) {
                for (Object c : objectWithChildren.getChildList()) {
                    this.addRecursive(defaultMutableTreeNode2, (ObjectWithChildren)c);
                }
            }
        }

        public File getSelectedFile() {
            List<Measurement> list = this.getSelectedMeasurements();
            if (!list.isEmpty()) {
                return list.getFirst().rawFile().file();
            }
            return null;
        }

        public File getCurrentDirectory() {
            List<Measurement> list = this.getSelectedMeasurements();
            if (!list.isEmpty()) {
                return list.getFirst().getFolder();
            }
            return null;
        }

        public List<Measurement> getSelectedMeasurements() {
            ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
            for (TreePath treePath : this.tree.getCheckedPaths()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof Measurement)) continue;
                arrayList.add((Measurement)object);
            }
            return arrayList;
        }

        public List<PPImportDataHelper.ImportFile> getSelectedFiles() {
            ArrayList<PPImportDataHelper.ImportFile> arrayList = new ArrayList<PPImportDataHelper.ImportFile>();
            for (Measurement measurement : this.getSelectedMeasurements()) {
                arrayList.add(new PPImportDataHelper.ImportFile(measurement.getFolder(), PPImportDataHelper.ImportType.BreezeFolder));
            }
            return arrayList;
        }
    }
}

