/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import se.prediktera.breeze.common.entry.ObjectWithChildren;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthInterval;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthIntervalSegmentation;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;

public class CsvEndMembersReportCreator {
    private static Date fixedDate = null;

    public static void useFixedDateForUnitTest(Date date) {
        fixedDate = date;
    }

    private static Date getDateNow() {
        if (fixedDate != null) {
            return fixedDate;
        }
        return new Date();
    }

    public static void createEndMembers(File file, List<Measurement> list, String string, List<String> list2, EndMemberType endMemberType, Object object, boolean bl, Object object2) throws IOException {
        SampleSegmentationColumn sampleSegmentationColumn = CsvEndMembersReportCreator.getSamples(list2, list);
        if (bl) {
            sampleSegmentationColumn = DepthIntervalSegmentation.mergeSamplesByIntervals(sampleSegmentationColumn);
        }
        BandNames bandNames = CsvEndMembersReportCreator.getBandNames(sampleSegmentationColumn);
        HashSet<String> hashSet = new HashSet<String>();
        if (endMemberType.equals((Object)EndMemberType.AllVertical)) {
            CsvEndMembersReportCreator.writeCsvEndMembersSingleFile(file, sampleSegmentationColumn, bandNames, list2, object, hashSet, object2);
        } else {
            for (Sample sample : sampleSegmentationColumn) {
                CsvEndMembersReportCreator.writeCsvEndMembers(file, string, sample, bandNames, endMemberType.equals((Object)EndMemberType.Vertical), object, hashSet, object2);
            }
        }
    }

    private static void writeCsvEndMembers(File file, String string, Sample sample, BandNames bandNames, boolean bl, Object object, HashSet<String> hashSet, Object object2) throws IOException {
        String string2 = CsvEndMembersReportCreator.getEndMemberName(sample, hashSet, object, object2);
        String string3 = string2.replaceAll(string, "_");
        float[] fArray = sample.getPath().getAverageProfiles()[0];
        File file2 = new File(file, string2 + ".csv");
        try (PrintWriter printWriter = new PrintWriter(file2, StandardCharsets.ISO_8859_1);){
            if (bl) {
                printWriter.print("Wavelength");
                printWriter.print(string);
                printWriter.println(string3);
                for (int i = 0; i < bandNames.size(); ++i) {
                    printWriter.print(bandNames.get(i));
                    printWriter.print(string);
                    printWriter.println(fArray[i]);
                }
            } else {
                printWriter.print("Wavelength");
                printWriter.print(string);
                Stream.of(String.join((CharSequence)string, bandNames)).forEach(printWriter::print);
                printWriter.println();
                printWriter.print(string3);
                printWriter.print(string);
                StringBuilder stringBuilder = new StringBuilder();
                for (float f : fArray) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(f);
                }
                printWriter.print(stringBuilder);
            }
        }
    }

    private static String getEndMemberName(Sample sample, HashSet<String> hashSet, Object object, Object object2) {
        Object object3;
        ObjectWithChildren<BasicSample> objectWithChildren;
        Object object4;
        Object object5;
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof Identifier) {
            object5 = (Identifier)object;
            stringBuilder.append(((Identifier)object5).getTextValue(sample));
        } else if (object instanceof CategoryFactor) {
            object4 = (CategoryFactor)object;
            stringBuilder.append(((Factor)object4).getStringValue(sample));
        } else {
            objectWithChildren = sample.measurement();
            if (objectWithChildren != null) {
                stringBuilder.append(((Measurement)objectWithChildren).getName());
                object3 = sample.getSettingsName();
                if (((String)object3).length() > 0) {
                    stringBuilder.append("_").append((String)object3);
                }
            }
        }
        if (object2 instanceof SegmentationNode) {
            object5 = (SegmentationNode)object2;
            if (((SegmentationNode)object5).getFunction() instanceof DepthIntervalSegmentation) {
                object4 = new DepthInterval(sample);
                stringBuilder.append("_");
                stringBuilder.append(((DepthInterval)object4).toString());
            }
            object4 = ((SegmentationNode)object5).getDescriptorNodes(false).iterator();
            while (object4.hasNext()) {
                objectWithChildren = (DescriptorTreeNode)object4.next();
                AbstractBreezeFunction abstractBreezeFunction = ((DescriptorTreeNode)objectWithChildren).getFunction();
                if (!(abstractBreezeFunction instanceof SpatialDescriptor)) continue;
                object3 = (SpatialDescriptor)abstractBreezeFunction;
                int n = ((DescriptorTreeNode)objectWithChildren).getIndex();
                if (n != 9 && n != 10) continue;
                stringBuilder.append("_");
                stringBuilder.append(((AbstractBreezeFunction)object3).getOutputName(n));
                stringBuilder.append("_");
                stringBuilder.append(sample.getDescriptorValue((DescriptorTreeNode)objectWithChildren));
            }
        }
        if (hashSet.contains(object5 = stringBuilder.toString())) {
            int n = 1;
            while (hashSet.contains(object4 = (String)object5 + "_" + n++)) {
            }
            object5 = object4;
        }
        hashSet.add((String)object5);
        return object5;
    }

    private static void writeCsvEndMembersSingleFile(File file, List<Sample> list, BandNames bandNames, List<String> list2, Object object, HashSet<String> hashSet, Object object2) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(file, StandardCharsets.ISO_8859_1);){
            printWriter.println("ENVI ASCII Plot File [" + String.valueOf(CsvEndMembersReportCreator.getDateNow()) + "]");
            printWriter.println("Column 1: Wavelength");
            int n = 2;
            for (Sample object3 : list) {
                printWriter.println("Column " + n++ + ": " + CsvEndMembersReportCreator.getEndMemberName(object3, hashSet, object, object2));
            }
            for (int i = 0; i < bandNames.size(); ++i) {
                printWriter.print("   ");
                printWriter.print(bandNames.get(i));
                for (Sample sample : list) {
                    printWriter.print("   ");
                    float[] fArray = sample.getSamplePath().getAverageProfile();
                    if (fArray != null && i < fArray.length) {
                        printWriter.print(fArray[i]);
                        continue;
                    }
                    printWriter.print(0);
                }
                printWriter.println();
            }
        }
    }

    private static BandNames getBandNames(List<Sample> list) {
        for (Sample sample : list) {
            RawFile rawFile = sample.measurement().rawFile();
            if (rawFile == null) continue;
            return rawFile.header().bandNames();
        }
        return null;
    }

    private static SampleSegmentationColumn getSamples(List<String> list, List<Measurement> list2) {
        SampleSegmentationColumn sampleSegmentationColumn = new SampleSegmentationColumn();
        for (Measurement measurement : list2) {
            sampleSegmentationColumn.addAll(measurement.getSamples(list));
        }
        return sampleSegmentationColumn;
    }

    public static enum EndMemberType {
        Horizontal,
        Vertical,
        AllVertical;

    }
}

