/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthIntervalSegmentation;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleRow;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;

public class CsvReportCreator {
    final File outputFileName;
    final List<Measurement> measurements;
    final String delimiter;
    final String decimalFormat;
    final boolean includeWavelength;
    final ArrayList<SegmentationIdentifier> segmentationIdentifiers;
    final boolean mergeDepthIntervals;
    final boolean includeSubsampleNames;

    public CsvReportCreator(File file, List<Measurement> list, String string, String string2, boolean bl, ArrayList<SegmentationIdentifier> arrayList, boolean bl2, boolean bl3) {
        this.outputFileName = file;
        this.measurements = list;
        this.delimiter = string;
        this.decimalFormat = string2;
        this.includeWavelength = bl;
        this.segmentationIdentifiers = arrayList;
        this.mergeDepthIntervals = bl2;
        this.includeSubsampleNames = bl3;
        HashSet<SegmentationIdentifier> hashSet = new HashSet<SegmentationIdentifier>(arrayList);
        ArrayList<SegmentationIdentifier> arrayList2 = new ArrayList<SegmentationIdentifier>(hashSet);
        arrayList2.sort((segmentationIdentifier, segmentationIdentifier2) -> segmentationIdentifier.Level - segmentationIdentifier2.Level);
        if (arrayList.size() != arrayList2.size()) {
            throw new IllegalArgumentException("Detected duplicate data sets to join");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get((int)i).Level.equals(arrayList2.get((int)i).Level)) continue;
            throw new IllegalArgumentException("Data sets to join must be in descending order");
        }
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (SegmentationIdentifier segmentationIdentifier3 : arrayList) {
            hashSet2.add(segmentationIdentifier3.Level);
        }
        if (arrayList.size() > 1 && hashSet2.size() == 1) {
            throw new IllegalArgumentException("Cannot join sibling data sets without selecting a parent");
        }
    }

    public void write() {
        Measurement measurement = this.getFirstMeasurement();
        this.outputFileName.getParentFile().mkdirs();
        Workflow workflow = measurement.getWorkflow();
        HashMap<Integer, ArrayList<Measurement>> hashMap = new HashMap<Integer, ArrayList<Measurement>>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Measurement object2 : this.measurements) {
            int n = object2.getParent().getIndexWithinWorkflow();
            if (hashMap.containsKey(n)) {
                ((ArrayList)hashMap.get(n)).add(object2);
                continue;
            }
            hashMap.put(n, new ArrayList<Measurement>(List.of(object2)));
            arrayList.add(n);
        }
        arrayList.sort(Integer::compare);
        try (PrintWriter printWriter = new PrintWriter(this.outputFileName, StandardCharsets.ISO_8859_1);){
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("Time");
            MeasurementTableModel.collectCsvTableHeader(workflow, MeasurementTableModel.TableSource.Export, this.segmentationIdentifiers, this.includeSubsampleNames).stream().forEach(object -> arrayList2.add(ReportUtils.serializeHeader(object)));
            if (this.includeWavelength) {
                for (String string : measurement.rawFile().header().bandNames()) {
                    arrayList2.add(ReportUtils.formatNumber(string, this.decimalFormat));
                }
            }
            this.printCsvLine(printWriter, arrayList2);
            for (Integer n : arrayList) {
                ArrayList arrayList3 = (ArrayList)hashMap.get(n);
                ArrayList<SampleSegmentationColumn> arrayList4 = new ArrayList<SampleSegmentationColumn>();
                for (SegmentationIdentifier segmentationIdentifier : this.segmentationIdentifiers) {
                    arrayList4.add(Sample.getSamples(segmentationIdentifier, arrayList3));
                }
                ArrayList<SampleRow> arrayList5 = Sample.joinSamples(arrayList4);
                if (this.mergeDepthIntervals) {
                    arrayList5 = DepthIntervalSegmentation.mergeSampleRowsByIntervals(arrayList5);
                }
                for (SampleRow sampleRow : arrayList5) {
                    float[][] fArray;
                    ArrayList<String> arrayList6 = new ArrayList<String>();
                    arrayList6.add(((Sample)sampleRow.getFirst()).measurement().getEntryData().getSimpleCreatedDate());
                    arrayList6.addAll(MeasurementTableModel.createTableRowVector(sampleRow, MeasurementTableModel.TableSource.Export, this.segmentationIdentifiers, this.includeSubsampleNames, (sample, object) -> this.escape(ReportUtils.getValue(sample, object, this.decimalFormat))));
                    if (this.includeWavelength && (fArray = ((Sample)sampleRow.getFirst()).getPath().getAverageProfiles()) != null) {
                        for (int i = 0; i < fArray[0].length; ++i) {
                            arrayList6.add(ReportUtils.formatNumber(String.valueOf(fArray[0][i]), this.decimalFormat));
                        }
                    }
                    this.printCsvLine(printWriter, arrayList6);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void printCsvLine(PrintWriter printWriter, List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                printWriter.print(this.delimiter);
            }
            printWriter.print(string);
        }
        printWriter.println();
    }

    private String escape(String string) {
        if (string.contains(this.delimiter)) {
            return String.format("\"%s\"", string);
        }
        return string;
    }

    private Measurement getFirstMeasurement() {
        if (this.includeWavelength) {
            Measurement measurement = Measurement.getFirstMeasurementWithData(this.measurements);
            if (measurement == null) {
                throw new RuntimeException("No measurement with data");
            }
            return measurement;
        }
        if (this.measurements.isEmpty()) {
            throw new RuntimeException("No measurement");
        }
        return this.measurements.get(0);
    }
}

