/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthIntervalSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.report.ReportFieldList;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class FreemarkerReportCreator {
    private static final Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);

    public static void createReport(BreezeProgressManager breezeProgressManager, File file, List<Measurement> list, SegmentationIdentifier segmentationIdentifier, boolean bl, boolean bl2) {
        if (list.isEmpty()) {
            throw new RuntimeException("No measurement with data");
        }
        Measurement measurement2 = list.getFirst();
        String string = list.stream().map(measurement -> measurement.getParent().getName()).distinct().collect(Collectors.joining(", "));
        SampleSegmentationColumn sampleSegmentationColumn = Sample.getSamples(segmentationIdentifier, list);
        if (bl) {
            sampleSegmentationColumn = DepthIntervalSegmentation.mergeSamplesByIntervals(sampleSegmentationColumn);
        }
        new GroupHtmlReport(breezeProgressManager, measurement2.getWorkflow(), measurement2.getParent(), string, sampleSegmentationColumn, bl2).writeFile(file);
    }

    public static void createReport(BreezeProgressManager breezeProgressManager, File file, Analyse analyse) {
        new AnalyseHtmlReport(breezeProgressManager, analyse).writeFile(file);
    }

    static {
        configuration.setDefaultEncoding("UTF-8");
        configuration.setClassForTemplateLoading(FreemarkerReportCreator.class, "/report");
    }

    private static class GroupHtmlReport
    extends HtmlReport {
        public GroupHtmlReport(BreezeProgress breezeProgress, Workflow workflow, Group group, String string, List<Sample> list, boolean bl) {
            super(workflow.getName(), string);
            ReportFieldList reportFieldList = new ReportFieldList(workflow, group);
            this.context.put("headers", reportFieldList.headerList());
            PlotContinuousColor plotContinuousColor = workflow.getColorScale().create();
            String[] stringArray = new String[plotContinuousColor.getNrColors()];
            for (int i = 0; i < plotContinuousColor.getNrColors(); ++i) {
                stringArray[i] = "#" + Integer.toHexString(plotContinuousColor.getColor(i).getRGB()).substring(2);
            }
            this.context.put("legendColorScale", stringArray);
            this.context.put("rows", reportFieldList.rowsFor(breezeProgress, list, reportFieldList));
            this.context.put("disableJavaScript", bl);
            CategoryList categoryList = workflow.getCategoryFactors();
            if (categoryList != null && !categoryList.isEmpty()) {
                ArrayList<CategoryHolder> arrayList = new ArrayList<CategoryHolder>();
                for (CategoryFactor categoryFactor : categoryList) {
                    CategoryHolder categoryHolder = new CategoryHolder(categoryFactor.getName(), categoryFactor.getClasses().stream().map(catClass -> Pair.of((Object)catClass.getName(), (Object)catClass.getColorString())).toList());
                    arrayList.add(categoryHolder);
                }
                this.context.put("availableCategories", arrayList);
            }
        }
    }

    private static class AnalyseHtmlReport
    extends HtmlReport {
        public AnalyseHtmlReport(BreezeProgressManager breezeProgressManager, Analyse analyse) {
            super("Workflow", analyse.getName());
            ReportFieldList reportFieldList = new ReportFieldList(breezeProgressManager, analyse);
            this.context.put("headers", reportFieldList.headerList());
            this.context.put("rows", reportFieldList.rowsFor(breezeProgressManager, analyse));
        }
    }

    public record CategoryHolder(String Name, List<Pair<String, String>> Categories) {
    }

    public static class TableCell {
        public float min;
        public float max;
        public float minWl;
        public float middleWl;
        public float maxWl;
        public String color;
        public boolean isMissingValue;
        public String value;
        public String type;
        public String sortValue;

        public boolean hasXLabels() {
            return !Float.isNaN(this.minWl) && !Float.isNaN(this.middleWl) && !Float.isNaN(this.maxWl) && this.minWl != this.middleWl && this.middleWl != this.maxWl;
        }

        public TableCell(String string, String string2, String string3) {
            this.value = string;
            this.type = string2;
            this.sortValue = string3;
        }

        @Generated
        public float getMin() {
            return this.min;
        }

        @Generated
        public float getMax() {
            return this.max;
        }

        @Generated
        public float getMinWl() {
            return this.minWl;
        }

        @Generated
        public float getMiddleWl() {
            return this.middleWl;
        }

        @Generated
        public float getMaxWl() {
            return this.maxWl;
        }

        @Generated
        public String getColor() {
            return this.color;
        }

        @Generated
        public boolean isMissingValue() {
            return this.isMissingValue;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getSortValue() {
            return this.sortValue;
        }

        @Generated
        public void setMin(float f) {
            this.min = f;
        }

        @Generated
        public void setMax(float f) {
            this.max = f;
        }

        @Generated
        public void setMinWl(float f) {
            this.minWl = f;
        }

        @Generated
        public void setMiddleWl(float f) {
            this.middleWl = f;
        }

        @Generated
        public void setMaxWl(float f) {
            this.maxWl = f;
        }

        @Generated
        public void setColor(String string) {
            this.color = string;
        }

        @Generated
        public void setMissingValue(boolean bl) {
            this.isMissingValue = bl;
        }
    }

    public static class TableHeader {
        private final String name;
        private final String type;
        private final boolean sortable;
        private final int colspan;

        @Generated
        private static int $default$colspan() {
            return 1;
        }

        @Generated
        TableHeader(String string, String string2, boolean bl, int n) {
            this.name = string;
            this.type = string2;
            this.sortable = bl;
            this.colspan = n;
        }

        @Generated
        public static TableHeaderBuilder builder() {
            return new TableHeaderBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public boolean isSortable() {
            return this.sortable;
        }

        @Generated
        public int getColspan() {
            return this.colspan;
        }

        @Generated
        public static class TableHeaderBuilder {
            @Generated
            private String name;
            @Generated
            private String type;
            @Generated
            private boolean sortable;
            @Generated
            private boolean colspan$set;
            @Generated
            private int colspan$value;

            @Generated
            TableHeaderBuilder() {
            }

            @Generated
            public TableHeaderBuilder name(String string) {
                this.name = string;
                return this;
            }

            @Generated
            public TableHeaderBuilder type(String string) {
                this.type = string;
                return this;
            }

            @Generated
            public TableHeaderBuilder sortable(boolean bl) {
                this.sortable = bl;
                return this;
            }

            @Generated
            public TableHeaderBuilder colspan(int n) {
                this.colspan$value = n;
                this.colspan$set = true;
                return this;
            }

            @Generated
            public TableHeader build() {
                int n = this.colspan$value;
                if (!this.colspan$set) {
                    n = TableHeader.$default$colspan();
                }
                return new TableHeader(this.name, this.type, this.sortable, n);
            }

            @Generated
            public String toString() {
                return "FreemarkerReportCreator.TableHeader.TableHeaderBuilder(name=" + this.name + ", type=" + this.type + ", sortable=" + this.sortable + ", colspan$value=" + this.colspan$value + ")";
            }
        }
    }

    private static class HtmlReport {
        final Map<String, Object> context = new HashMap<String, Object>();

        public HtmlReport(String string, String string2) {
            this.context.put("workflow", string);
            this.context.put("group", string2);
            this.context.put("report_date", new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            this.context.put("img_logo", ReportUtils.getClasspathInlineImageDataString("images/logo/prediktera_breeze_lowres.png"));
            this.context.put("favicon", ReportUtils.getClasspathInlineImageDataString("images/icons/Breeze_16.png"));
        }

        public void writeFile(File file) {
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                Template template = configuration.getTemplate("report_template.ftl");
                template.process(this.context, (Writer)bufferedWriter);
            }
            catch (TemplateException | IOException throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }
}

