/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldCategory;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldDescriptorList;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldGroup;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldIdentifier;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldModelComponentRow;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldProperty;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldSampleInfo;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldTimeStamp;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelTableModel;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.model.AbstractPrediction;

public class ReportFieldList {
    private final List<ReportField> fields = new ArrayList<ReportField>();

    public ReportFieldList(Workflow workflow, Group group) {
        this.fields.add(new ReportFieldTimeStamp());
        this.fields.add(new ReportFieldSampleInfo());
        this.fields.add(new ReportFieldGroup());
        for (ThingWithName thingWithName : workflow.getIdentifiers()) {
            this.fields.add(new ReportFieldIdentifier((Identifier)thingWithName));
        }
        for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
            this.fields.add(new ReportFieldCategory((CategoryFactor)thingWithName));
        }
        for (ThingWithName thingWithName : workflow.getPropertyFactors()) {
            this.fields.add(new ReportFieldProperty((PropertyFactor)thingWithName));
        }
        this.fields.addAll(new ReportFieldDescriptorList(workflow.getSegmentationLevelDescriptorNodes(true), workflow.getVisualisationNode().getDefaultLimitNode(group)).collection());
    }

    public ReportFieldList(BreezeProgressManager breezeProgressManager, Analyse analyse) {
        this.fields.add(new ReportFieldModelComponentRow("Component"));
        this.fields.add(new ReportFieldModelComponentRow("R2X_cum"));
        AbstractModel abstractModel = analyse.getBaseModel(breezeProgressManager);
        if (abstractModel.getComponentsInt() > 0) {
            AbstractDataMatrix abstractDataMatrix;
            AbstractPrediction abstractPrediction;
            AbstractDataMatrix abstractDataMatrix2;
            BreezeModelTableModel.ModelComponentRow modelComponentRow = new BreezeModelTableModel.ModelComponentRow(abstractModel, 0);
            if (modelComponentRow.hasMatrix("R2Y_cum")) {
                this.fields.add(new ReportFieldModelComponentRow("R2Y_cum"));
            }
            if (modelComponentRow.hasMatrix("Q2Y_cum")) {
                this.fields.add(new ReportFieldModelComponentRow("Q2Y_cum"));
            }
            if ((abstractDataMatrix2 = modelComponentRow.model.getMatrixByName("RMSECV_var")) != null) {
                for (int i = 0; i < abstractDataMatrix2.getK(); ++i) {
                    this.fields.add(new ReportFieldModelComponentRow("RMSECV_" + abstractDataMatrix2.getColumnDescription(i, 0)));
                }
            }
            if ((abstractPrediction = modelComponentRow.model.getLocalPredictionNode()) != null && (abstractDataMatrix = abstractPrediction.getMatrixByName("RMSEP_var")) != null) {
                for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                    this.fields.add(new ReportFieldModelComponentRow("RMSEP_" + abstractDataMatrix2.getColumnDescription(i, 0)));
                }
            }
        }
    }

    public List<FreemarkerReportCreator.TableHeader> headerList() {
        ArrayList<FreemarkerReportCreator.TableHeader> arrayList = new ArrayList<FreemarkerReportCreator.TableHeader>();
        for (ReportField reportField : this.fields) {
            arrayList.addAll(reportField.toTableHeaders());
        }
        return arrayList;
    }

    public List<List<FreemarkerReportCreator.TableCell>> rowsFor(BreezeProgress breezeProgress, List<Sample> list, ReportFieldList reportFieldList) {
        return new ArrayList<List<FreemarkerReportCreator.TableCell>>(reportFieldList.rowsFor(breezeProgress, list));
    }

    public List<List<FreemarkerReportCreator.TableCell>> rowsFor(BreezeProgress breezeProgress, List<Sample> list) {
        breezeProgress.setMaximumAndReset(list.size());
        int n = 1;
        ArrayList<List<FreemarkerReportCreator.TableCell>> arrayList = new ArrayList<List<FreemarkerReportCreator.TableCell>>();
        for (Sample sample : list) {
            breezeProgress.setInfoText(String.format("Generating HTML Report (Sample %d of %d)", n, list.size()));
            if (breezeProgress.isAborted()) {
                throw new BreezeProgress.ProgressActionCancelledException();
            }
            ArrayList<FreemarkerReportCreator.TableCell> arrayList2 = new ArrayList<FreemarkerReportCreator.TableCell>();
            for (ReportField reportField : this.fields) {
                arrayList2.addAll(reportField.toTableCells(sample));
            }
            arrayList.add(arrayList2);
            breezeProgress.incStep();
            ++n;
        }
        return arrayList;
    }

    public List<List<FreemarkerReportCreator.TableCell>> rowsFor(BreezeProgressManager breezeProgressManager, Analyse analyse) {
        ArrayList<List<FreemarkerReportCreator.TableCell>> arrayList = new ArrayList<List<FreemarkerReportCreator.TableCell>>();
        AbstractModel abstractModel = analyse.getBaseModel(breezeProgressManager);
        for (int i = 0; i < abstractModel.getComponentsInt(); ++i) {
            BreezeModelTableModel.ModelComponentRow modelComponentRow = new BreezeModelTableModel.ModelComponentRow(abstractModel, i);
            ArrayList<FreemarkerReportCreator.TableCell> arrayList2 = new ArrayList<FreemarkerReportCreator.TableCell>();
            for (ReportField reportField : this.fields) {
                arrayList2.addAll(reportField.toTableCells(modelComponentRow));
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static interface ReportField<T> {
        public List<FreemarkerReportCreator.TableHeader> toTableHeaders();

        public List<FreemarkerReportCreator.TableCell> toTableCells(T var1);
    }
}

