/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.spatial.PlsPredDistributionDescriptor;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;

public class ReportUtils {
    public static String getClasspathInlineImageDataString(String string) {
        byte[] byArray = ReportUtils.readResourceToByteArray(string);
        return ReportUtils.getBase64String(byArray);
    }

    public static String getAbsolutePathInlineImageDataString(String string) throws NoSuchFileException {
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
            return ReportUtils.getBase64String(byArray);
        }
        catch (NoSuchFileException noSuchFileException) {
            throw noSuchFileException;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String createImageTagString(Thumbnail thumbnail, LimitConfiguration limitConfiguration) {
        try {
            return ReportUtils.getThumbnailImageDataString(thumbnail, limitConfiguration);
        }
        catch (NoSuchFileException noSuchFileException) {
            return "--MISSING--";
        }
    }

    public static String getThumbnailImageDataString(Thumbnail thumbnail, LimitConfiguration limitConfiguration) throws NoSuchFileException {
        if (thumbnail == null) {
            throw new NoSuchFileException("");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bufferedImage = thumbnail.render(limitConfiguration);
            if (bufferedImage != null) {
                ImageIO.write((RenderedImage)bufferedImage, "png", Base64.getEncoder().wrap(byteArrayOutputStream));
            }
            return String.format("data:image/png;base64,%s", byteArrayOutputStream.toString(StandardCharsets.ISO_8859_1));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static String getBase64String(byte[] byArray) {
        return String.format("data:image/png;base64,%s", Base64.getEncoder().encodeToString(byArray));
    }

    public static String readResourceToString(String string) {
        return new String(ReportUtils.readResourceToByteArray(string));
    }

    public static byte[] readResourceToByteArray(String string) {
        InputStream inputStream = FreemarkerReportCreator.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException(String.format("Could not find resource '%s'", string));
        }
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String serializeHeader(Object object) {
        if (object instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)object;
            String string = descriptorTreeNode.getAliasOrNodeString(FunctionTreeNode.TextType.Table);
            if (ReportUtils.isDirectionDescriptor(descriptorTreeNode)) {
                return string + "_degree;" + string;
            }
            return string;
        }
        if (object instanceof Factor) {
            return ((Factor)object).getName();
        }
        return object.toString();
    }

    private static boolean isDirectionDescriptor(DescriptorTreeNode descriptorTreeNode) {
        return descriptorTreeNode.getFunction() instanceof PlsPredDistributionDescriptor && descriptorTreeNode.getIndex() == 2;
    }

    static String formatNumber(String string, String string2) {
        if (!string2.equals(".")) {
            return string.replaceAll("\\.", string2);
        }
        return string;
    }

    static String getValue(Sample sample, Object object, String string) {
        String string2 = ReportUtils.getStringValue(object, sample);
        if (string2 == null) {
            return "";
        }
        if (string.equals(".")) {
            return string2;
        }
        return string2.replaceAll("\\.", string);
    }

    public static String getStringValue(Object object, Sample sample) {
        if (object instanceof Factor) {
            return ((Factor)object).getStringValue(sample);
        }
        if (object instanceof Identifier) {
            return ((Identifier)object).getTextValue(sample);
        }
        if (object instanceof FunctionResult) {
            FunctionResult functionResult = (FunctionResult)object;
            String string = functionResult.getUnformattedValue(6);
            if (ReportUtils.isDirectionDescriptor(functionResult.getNode())) {
                return string.replace("\u00b0 ", ";");
            }
            return string;
        }
        if (object instanceof Entry) {
            return ((Entry)object).getName();
        }
        if (object instanceof Sample) {
            return ((Sample)object).getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE);
        }
        if (object instanceof Thumbnail) {
            return "";
        }
        return null;
    }
}

