/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportFieldList;

public class ReportFieldCategory
implements ReportFieldList.ReportField<Sample> {
    private final CategoryFactor factor;

    public ReportFieldCategory(CategoryFactor categoryFactor) {
        this.factor = categoryFactor;
    }

    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name(this.factor.getName()).type("factor").sortable(true);
        return Collections.singletonList(tableHeaderBuilder.build());
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(Sample sample) {
        FreemarkerReportCreator.TableCell tableCell = new FreemarkerReportCreator.TableCell(this.factor.getStringValue(sample), "category-factor", this.factor.getStringValue(sample));
        tableCell.setColor(RtPerfectSpread.getColorToString(this.factor.getClass(sample).getColor()));
        tableCell.isMissingValue = this.factor.isMissing(sample);
        return List.of(tableCell);
    }
}

