/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldWithDescriptorChildren;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;

public class ReportFieldCustomRenderingDescriptor
extends ReportFieldWithDescriptorChildren {
    private final DescriptorTreeNode node;
    private final CustomRenderingDescriptor descriptor;

    public ReportFieldCustomRenderingDescriptor(DescriptorTreeNode descriptorTreeNode, LimitConfiguration limitConfiguration) {
        super(descriptorTreeNode, limitConfiguration);
        this.node = descriptorTreeNode;
        this.descriptor = (CustomRenderingDescriptor)((Object)descriptorTreeNode.getFunction());
    }

    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        String string = this.getSubFieldHeaderString();
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name(String.format("%s%s", this.node.getAliasOrNodeString(FunctionTreeNode.TextType.Table), string)).type("descriptor").sortable(true);
        if (this.hasThumbnail()) {
            tableHeaderBuilder.colspan(2);
        }
        return Collections.singletonList(tableHeaderBuilder.build());
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(Sample sample) {
        FreemarkerReportCreator.TableCell tableCell;
        ArrayList<FreemarkerReportCreator.TableCell> arrayList = new ArrayList<FreemarkerReportCreator.TableCell>();
        CustomRenderingDescriptor.RenderData renderData = this.descriptor.getStringValueAndOptionalBoxColor(this.readStringValue(sample), this.getResult(sample));
        if (renderData.IsPercent()) {
            tableCell = new FreemarkerReportCreator.TableCell(this.readStringValue(sample), "percent", this.readSortValue(sample));
        } else if (renderData.BoxColor().isEmpty()) {
            tableCell = new FreemarkerReportCreator.TableCell(this.readStringValue(sample), "none", this.readSortValue(sample));
        } else {
            tableCell = new FreemarkerReportCreator.TableCell(this.readStringValue(sample), "descriptor", this.readSortValue(sample));
            tableCell.color = renderData.BoxColor().get();
        }
        tableCell.isMissingValue = this.isMissingValue(sample);
        arrayList.add(tableCell);
        if (this.hasThumbnail()) {
            arrayList.add(new FreemarkerReportCreator.TableCell(this.createImageTag(sample), "thumbnail", this.readSortValue(sample)));
        }
        return arrayList;
    }

    private String createImageTag(Sample sample) {
        return ReportUtils.createImageTagString(ThumbnailHelper.create(sample.measurement(), sample, this.node), null);
    }

    private String readSortValue(Sample sample) {
        return String.format("%f", Float.valueOf(this.readValue(sample)));
    }

    private float readValue(Sample sample) {
        FunctionResult functionResult = this.getResult(sample);
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return -1.0f;
    }

    @Override
    protected String readStringValue(Sample sample) {
        FunctionResult functionResult = this.getResult(sample);
        if (functionResult != null && !functionResult.isMissing()) {
            return functionResult.getStringValueWithUnit().replace(" ", "&nbsp;");
        }
        return "";
    }

    protected boolean isMissingValue(Sample sample) {
        FunctionResult functionResult = this.getResult(sample);
        if (functionResult != null && !functionResult.isMissing()) {
            return functionResult.isMissing();
        }
        return false;
    }

    @Override
    public String getSubHeaderString() {
        return this.node.getAliasOrNodeString(FunctionTreeNode.TextType.Table).toLowerCase();
    }

    private FunctionResult getResult(Sample sample) {
        return sample.getFunctionResult(this.node.getUid());
    }

    private boolean hasThumbnail() {
        return this.descriptor.hasThumbnail(0);
    }
}

