/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.report.field.ReportFieldWithDescriptorChildren;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;

public class ReportFieldDescriptor
extends ReportFieldWithDescriptorChildren {
    private final DescriptorTreeNode node;
    private final LimitConfiguration limitNode;
    private final boolean hasColSpan;

    public ReportFieldDescriptor(DescriptorTreeNode descriptorTreeNode, LimitConfiguration limitConfiguration) {
        super(descriptorTreeNode, limitConfiguration);
        this.node = descriptorTreeNode;
        this.limitNode = limitConfiguration;
        this.hasColSpan = descriptorTreeNode.getFunction().hasResult(descriptorTreeNode.getIndex());
    }

    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        String string = this.getSubFieldHeaderString();
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name(String.format("%s%s", this.node.getAliasOrNodeString(FunctionTreeNode.TextType.Table), string)).type("descriptor").sortable(true);
        if (this.hasThumbnail() && this.hasColSpan) {
            tableHeaderBuilder.colspan(2);
        }
        ArrayList<FreemarkerReportCreator.TableHeader> arrayList = new ArrayList<FreemarkerReportCreator.TableHeader>();
        arrayList.add(tableHeaderBuilder.build());
        List<AdditionalFactor> list = this.node.getAdditionalFactors();
        if (list instanceof List) {
            List<AdditionalFactor> list2 = list;
            for (AdditionalFactor additionalFactor : list2) {
                tableHeaderBuilder.name(additionalFactor.getName());
                arrayList.add(tableHeaderBuilder.build());
            }
        }
        return arrayList;
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(Sample sample) {
        Object object;
        ArrayList<FreemarkerReportCreator.TableCell> arrayList = new ArrayList<FreemarkerReportCreator.TableCell>();
        LegendValues legendValues = this.getMinMax(sample);
        FunctionResult functionResult = sample.getFunctionResult(this.node.getUid());
        this.addTableCells(sample, functionResult, legendValues, arrayList, null);
        if (functionResult != null && (object = functionResult.getFunction().getAdditionalFactors()) instanceof List) {
            List<AdditionalFactor> list = object;
            for (AdditionalFactor additionalFactor : list) {
                this.addTableCells(sample, functionResult, legendValues, arrayList, additionalFactor);
            }
        }
        return arrayList;
    }

    private void addTableCells(Sample sample, FunctionResult functionResult, LegendValues legendValues, List<FreemarkerReportCreator.TableCell> list, AdditionalFactor additionalFactor) {
        Object object;
        if (functionResult != null && functionResult.getFunction().hasResult(this.node.getIndex())) {
            object = new FreemarkerReportCreator.TableCell(this.readStringValue(sample), "descriptor", this.readSortValue(sample, additionalFactor));
            ((FreemarkerReportCreator.TableCell)object).isMissingValue = this.isMissingValue(sample);
            if (legendValues != null) {
                ((FreemarkerReportCreator.TableCell)object).type = "percent";
            }
            list.add((FreemarkerReportCreator.TableCell)object);
        }
        if (this.hasThumbnail()) {
            object = ReportUtils.createImageTagString(ThumbnailHelper.create(sample.measurement(), sample, this.node, additionalFactor, true, true), this.limitNode);
            FreemarkerReportCreator.TableCell tableCell = new FreemarkerReportCreator.TableCell((String)object, "thumbnail", this.readSortValue(sample, additionalFactor));
            if (legendValues != null) {
                tableCell.type = legendValues.is2d() ? "legend2d" : "legend";
                tableCell.setMin(legendValues.min);
                tableCell.setMax(legendValues.max);
                if (legendValues.hasXLabels()) {
                    tableCell.setMinWl(legendValues.minWls);
                    tableCell.setMiddleWl(legendValues.middleWls);
                    tableCell.setMaxWl(legendValues.maxWls);
                }
            }
            list.add(tableCell);
        }
    }

    public String readSortValue(Sample sample, AdditionalFactor additionalFactor) {
        return String.format("%f", Float.valueOf(this.readValue(sample, additionalFactor)));
    }

    @Override
    public String getSubHeaderString() {
        return this.node.getAliasOrNodeString(FunctionTreeNode.TextType.Table).toLowerCase();
    }

    public float readValue(Sample sample, AdditionalFactor additionalFactor) {
        Float f;
        if (additionalFactor != null && (f = additionalFactor.getFactor().getValue(sample)) instanceof Float) {
            Float f2 = f;
            return f2.floatValue();
        }
        FunctionResult functionResult = sample.getFunctionResult(this.node.getUid());
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return -1.0f;
    }

    public LegendValues getMinMax(Sample sample) {
        Object object;
        FunctionResult functionResult = sample.getFunctionResult(this.node.getUid());
        if (functionResult != null && (object = functionResult.getMinMax(this.limitNode)) instanceof MinMax) {
            MinMax minMax = object;
            Object object2 = this.node.getFunction();
            if (object2 instanceof MwlDescriptor) {
                object = (MwlDescriptor)object2;
                object2 = ((MwlDescriptor)object).getVisualizationBandNames();
                return new LegendValues(minMax.min().floatValue(), minMax.max().floatValue(), true, RtDataFormat.toNumberFloat(((BandNames)object2).get(0)), RtDataFormat.toNumberFloat(((BandNames)object2).get(((BandNames)object2).size() / 2)), RtDataFormat.toNumberFloat(((BandNames)object2).get(((BandNames)object2).size() - 1)));
            }
            return new LegendValues(minMax.min().floatValue(), minMax.max().floatValue(), false);
        }
        return null;
    }

    @Override
    public String readStringValue(Sample sample) {
        FunctionResult functionResult = sample.getFunctionResult(this.node.getUid());
        if (functionResult != null) {
            return functionResult.getStringValueWithUnit().replace(" ", "&nbsp;");
        }
        return "";
    }

    private boolean isMissingValue(Sample sample) {
        FunctionResult functionResult = sample.getFunctionResult(this.node.getUid());
        if (functionResult != null) {
            return functionResult.isMissing();
        }
        return true;
    }

    private boolean hasThumbnail() {
        return this.node.getFunction().hasThumbnail(this.node.getIndex());
    }

    record LegendValues(float min, float max, boolean is2d, float minWls, float middleWls, float maxWls) {
        LegendValues(float f, float f2, boolean bl) {
            this(f, f2, bl, Float.NaN, Float.NaN, Float.NaN);
        }

        public boolean hasXLabels() {
            return !Float.isNaN(this.minWls) && !Float.isNaN(this.middleWls) && !Float.isNaN(this.maxWls);
        }
    }
}

