/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportFieldList;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelTableModel;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.model.AbstractPrediction;

public class ReportFieldModelComponentRow
implements ReportFieldList.ReportField<BreezeModelTableModel.ModelComponentRow> {
    private final String header;

    public ReportFieldModelComponentRow(String string) {
        this.header = string;
    }

    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name(this.header).type("identifier").sortable(true);
        return Collections.singletonList(tableHeaderBuilder.build());
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(BreezeModelTableModel.ModelComponentRow modelComponentRow) {
        String string = this.getValue(modelComponentRow, this.header);
        return List.of(new FreemarkerReportCreator.TableCell(string, "identifier", string));
    }

    private String getValue(BreezeModelTableModel.ModelComponentRow modelComponentRow, String string) {
        AbstractPrediction abstractPrediction;
        if (modelComponentRow.hasMatrix(string)) {
            return NiceDataFormat.toString((double)modelComponentRow.getValue(string));
        }
        if (string.equals("Component")) {
            return String.valueOf(modelComponentRow.component + 1);
        }
        if (string.startsWith("RMSECV_")) {
            return this.getMatrixValue(modelComponentRow, string.substring("RMSECV_".length()), modelComponentRow.model.getMatrixByName("RMSECV_var"));
        }
        if (string.startsWith("RMSEP_") && (abstractPrediction = modelComponentRow.model.getLocalPredictionNode()) != null) {
            return this.getMatrixValue(modelComponentRow, string.substring("RMSEP_".length()), abstractPrediction.getMatrixByName("RMSEP_var"));
        }
        return "N/A";
    }

    private String getMatrixValue(BreezeModelTableModel.ModelComponentRow modelComponentRow, String string, AbstractDataMatrix abstractDataMatrix) {
        if (abstractDataMatrix != null) {
            for (int i = 0; i < abstractDataMatrix.getK(); ++i) {
                if (!abstractDataMatrix.getColumnDescription(i, 0).equals(string)) continue;
                return NiceDataFormat.toString((double)abstractDataMatrix.getValue(modelComponentRow.component, i));
            }
        }
        return "N/A";
    }
}

