/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportFieldList;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;

public class ReportFieldSampleInfo
implements ReportFieldList.ReportField<Sample> {
    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name("Sample").type("sample-info").sortable(true).colspan(2);
        return Collections.singletonList(tableHeaderBuilder.build());
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(Sample sample) {
        return Arrays.asList(new FreemarkerReportCreator.TableCell(this.createImageTag(sample), "thumbnail", this.readSortValue(sample)), new FreemarkerReportCreator.TableCell(this.readValue(sample), "sample-info", this.readSortValue(sample)));
    }

    private String createImageTag(Sample sample) {
        Measurement measurement = sample.measurement();
        ThumbnailSample thumbnailSample = new ThumbnailSample(measurement.getCustomImageFile(), measurement, sample);
        return ReportUtils.createImageTagString(thumbnailSample, null);
    }

    private String readValue(Sample sample) {
        String string = String.format("Sample %s", sample.getIndexString());
        String string2 = sample.measurement().getName();
        return String.format("<strong>%s</strong><br/>%s", string2, string);
    }

    private String readSortValue(Sample sample) {
        String string = sample.getIndexString();
        String string2 = sample.measurement().getName();
        String string3 = string2.replace("Measurement", "").trim();
        if (string3.equals("")) {
            string3 = "0";
        }
        return String.format("%s.%s", string3, string);
    }
}

