/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.report.field;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator;
import se.prediktera.breeze.frontend.common.report.ReportFieldList;

public class ReportFieldTimeStamp
implements ReportFieldList.ReportField<Sample> {
    private static final SimpleDateFormat timeStampFormatDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeStampFormatTime = new SimpleDateFormat("HH:mm:ss");

    @Override
    public List<FreemarkerReportCreator.TableHeader> toTableHeaders() {
        FreemarkerReportCreator.TableHeader.TableHeaderBuilder tableHeaderBuilder = FreemarkerReportCreator.TableHeader.builder().name("Time").type("timestamp").sortable(true);
        return Collections.singletonList(tableHeaderBuilder.build());
    }

    @Override
    public List<FreemarkerReportCreator.TableCell> toTableCells(Sample sample) {
        return List.of(new FreemarkerReportCreator.TableCell(this.readTimeStamp(sample), "timestamp", this.readSortValue(sample)));
    }

    private String readTimeStamp(Sample sample) {
        Date date = sample.measurement().getEntryData().getCreatedDate();
        if (date != null) {
            return String.format("%s<br/>%s", timeStampFormatDate.format(date), timeStampFormatTime.format(date));
        }
        return "<Missing timestamp>";
    }

    public String readSortValue(Sample sample) {
        Date date = sample.measurement().getEntryData().getCreatedDate();
        if (date != null) {
            return String.format("%d", date.getTime());
        }
        return "0";
    }
}

