/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeKeyboard;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidator;
import se.prediktera.breeze.frontend.common.swing.validator.TextValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;
import se.prediktera.map.common.NiceDataFormat;

public abstract class AbstractBreezeTextPanel
extends JPanel {
    private boolean activekeyboard = true;
    private boolean addKeyVisible = false;
    private Border originalBorder;
    private BreezeKeyboard keyboard;
    private JLabel label;
    private final List<TextActionEvent.TextActionListener> actionListenerList = new ArrayList<TextActionEvent.TextActionListener>();
    private final List<AbstractValidator> validatorList = new ArrayList<AbstractValidator>();
    private String origText = null;
    private int layer = 1;
    private boolean checkTextChanged = true;

    public void addChangeListener(TextActionEvent.TextActionListener textActionListener) {
        this.actionListenerList.add(textActionListener);
    }

    public void clearChangeListeners() {
        this.actionListenerList.clear();
    }

    public abstract void addDocumentListener(DocumentListener var1);

    public void addValidator(AbstractValidator abstractValidator) {
        this.validatorList.add(abstractValidator);
    }

    public int getCaretPosition() {
        return 0;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public int getLayer() {
        return this.layer;
    }

    public Object getSelectedText() {
        return null;
    }

    public abstract String getText();

    public void hideTouchKeyboard() {
        this.keyboard.closeWithoutSave();
    }

    public boolean isActivekeyboard() {
        return this.activekeyboard;
    }

    public boolean isAddKeyVisible() {
        return this.addKeyVisible;
    }

    public boolean isNumberField() {
        return false;
    }

    public abstract void removeDocumentListener(DocumentListener var1);

    public void replaceSelection(String string) {
    }

    public abstract void requestFocusAndSelectAll();

    public void resetTouchKeyboard() {
        this.keyboard.closeWithoutSave();
        this.showKeyboard();
    }

    public void setActivekeyboard(boolean bl) {
        this.activekeyboard = bl;
    }

    public void setAddKeyVisible(boolean bl) {
        this.addKeyVisible = bl;
    }

    public void setCaretPosition(int n) {
    }

    public void setLabel(JLabel jLabel) {
        this.label = jLabel;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setMinlength(int n) {
        this.addValidator(new TextValidator(n, this.isNumberField()));
    }

    protected abstract void setTextInComponent(String var1);

    public void setFormatedNumber(double d) {
        this.setTextInComponent(NiceDataFormat.toString((double)d));
    }

    public void setTextAndTrigger(String string) {
        this.setTextInComponent(string);
        this.triggerChange(false);
    }

    public void setText(String string) {
        this.setTextInComponent(string);
        this.origText = string;
    }

    public abstract boolean supportMultipleLines();

    public void touchKeyboardInit(BreezeKeyboard breezeKeyboard) {
        this.keyboard = breezeKeyboard;
        this.keyboard.setAddKeyVisible(this.addKeyVisible);
        if (this.addKeyVisible) {
            this.keyboard.cleanUpAddKeyListener();
            this.keyboard.addAddKeyListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractBreezeTextPanel.this.setText(AbstractBreezeTextPanel.this.keyboard.getText());
                    AbstractBreezeTextPanel.this.triggerChange(false);
                    AbstractBreezeTextPanel.this.requestFocusAndSelectAll();
                }
            });
        } else {
            this.keyboard.useSetListener();
        }
    }

    public ValidatorResult validateText(String string) {
        for (AbstractValidator abstractValidator : this.validatorList) {
            ValidatorResult validatorResult = abstractValidator.validate(string);
            if (validatorResult == null) continue;
            return validatorResult;
        }
        return null;
    }

    public void ClearValidators() {
        this.validatorList.clear();
    }

    protected void showKeyboard() {
        if (this.activekeyboard && BreezeFrame.touchscreen && this.isEnabled()) {
            BreezeFrame breezeFrame = (BreezeFrame)SwingUtilities.getWindowAncestor(this);
            EntryMainPanel entryMainPanel = (EntryMainPanel)SwingUtilities.getAncestorOfClass(EntryMainPanel.class, this);
            Color color = null;
            if (entryMainPanel != null) {
                color = entryMainPanel.getPageColor();
            } else {
                AbstractBreezeDialog abstractBreezeDialog = (AbstractBreezeDialog)((Object)SwingUtilities.getAncestorOfClass(AbstractBreezeDialog.class, this));
                if (abstractBreezeDialog != null) {
                    color = abstractBreezeDialog.getColor();
                }
            }
            this.keyboard = new BreezeKeyboard(breezeFrame, this, color);
            breezeFrame.addPage((JPanel)((Object)this.keyboard));
        }
    }

    public void setCheckTextChanged(boolean bl) {
        this.checkTextChanged = bl;
    }

    private boolean hasChanged() {
        if (this.checkTextChanged && this.origText != null) {
            return !this.getText().equals(this.origText);
        }
        return true;
    }

    public void setTextAndTriggerFocusLost(String string) {
    }

    public void triggerChange(boolean bl) {
        this.triggerChange(bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ValidatorResult> triggerChange(boolean bl, boolean bl2) {
        if (!this.hasChanged() && !bl2) {
            return Optional.empty();
        }
        String string = this.getText();
        ValidatorResult validatorResult = this.validateText(string);
        if (validatorResult != null) {
            if (validatorResult.getSuggestedValue() != null) {
                this.setText(validatorResult.getSuggestedValue());
            } else {
                if (!validatorResult.highLightBorder()) {
                    this.setText(this.origText);
                    if (this.originalBorder == null) throw new RuntimeException(validatorResult.getResult());
                    this.setBorder(this.originalBorder);
                    throw new RuntimeException(validatorResult.getResult());
                }
                if (this.originalBorder == null) {
                    this.originalBorder = this.getBorder();
                }
                this.setBorder(BorderFactory.createLineBorder(Color.RED));
                this.setToolTipText(validatorResult.getResult());
            }
        } else if (this.originalBorder != null) {
            this.setBorder(this.originalBorder);
            this.setToolTipText(null);
        }
        TextActionEvent textActionEvent = new TextActionEvent(this, bl, this.getText());
        try {
            Iterator<TextActionEvent.TextActionListener> iterator = this.actionListenerList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.origText = this.getText();
                    return Optional.ofNullable(validatorResult);
                }
                TextActionEvent.TextActionListener textActionListener = iterator.next();
                textActionListener.actionPerformed(textActionEvent);
            }
        }
        catch (Exception exception) {
            this.setText(this.origText);
            if (this.originalBorder == null) throw exception;
            this.setBorder(this.originalBorder);
            throw exception;
        }
    }
}

