/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingConstants;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeArrowButton
extends JButton
implements SwingConstants {
    private final JComboBox comboBox;

    public BreezeArrowButton(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        jComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                BreezeArrowButton.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                BreezeArrowButton.this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                BreezeArrowButton.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        if (this.comboBox.isEnabled()) {
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
            this.setForeground(BreezeTheme.getInstance().getLabelForeground());
        } else {
            this.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
            this.setForeground(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (this.getBorder() != null && !(this.getBorder() instanceof UIResource)) {
            this.paintBorder(graphics);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, 0, bl2, bl);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int[] nArray;
        int n5 = this.getWidth() / 2;
        int n6 = this.getHeight() / 2;
        int n7 = Math.min(this.getWidth(), this.getHeight()) / 4;
        int n8 = Math.min(this.getWidth(), this.getHeight()) / 6;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setColor(this.getForeground());
        int[] nArray2 = new int[]{n5 - n7, n5 + n7, n5};
        if (this.comboBox.isPopupVisible()) {
            int[] nArray3 = new int[3];
            nArray3[0] = n6 + n8;
            nArray3[1] = n6 + n8;
            nArray = nArray3;
            nArray3[2] = n6 - n8;
        } else {
            int[] nArray4 = new int[3];
            nArray4[0] = n6 - n8;
            nArray4[1] = n6 - n8;
            nArray = nArray4;
            nArray4[2] = n6 + n8;
        }
        int[] nArray5 = nArray;
        graphics2D.fillPolygon(nArray2, nArray5, 3);
        graphics2D.dispose();
    }
}

