/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.ButtonMouseAdapter;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeButton
extends JPanel
implements BreezeButtonInterface {
    private final MouseAdapter hoverEffectListener;
    private boolean hasRoundedBorder = true;
    private Color baseBorderColor = BreezeTheme.getInstance().getLabelForegroundDifuse();
    private final RoundedBorder border = new RoundedBorder(this, this.baseBorderColor, 1);
    private ImageIcon icon;
    private ImageIcon grayedIcon;
    private ImageIcon hoverIcon;
    private ImageIcon pressedIcon = null;
    private Color bgColor;
    private final JLabel descLabel = new JLabel();
    private final JLabel imageLabel = new JLabel();
    private Color disabledBackground = BreezeTheme.getInstance().getSettingPanelBackground();
    private MouseEvent clickEvent;
    private Color fgColor;
    private String iconName;
    private IconLocation currentIconLocation = IconLocation.LEFT;

    public BreezeButton(String string, EntryMainHelper.ClickCallBack clickCallBack) {
        this();
        this.setText(string);
        if (clickCallBack != null) {
            this.addClickCallBack(clickCallBack);
        }
    }

    public BreezeButton() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.setCursor(BreezeFrame.getHandCursor());
        this.imageLabel.setFont(new Font("Tahoma", 0, 20));
        this.imageLabel.setFocusable(false);
        this.imageLabel.setHorizontalAlignment(2);
        this.imageLabel.setVerticalAlignment(0);
        this.imageLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.imageLabel.setCursor(BreezeFrame.getHandCursor());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.add((Component)this.imageLabel, gridBagConstraints);
        this.descLabel.setFont(new Font("Tahoma", 0, 12));
        this.descLabel.setText("Text");
        this.descLabel.setCursor(BreezeFrame.getHandCursor());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.descLabel, gridBagConstraints);
        this.setDesc("");
        this.hoverEffectListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                BreezeButton.this.mouseEnteredLocal();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                BreezeButton.this.mouseExitedLocal();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    ImageIcon imageIcon = BreezeButton.this.getIcon();
                    if (BreezeButton.this.isEnabled() && imageIcon != null && StringUtils.isEmpty((CharSequence)BreezeButton.this.getText())) {
                        BreezeButton.this.setIconLocal(BreezeButton.this.getPressedIcon());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.mouseExited(mouseEvent);
            }
        };
        super.addMouseListener(this.hoverEffectListener);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setDescForegroundReal(breezeTheme.getButtonForeground());
        this.descLabel.setForeground(breezeTheme.getLabelForeground());
        this.setTextForeground(breezeTheme.getLabelForeground());
    }

    public void addClickCallBack(final EntryMainHelper.ClickCallBack clickCallBack) {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ BreezeButton this$0;
            {
                this.this$0 = breezeButton;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.this$0.clickEvent = mouseEvent;
                    this.this$0.requestFocus();
                    clickCallBack.doClick();
                }
            }
        });
    }

    public void setPadding(int n) {
        this.setPadding(n, n, n, n);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.imageLabel);
        gridBagConstraints.insets = new Insets(n, n2, n3, n4);
        gridBagLayout.setConstraints(this.imageLabel, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void mouseEnteredLocal() {
        if (this.isEnabled()) {
            ImageIcon imageIcon = this.getIcon();
            if (this.hasRoundedBorder && StringUtils.isNotBlank((CharSequence)this.getText())) {
                this.border.setStrokeWidth(2);
                boolean bl = this.bgColor == BreezeTheme.DARK_BACKGROUND_COLOR;
                super.setBackground(bl ? this.bgColor.brighter() : this.bgColor.darker());
            } else if (imageIcon != null) {
                this.setIconLocal(this.getHoverIcon());
            }
        }
    }

    protected void mouseExitedLocal() {
        if (this.isEnabled()) {
            ImageIcon imageIcon = this.getIcon();
            if (imageIcon != null) {
                this.setIconLocal(imageIcon);
            }
            if (this.hasRoundedBorder) {
                this.border.setStrokeWidth(1);
                super.setBackground(this.bgColor);
            }
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(new ButtonMouseAdapter(this, mouseListener));
    }

    public void clearMouseListeners() {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
    }

    public void addHoverEffects() {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            if (!mouseListener.equals(this.hoverEffectListener)) continue;
            return;
        }
        super.addMouseListener(this.hoverEffectListener);
    }

    @Override
    public void doClick() {
        MouseListener[] mouseListenerArray;
        this.requestFocus();
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            if (!(mouseListener instanceof ButtonMouseAdapter)) continue;
            ((ButtonMouseAdapter)mouseListener).triggerEvent(new MouseEvent(this, 0, System.currentTimeMillis(), 0, 0, 0, 0, true, 1));
        }
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public String getDesc() {
        return this.descLabel.getText();
    }

    public Color getDescForeground() {
        return this.descLabel.getForeground();
    }

    public String getText() {
        return this.imageLabel.getText();
    }

    public Font getTextFont() {
        return this.imageLabel.getFont();
    }

    public void setTextFont(Font font) {
        this.imageLabel.setFont(font);
    }

    public void setTextFontSize(int n) {
        Font font = this.imageLabel.getFont();
        this.imageLabel.setFont(new Font(font.getFontName(), font.getStyle(), n));
    }

    public void setFontStyle(int n) {
        Font font = this.imageLabel.getFont();
        this.imageLabel.setFont(new Font(font.getFontName(), n, font.getSize()));
    }

    @Override
    public void setBackground(Color color) {
        this.bgColor = color;
        super.setBackground(this.isEnabled() ? this.bgColor : this.disabledBackground);
    }

    public void setBaseBorderColor(Color color) {
        this.baseBorderColor = color;
        this.setBorderColor(color);
    }

    public void setBorderColor(Color color) {
        if (this.border != null) {
            this.border.setColor(color);
        }
    }

    public void setDesc(String string) {
        this.descLabel.setText(string);
        this.descLabel.setVisible(!string.isEmpty());
    }

    public void setDescForegroundReal(Color color) {
        this.fgColor = color;
        this.descLabel.setForeground(color);
    }

    public void setDescForeground(Color color) {
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.icon = this.getIcon();
        if (this.icon != null) {
            if (bl) {
                this.setIconLocal(this.icon);
                this.descLabel.setForeground(this.fgColor);
            } else {
                this.setIconLocal(this.getGrayedIcon());
                this.descLabel.setForeground(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            }
        }
        this.imageLabel.setForeground(bl ? this.fgColor : BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
        super.setBackground(bl ? this.bgColor : this.disabledBackground);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.setIconLocal(this.adaptIconToTheme(imageIcon));
        this.pressedIcon = null;
        this.hoverIcon = null;
        this.grayedIcon = null;
        this.icon = null;
    }

    protected ImageIcon adaptIconToTheme(ImageIcon imageIcon) {
        if (imageIcon != null && BreezeTheme.getInstance().isDarkMode() && ImageHelper.isGrayscaleIcon(imageIcon)) {
            imageIcon = ImageHelper.changeGrayBrightnessDarkTheme(imageIcon);
        }
        return imageIcon;
    }

    public void setIconLocal(Icon icon) {
        this.imageLabel.setIcon(icon);
    }

    public Icon getIconLocal() {
        return this.imageLabel.getIcon();
    }

    public void updateIcon() {
        this.setResourceIcon(this.iconName);
    }

    public void setResourceIcon(String string) {
        this.setResourceIcon(string, false);
    }

    public void setResourceIcon(String string, boolean bl) {
        this.iconName = string;
        ImageIcon imageIcon = ImageHelper.getResourceIcon(string);
        if (imageIcon != null) {
            this.setIcon(bl ? ImageHelper.changeGrayBrightness(imageIcon, 100) : imageIcon);
        }
    }

    public void setIconLocation(IconLocation iconLocation) {
        if (this.currentIconLocation == iconLocation) {
            return;
        }
        this.currentIconLocation = iconLocation;
        if (this.currentIconLocation == IconLocation.RIGHT) {
            this.imageLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        } else {
            this.imageLabel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        }
        this.revalidate();
        this.repaint();
    }

    public void setIconVisible(boolean bl) {
        if (bl) {
            this.setEnabled(this.isEnabled());
            this.setIconLocal(this.getIcon());
        } else {
            this.icon = this.getIcon();
            this.setIconLocal(null);
        }
    }

    public void scaleIcon(float f) {
        ImageIcon imageIcon = this.getIcon();
        if (imageIcon != null) {
            BufferedImage bufferedImage = ImageHelper.imageToBufferedImage(imageIcon.getImage());
            this.setIcon(new ImageIcon(ImageHelper.scaleImagePercent(bufferedImage, f, f, true)));
        }
    }

    public void setMargin(Insets insets) {
        this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    public void setRoundedBorder(boolean bl) {
        this.hasRoundedBorder = bl;
        this.setText(this.imageLabel.getText());
    }

    public void setText(String string) {
        this.imageLabel.setText(string);
        if (!string.isEmpty()) {
            Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            if (this.hasRoundedBorder) {
                this.setBorder(BorderFactory.createCompoundBorder(this.border, border));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    public void setTextForeground(Color color) {
        this.fgColor = color;
        this.imageLabel.setForeground(color);
    }

    private ImageIcon getGrayedIcon() {
        ImageIcon imageIcon = this.getIcon();
        if (imageIcon != null && this.grayedIcon == null) {
            boolean bl = BreezeTheme.getInstance().isDarkMode();
            this.grayedIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(imageIcon.getImage().getSource(), new GrayFilter(!bl, bl ? 95 : 50))));
        }
        return this.grayedIcon;
    }

    private ImageIcon getHoverIcon() {
        if (this.icon != null && this.hoverIcon == null) {
            this.hoverIcon = this.createHoverIcon(this.icon);
        }
        return this.hoverIcon;
    }

    public void setHoverIcon(ImageIcon imageIcon) {
        this.hoverIcon = imageIcon;
    }

    protected ImageIcon createHoverIcon(ImageIcon imageIcon) {
        return ImageHelper.createHoverIcon(imageIcon);
    }

    protected float getHoverScale() {
        return 1.2f;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = (ImageIcon)this.imageLabel.getIcon();
        }
        return this.icon;
    }

    private ImageIcon getPressedIcon() {
        if (this.icon != null && this.pressedIcon == null) {
            ImageIcon imageIcon = this.getHoverIcon();
            Image image = imageIcon.getImage();
            BufferedImage bufferedImage = ImageHelper.imageToBufferedImage(image);
            bufferedImage = ImageHelper.scaleImagePercent(bufferedImage, 0.95, 0.95, true);
            this.pressedIcon = new ImageIcon(bufferedImage);
        }
        return this.pressedIcon;
    }

    public void setPreferredAndMinimumSize(int n, int n2) {
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
    }

    @Generated
    public boolean isHasRoundedBorder() {
        return this.hasRoundedBorder;
    }

    @Generated
    public void setDisabledBackground(Color color) {
        this.disabledBackground = color;
    }

    @Generated
    public MouseEvent getClickEvent() {
        return this.clickEvent;
    }

    public static class RoundedBorder
    extends AbstractBorder {
        private final JComponent parent;
        private Color color;
        private int strokewidth;
        private Stroke stroke;
        private final int arc;

        public RoundedBorder(JComponent jComponent, Color color, int n) {
            this(jComponent, color, n, 10);
        }

        public RoundedBorder(JComponent jComponent, Color color, int n, int n2) {
            this.parent = jComponent;
            this.color = color;
            this.arc = n2;
            this.setStrokeWidth(n);
        }

        public void setStrokeWidth(int n) {
            this.strokewidth = n;
            this.stroke = new BasicStroke(n, 0, 0, 10.0f);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setColor(this.parent.getBackground());
            int n5 = this.strokewidth / 2;
            int n6 = n5 + this.strokewidth;
            graphics2D.fillRoundRect(n + n5, n2 + n5, n3 - n6, n4 - n6, this.arc, this.arc);
            graphics2D.setStroke(this.stroke);
            if (this.parent.isEnabled()) {
                graphics2D.setColor(this.color);
            }
            graphics2D.drawRoundRect(n + n5, n2 + n5, n3 - n6, n4 - n6, this.arc, this.arc);
        }

        public void setColor(Color color) {
            this.color = color;
            this.parent.repaint();
        }

        @Generated
        public Color getColor() {
            return this.color;
        }
    }

    public static enum IconLocation {
        LEFT,
        RIGHT;

    }

    public static class BreezeRectangleButton
    extends BreezeButton {
        private Color bg = Color.white;

        public BreezeRectangleButton() {
            this.setRoundedBorder(false);
            this.setTextForeground(Color.white);
            this.setMinimumSize(new Dimension(160, 65));
            this.setPreferredSize(new Dimension(160, 65));
            this.setOpaque(true);
        }

        @Override
        protected void mouseEnteredLocal() {
            super.mouseEnteredLocal();
            super.setBackground(this.bg == Color.black ? this.bg.brighter() : this.bg.darker());
        }

        @Override
        protected void mouseExitedLocal() {
            super.mouseExitedLocal();
            super.setBackground(this.bg);
        }

        @Override
        public void setBackground(Color color) {
            this.bg = color;
            super.setBackground(color);
            this.setBorderColor(color);
        }
    }
}

