/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;

public class BreezeCheckBox
extends JCheckBox {
    private Object item;

    public BreezeCheckBox() {
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFontSize(14);
        this.setIcon(this.getIcon("normal.png"));
        this.setSelectedIcon(this.getIcon("selected.png"));
        this.setDisabledIcon(this.getIcon("normal.png"));
        this.setDisabledSelectedIcon(this.getIcon("selected_disabled.png"));
        this.setPressedIcon(this.getIcon("selected.png"));
        this.setRolloverIcon(this.getIcon("hover.png"));
        this.setRolloverSelectedIcon(this.getIcon("selected.png"));
        this.setForeground(BreezeTheme.getInstance().getLabelForeground());
        this.setIconTextGap(10);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public BreezeCheckBox(String string, boolean bl, CheckBoxCallback checkBoxCallback) {
        this(null, string, bl, checkBoxCallback);
    }

    public BreezeCheckBox(String string, String string2, boolean bl, CheckBoxCallback checkBoxCallback) {
        this(string2, bl);
        if (string != null) {
            this.setName(string);
        }
        if (checkBoxCallback != null) {
            this.addCallback(checkBoxCallback);
        }
    }

    public BreezeCheckBox(String string, boolean bl) {
        this();
        this.setText(string);
        this.setSelected(bl);
    }

    public void setItem(Object object) {
        this.item = object;
    }

    public Object getItem() {
        return this.item;
    }

    public void addCallback(CheckBoxCallback checkBoxCallback) {
        this.addItemListener(itemEvent -> checkBoxCallback.changed(this.isSelected()));
    }

    public void setFontSize(int n) {
        this.setFont(new Font(this.getFont().getFontName(), 0, n));
    }

    private ImageIcon getIcon(String string) {
        return new ImageIcon(this.getClass().getResource("/images/checkbox/" + string));
    }

    public void setSelectedAndTrigger(boolean bl) {
        this.setSelected(bl);
        this.fireStateChanged();
    }

    public boolean isVisibleAndSelected() {
        return this.isVisible() && this.isSelected();
    }

    public static interface CheckBoxCallback {
        public void changed(boolean var1);
    }

    public static class ConfirmBreezeCheckBox
    extends BreezeCheckBox {
        private boolean changing = false;

        public ConfirmBreezeCheckBox(String string, boolean bl, BreezeFrame.IFrameColor iFrameColor, String string2, String string3, final CheckBoxCallback checkBoxCallback, final boolean bl3) {
            super(string, bl);
            this.addCallback(bl2 -> {
                boolean bl3;
                if (this.changing) {
                    return;
                }
                boolean bl4 = bl3 ? !bl2 : (bl3 = bl2);
                if (bl3) {
                    BreezeOptionDialog.showDialog(iFrameColor.getFrame(), iFrameColor.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, string2, string3, null, new BreezeActionListener(){
                        final /* synthetic */ ConfirmBreezeCheckBox this$0;
                        {
                            this.this$0 = confirmBreezeCheckBox;
                        }

                        @Override
                        public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                            this.this$0.setValue(checkBoxCallback, bl2);
                        }

                        @Override
                        public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                            this.this$0.setValue(checkBoxCallback, bl3);
                        }
                    });
                } else {
                    this.setValue(checkBoxCallback, bl3);
                }
            });
        }

        private void setValue(CheckBoxCallback checkBoxCallback, boolean bl) {
            this.changing = true;
            checkBoxCallback.changed(bl);
            this.setSelected(bl);
            this.changing = false;
        }
    }

    public static class BreezeCheckBoxWithUsage
    extends JPanel {
        private final BreezeCheckBox checkBox;
        private final BreezeLabel usageLabel = new BreezeLabel("");

        public BreezeCheckBoxWithUsage(String string, String string2, boolean bl, String string3, CheckBoxCallback checkBoxCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.checkBox = new BreezeCheckBox(string, string2, bl, checkBoxCallback);
            this.setUsage(string3);
            this.add((Component)this.checkBox, GridBagHelper.createLeft(0, new Insets(0, 0, 0, 0)));
            this.usageLabel.setFont(new Font(this.usageLabel.getFont().getFontName(), 2, 12));
            this.usageLabel.setForeground(BreezeTheme.getInstance().getLabelForegroundDifuse());
            this.add((Component)this.usageLabel, GridBagHelper.createLeft(1, new Insets(0, 0, 0, 0)));
        }

        public void setUsage(String string) {
            this.usageLabel.setText(string);
            this.usageLabel.setVisible(string.length() > 0);
        }

        public void setSelected(boolean bl) {
            this.checkBox.setSelected(bl);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setValueHeight(int n) {
            this.checkBox.setMinimumSize(new Dimension(6, n));
            this.checkBox.setPreferredSize(new Dimension(59, n));
        }

        public int getValueHeight() {
            return this.checkBox.getPreferredSize().height;
        }

        public void addItemListener(ItemListener itemListener) {
            this.checkBox.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.checkBox.removeItemListener(itemListener);
        }

        public ItemListener[] getItemList() {
            return this.checkBox.getItemListeners();
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.checkBox.setEnabled(bl);
        }

        public void setText(String string) {
            this.checkBox.setText(string);
        }

        public String getText() {
            return this.checkBox.getText();
        }

        public boolean isVisibleAndSelected() {
            return this.isVisible() && this.checkBox.isVisibleAndSelected();
        }

        @Override
        public String getName() {
            return this.checkBox.getName();
        }
    }
}

