/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeFieldInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;

public class BreezeCheckBoxInputField
extends JPanel
implements BreezeFieldInterface {
    private final BreezeCheckBox checkBox;
    private final BreezeLabel descLabel = new BreezeLabel("Name");
    private final BreezeLabel usageLabel = new BreezeLabel("");
    private BreezeInputFieldHelper.Format format = BreezeInputFieldHelper.Format.OneRow;

    public BreezeCheckBoxInputField(String string, boolean bl, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
        this(string, bl, "", BreezeInputFieldHelper.Format.OneRow, checkBoxCallback);
    }

    public BreezeCheckBoxInputField(String string, boolean bl, String string2, BreezeInputFieldHelper.Format format, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
        this.descLabel.setText(string);
        this.usageLabel.setText(string2);
        this.checkBox = new BreezeCheckBox("", bl, checkBoxCallback);
        this.setFormat(format);
    }

    @Override
    public void setFormat(BreezeInputFieldHelper.Format format) {
        this.format = format;
        BreezeInputFieldHelper.format(this, this.descLabel, this.checkBox, null, this.usageLabel, format);
    }

    public BreezeInputFieldHelper.Format getFormat() {
        return this.format;
    }

    public void reformat() {
        this.setFormat(this.format);
        this.revalidate();
        this.repaint();
    }

    public void setUsage(String string) {
        this.usageLabel.setText(string);
    }

    public void setLabelForeground(Color color) {
        this.descLabel.setForeground(color);
    }

    public Color getLabelForeground() {
        return this.descLabel.getForeground();
    }

    public void setDescription(String string) {
        this.descLabel.setText(string);
    }

    public String getDescription() {
        return this.descLabel.getText();
    }

    @Override
    public void setValue(Object object) {
    }

    public void setSelected(boolean bl) {
        this.checkBox.setSelected(bl);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setValueHeight(int n) {
        this.checkBox.setMinimumSize(new Dimension(6, n));
        this.checkBox.setPreferredSize(new Dimension(59, n));
    }

    public int getValueHeight() {
        return this.checkBox.getPreferredSize().height;
    }

    public void addItemListener(ItemListener itemListener) {
        this.checkBox.addItemListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.checkBox.removeItemListener(itemListener);
    }

    public ItemListener[] getItemList() {
        return this.checkBox.getItemListeners();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.checkBox.setEnabled(bl);
    }

    public BreezeLabel getLabel() {
        return this.descLabel;
    }

    @Override
    public void setLabelWidth(int n) {
        this.descLabel.setPreferredSize(new Dimension(n, this.checkBox.getPreferredSize().height));
    }

    @Override
    public void setValueWidth(int n) {
        this.checkBox.setPreferredSize(new Dimension(n, this.checkBox.getPreferredSize().height));
    }

    @Override
    public void setUnitLabelWidth(int n) {
    }
}

