/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;

public class BreezeCheckedTree
extends BreezeTree {
    private static final Icon triStateIcon = new ImageIcon(Objects.requireNonNull(BreezeCheckedTree.class.getResource("/images/checkbox/tristate.png")));
    private static final Icon normalIcon = new ImageIcon(Objects.requireNonNull(BreezeCheckedTree.class.getResource("/images/checkbox/normal.png")));
    private static final Icon checkedIcon = new ImageIcon(Objects.requireNonNull(BreezeCheckedTree.class.getResource("/images/checkbox/selected.png")));
    private static final long serialVersionUID = -4194122328392241790L;
    BreezeCheckedTree selfPointer = this;
    HashMap<TreePath, CheckedNode> nodesCheckingState;
    HashSet<TreePath> checkedPaths = new HashSet();
    protected EventListenerList listenerList = new EventListenerList();

    public void addCheckChangeEventListener(CheckChangeEventListener checkChangeEventListener) {
        this.listenerList.add(CheckChangeEventListener.class, checkChangeEventListener);
    }

    public void removeCheckChangeEventListener(CheckChangeEventListener checkChangeEventListener) {
        this.listenerList.remove(CheckChangeEventListener.class, checkChangeEventListener);
    }

    void fireCheckChangeEvent(CheckChangeEvent checkChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CheckChangeEventListener.class) continue;
            ((CheckChangeEventListener)objectArray[i + 1]).checkStateChanged(checkChangeEvent);
        }
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.resetCheckingState();
    }

    public TreePath[] getCheckedPaths() {
        return this.checkedPaths.toArray(new TreePath[0]);
    }

    public boolean isSelectedPartially(TreePath treePath) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        return checkedNode.isSelected && checkedNode.hasChildren && !checkedNode.allChildrenSelected;
    }

    private void resetCheckingState() {
        this.nodesCheckingState = new HashMap();
        this.checkedPaths = new HashSet();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.addSubtreeToCheckingStateTracking(defaultMutableTreeNode);
    }

    private void addSubtreeToCheckingStateTracking(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getPath();
        TreePath treePath = new TreePath(objectArray);
        CheckedNode checkedNode = new CheckedNode(false, defaultMutableTreeNode.getChildCount() > 0, false, false);
        this.nodesCheckingState.put(treePath, checkedNode);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.addSubtreeToCheckingStateTracking((DefaultMutableTreeNode)treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i)).getLastPathComponent());
        }
    }

    public BreezeCheckedTree() {
        this.setToggleClickCount(0);
        CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer();
        this.setCellRenderer(checkBoxCellRenderer);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -8190634240451667286L;

            @Override
            public void setSelectionPath(TreePath treePath) {
            }

            @Override
            public void addSelectionPath(TreePath treePath) {
            }

            @Override
            public void removeSelectionPath(TreePath treePath) {
            }

            @Override
            public void setSelectionPaths(TreePath[] treePathArray) {
            }
        };
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = BreezeCheckedTree.this.selfPointer.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                boolean bl = !BreezeCheckedTree.this.nodesCheckingState.get((Object)treePath).isSelected;
                BreezeCheckedTree.this.checkSubTree(treePath, bl);
                BreezeCheckedTree.this.updatePredecessorsWithCheckMode(treePath);
                BreezeCheckedTree.this.fireCheckChangeEvent(new CheckChangeEvent(new Object()));
                BreezeCheckedTree.this.selfPointer.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.setSelectionModel(defaultTreeSelectionModel);
    }

    protected void updatePredecessorsWithCheckMode(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null) {
            return;
        }
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath2);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
        checkedNode.allChildrenSelected = true;
        checkedNode.isSelected = true;
        checkedNode.someChildrenSelected = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreePath treePath3 = treePath2.pathByAddingChild(defaultMutableTreeNode.getChildAt(i));
            CheckedNode checkedNode2 = this.nodesCheckingState.get(treePath3);
            if (!checkedNode2.allChildrenSelected) {
                checkedNode.allChildrenSelected = false;
            }
            if (checkedNode2.isSelected || checkedNode2.someChildrenSelected) {
                checkedNode.someChildrenSelected = true;
                continue;
            }
            checkedNode.isSelected = false;
        }
        if (checkedNode.isSelected) {
            this.checkedPaths.add(treePath2);
        } else {
            this.checkedPaths.remove(treePath2);
        }
        this.updatePredecessorsWithCheckMode(treePath2);
    }

    protected void checkSubTree(TreePath treePath, boolean bl) {
        CheckedNode checkedNode = this.nodesCheckingState.get(treePath);
        checkedNode.isSelected = bl;
        checkedNode.someChildrenSelected = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.checkSubTree(treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i)), bl);
        }
        checkedNode.allChildrenSelected = bl;
        if (bl) {
            this.checkedPaths.add(treePath);
        } else {
            this.checkedPaths.remove(treePath);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(500, 500);
        jFrame.getContentPane().setLayout(new BorderLayout());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getSize().width / 2, dimension.height / 2 - jFrame.getSize().height / 2);
        BreezeCheckedTree breezeCheckedTree = new BreezeCheckedTree();
        jFrame.getContentPane().add((Component)((Object)breezeCheckedTree));
        breezeCheckedTree.addCheckChangeEventListener(checkChangeEvent -> {
            TreePath[] treePathArray;
            System.out.println("event");
            for (TreePath treePath : treePathArray = breezeCheckedTree.getCheckedPaths()) {
                for (Object object : treePath.getPath()) {
                    System.out.print(String.valueOf(object) + ",");
                }
                System.out.println();
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public static interface CheckChangeEventListener
    extends EventListener {
        public void checkStateChanged(CheckChangeEvent var1);
    }

    public static class CheckChangeEvent
    extends EventObject {
        private static final long serialVersionUID = -8100230309044193368L;

        public CheckChangeEvent(Object object) {
            super(object);
        }
    }

    private static class CheckedNode {
        boolean isSelected;
        boolean hasChildren;
        boolean allChildrenSelected;
        boolean someChildrenSelected;

        public CheckedNode(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.isSelected = bl;
            this.hasChildren = bl2;
            this.allChildrenSelected = bl3;
            this.someChildrenSelected = bl4;
        }
    }

    private class CheckBoxCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7341833835878991719L;
        JCheckBox checkBox;

        public CheckBoxCellRenderer() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox(normalIcon);
            this.checkBox.setFont(new Font(this.getFont().getFontName(), 0, 18));
            this.checkBox.setForeground(BreezeTheme.getInstance().getLabelForeground());
            this.add((Component)this.checkBox, "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            CheckedNode checkedNode = BreezeCheckedTree.this.nodesCheckingState.get(treePath);
            if (checkedNode == null) {
                return this;
            }
            if (checkedNode.someChildrenSelected && !checkedNode.allChildrenSelected) {
                this.checkBox.setIcon(triStateIcon);
            } else {
                this.checkBox.setIcon(checkedNode.isSelected ? checkedIcon : normalIcon);
                this.checkBox.setSelected(checkedNode.isSelected);
            }
            this.checkBox.setText(object2.toString());
            this.checkBox.setOpaque(checkedNode.isSelected && checkedNode.hasChildren && !checkedNode.allChildrenSelected);
            return this;
        }
    }
}

