/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import lombok.Generated;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeDateChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.main.Evince;

public class BreezeColorChooser
extends JComboBox<ColorHolder> {
    private final ColorHolder colorHolder = new ColorHolder();
    private ColorPopup colorPopup;

    public BreezeColorChooser(boolean bl) {
        this.setRenderer(new ColorCellRenderer(this.colorHolder));
        this.addItem(this.colorHolder);
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (bl) {
            this.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setUI(new BreezeComboBox.BreezeComboBoxUI(bl){

            @Override
            protected ComboPopup createPopup() {
                BreezeColorChooser.this.colorPopup = new ColorPopup(this.comboBox, null);
                return BreezeColorChooser.this.colorPopup;
            }
        });
    }

    @Override
    public void setSelectedItem(Object object) {
        this.colorHolder.setColor((Color)object);
        this.fireActionEvent();
    }

    public Color getSelectedColor() {
        return this.colorHolder.getColor();
    }

    public void togglePopup() {
        this.colorPopup.togglePopup();
    }

    public static void main(String[] stringArray) {
        Evince.setLookAndFeel();
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new FlowLayout());
        container.add(new JLabel("Date:"));
        BreezeColorChooser breezeColorChooser = new BreezeColorChooser(true);
        container.add(breezeColorChooser);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setSize(400, 100);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static class ColorHolder {
        private Color color;

        @Generated
        public void setColor(Color color) {
            this.color = color;
        }

        @Generated
        public Color getColor() {
            return this.color;
        }

        @Generated
        public ColorHolder() {
        }
    }

    public static class ColorCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        private final ColorHolder colorHolder;

        public ColorCellRenderer(ColorHolder colorHolder) {
            super(5, 40);
            this.colorHolder = colorHolder;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            int n = this.getHeight() - 14;
            int n2 = Math.min(20, n);
            graphics2D.setColor(this.colorHolder.getColor());
            graphics2D.fillRect(7, 7, n2, n);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(7, 7, n2, n);
        }

        @Override
        protected String getToolTip(Object object) {
            return null;
        }
    }

    public static class ColorPopup
    extends BreezeDateChooser.BasicPopup {
        public ColorPopup(final JComponent jComponent, final ColorCallback colorCallback) {
            super(jComponent);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBackground(BreezeTheme.getInstance().getDialogBackground());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setOpaque(false);
            Dimension dimension = new Dimension(20, 20);
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                int n2 = 0;
                while (n2 < 6) {
                    final JPanel jPanel3 = new JPanel();
                    jPanel3.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                    jPanel3.setCursor(Cursor.getPredefinedCursor(12));
                    jPanel3.setPreferredSize(dimension);
                    jPanel3.setBackground(RtPerfectSpread.generateColor(n));
                    jPanel3.addMouseListener(new MouseAdapter(this){
                        final /* synthetic */ ColorPopup this$0;
                        {
                            this.this$0 = colorPopup;
                        }

                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                            if (jComponent instanceof JComboBox) {
                                JComboBox jComboBox = (JComboBox)jComponent;
                                jComboBox.setSelectedItem(jPanel3.getBackground());
                            } else {
                                jComponent.setBackground(jPanel3.getBackground());
                            }
                            if (colorCallback != null) {
                                colorCallback.onValue(jPanel3.getBackground());
                            }
                            this.this$0.hide();
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                            jPanel3.setBorder(BorderFactory.createLineBorder(Color.white, 1));
                        }

                        @Override
                        public void mouseExited(MouseEvent mouseEvent) {
                            jPanel3.setBorder(BorderFactory.createLineBorder(Color.black, 1));
                        }
                    });
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = n2++;
                    gridBagConstraints.gridy = i;
                    gridBagConstraints.insets = new Insets(3, 3, 3, 3);
                    jPanel2.add((Component)jPanel3, gridBagConstraints);
                    ++n;
                }
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            jPanel.add((Component)new BreezeLabel("Colors", false, 14), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 20, 10, 20);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)new BreezeSeparator(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            BreezeLabel breezeLabel = new BreezeLabel("More colors", false, 14);
            breezeLabel.setCursor(Cursor.getPredefinedCursor(12));
            breezeLabel.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ColorPopup this$0;
                {
                    this.this$0 = colorPopup;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$0.hide();
                    if (jComponent instanceof BreezeColorChooser) {
                        BreezeColorChooser breezeColorChooser = (BreezeColorChooser)jComponent;
                        Color color = JColorChooser.showDialog(BreezeFrame.getInstance(), "Select color", breezeColorChooser.getSelectedColor());
                        if (color != null) {
                            breezeColorChooser.setSelectedItem(color);
                            if (colorCallback != null) {
                                colorCallback.onValue(color);
                            }
                        }
                    } else {
                        Color color = JColorChooser.showDialog(BreezeFrame.getInstance(), "Select color", jComponent.getBackground());
                        if (color != null) {
                            jComponent.setBackground(color);
                            if (colorCallback != null) {
                                colorCallback.onValue(color);
                            }
                        }
                    }
                }
            });
            jPanel.add((Component)breezeLabel, gridBagConstraints);
            this.popup.add((Component)jPanel, "Center");
        }

        @Override
        public void show() {
            this.popup.show(this.component, 0, this.component.getHeight());
        }

        public static interface ColorCallback {
            public void onValue(Color var1);
        }
    }

    public static class ColorChoosePanel
    extends JPanel {
        public ColorChoosePanel(Color color, final ColorPopup.ColorCallback colorCallback) {
            this.setBackground(color);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ColorChoosePanel this$0;
                {
                    this.this$0 = colorChoosePanel;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (this.this$0.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        new ColorPopup(this.this$0, colorCallback).show();
                    }
                }
            });
        }
    }
}

