/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeArrowButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.common.error.Logg;

public class BreezeComboBox
extends JComboBox {
    public static final Color selectionBackground = new Color(102, 102, 102);

    public BreezeComboBox() {
        this.init(true, 5);
    }

    public BreezeComboBox(boolean bl) {
        this.init(bl, 5);
    }

    public BreezeComboBox(boolean bl, int n) {
        this.init(bl, n);
    }

    public void addSeparator() {
        this.addItem(new SeparatorClass());
    }

    public boolean isRowSeparator(int n) {
        return this.getItemAt(n) instanceof SeparatorClass;
    }

    public void setCallback(ItemCallback itemCallback) {
        this.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                itemCallback.onItem(this.getSelectedItem());
            }
        });
    }

    public void setSelectedIndexAndTrigger(int n) {
        if (this.getSelectedIndex() != n) {
            this.setSelectedIndex(n);
        } else {
            this.triggerItem(this.getSelectedItem());
        }
    }

    public void setSelectedItemAndTrigger(Object object) {
        if (!this.isSelectedItem(object)) {
            this.setSelectedItem(object);
        } else {
            this.triggerItem(object);
        }
    }

    private void triggerItem(Object object) {
        ItemEvent itemEvent = new ItemEvent(this, 0, object, 1);
        for (ItemListener itemListener : this.getItemListeners()) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    public boolean setSelectedString(String string) {
        String string2 = string.trim();
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).toString().equalsIgnoreCase(string2)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public boolean isSelectedItem(Object object) {
        return this.getSelectedItem() != null && this.getSelectedItem().equals(object);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSelectedItem());
    }

    public void addItem(Object object) {
        try {
            super.addItem(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addItems(Object[] objectArray) {
        for (Object object : objectArray) {
            this.addItem(object);
        }
    }

    public void addItems(List list) {
        for (Object e : list) {
            this.addItem(e);
        }
    }

    public boolean hasItem(Object object) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object getValue() {
        Object object = this.getSelectedItem();
        if (object instanceof SeparatorClass) {
            return null;
        }
        return object;
    }

    private void init(boolean bl, int n) {
        this.setFont(new Font("Tahoma", 0, 14));
        this.setRequestFocusEnabled(false);
        this.setPreferredSize(new Dimension(34, 25));
        this.setRenderer(new ComboBoxListCellRenderer(n));
        this.setCustomizedUI(bl);
        this.addActionListener(new SeparatorComboListener(this));
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setOpaque(false);
        this.setBackground(selectionBackground);
        this.setForeground(Color.white);
        Component component = this.getEditor().getEditorComponent();
        component.setForeground(breezeTheme.getLabelForeground());
        component.setBackground(breezeTheme.getSettingPanelBackground());
        if (component instanceof JTextField) {
            JTextField jTextField = (JTextField)component;
            jTextField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jTextField.setCaretColor(breezeTheme.getLabelForeground());
        }
        this.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundMoreDifuse()));
    }

    public void requestFocusAndSelectAll() {
        this.getEditor().selectAll();
        this.requestFocus();
    }

    private void setCustomizedUI(boolean bl) {
        this.setUI(new BreezeComboBoxUI(bl));
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        Component component = this.getEditor().getEditorComponent();
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (bl) {
            component.setBackground(breezeTheme.getPanelBackground());
        } else {
            component.setBackground(breezeTheme.getSettingPanelBackground());
        }
    }

    public void setSelectedIndexWithoutListeners(int n) {
        this.doWithoutListeners(() -> this.setSelectedIndex(n));
    }

    public void setSelectedItemWithoutListeners(Object object) {
        this.doWithoutListeners(() -> this.setSelectedItem(object));
    }

    public void doWithoutListeners(Runnable runnable) {
        ItemListener[] itemListenerArray = this.removeAllItemListeners();
        try {
            runnable.run();
        }
        finally {
            this.addItemListeners(itemListenerArray);
        }
    }

    public ItemListener[] removeAllItemListeners() {
        ItemListener[] itemListenerArray = this.getItemListeners();
        if (itemListenerArray != null) {
            for (ItemListener itemListener : itemListenerArray) {
                this.removeItemListener(itemListener);
            }
        }
        return itemListenerArray;
    }

    public void addItemListeners(ItemListener[] itemListenerArray) {
        if (itemListenerArray != null) {
            for (ItemListener itemListener : itemListenerArray) {
                this.addItemListener(itemListener);
            }
        }
    }

    public void setNoItemsText(String string) {
        ListCellRenderer listCellRenderer = this.getRenderer();
        if (listCellRenderer instanceof ComboBoxListCellRenderer) {
            ComboBoxListCellRenderer comboBoxListCellRenderer = (ComboBoxListCellRenderer)listCellRenderer;
            comboBoxListCellRenderer.setNoItemsText(this, string);
        }
    }

    public void setItems(List list) {
        this.removeAllItems();
        if (list != null) {
            for (Object e : list) {
                this.addItem(e);
            }
        }
    }

    public static class SeparatorClass {
    }

    public static interface ItemCallback<T> {
        public void onItem(T var1);
    }

    public static class ComboBoxListCellRenderer
    extends DefaultListCellRenderer {
        public final JSeparator separator = new JSeparator(0);
        private final int insets;
        private final int leftinsets;
        private BreezeComboBox comboBox;
        private String noItemsText = "No items available";

        public ComboBoxListCellRenderer() {
            this(5);
        }

        public ComboBoxListCellRenderer(int n) {
            this(n, n > n ? n : 5);
        }

        public ComboBoxListCellRenderer(int n, int n2) {
            this.insets = n;
            this.leftinsets = n2;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SeparatorClass) {
                return this.separator;
            }
            if (this.comboBox != null && this.comboBox.getItemCount() == 0 && n == -1) {
                this.setText(this.noItemsText);
                return this;
            }
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setBorder(BorderFactory.createEmptyBorder(this.insets, this.leftinsets, this.insets, this.insets));
            jList.setSelectionBackground(selectionBackground);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            jList.setSelectionForeground(Color.white);
            jList.setBackground(breezeTheme.getPanelBackground());
            jList.setForeground(breezeTheme.getLabelForeground());
            if (object != null) {
                jList.setToolTipText(this.getToolTip(object));
            }
            return jLabel;
        }

        protected String getToolTip(Object object) {
            return object.toString();
        }

        public void setNoItemsText(BreezeComboBox breezeComboBox, String string) {
            this.comboBox = breezeComboBox;
            this.noItemsText = string;
        }
    }

    public static class SeparatorComboListener
    implements ActionListener {
        protected BreezeComboBox comboBox;
        protected Object currentItem;
        private final JList dummyList = new JList();

        public SeparatorComboListener(BreezeComboBox breezeComboBox) {
            this.comboBox = breezeComboBox;
            this.currentItem = breezeComboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.comboBox.getSelectedItem();
            if (object != null) {
                if (object instanceof SeparatorClass) {
                    this.comboBox.setSelectedItem(this.currentItem);
                } else {
                    this.currentItem = object;
                    this.comboBox.setToolTipText(this.getTooltipText(object));
                }
            }
        }

        private String getTooltipText(Object object) {
            try {
                Component component;
                ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
                if (listCellRenderer != null && (component = listCellRenderer.getListCellRendererComponent(this.dummyList, object, 0, true, true)) instanceof JLabel) {
                    return ((JLabel)component).getText();
                }
            }
            catch (Exception exception) {
                Logg.error((String)("Could not get combo box tooltip text: " + exception.getMessage()), (Object[])new Object[0]);
            }
            return object.toString();
        }
    }

    public static class BreezeComboBoxUI
    extends BasicComboBoxUI {
        private final boolean showArrowButton;

        public BreezeComboBoxUI(boolean bl) {
            this.showArrowButton = bl;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            try {
                Rectangle rectangle = this.rectangleForCurrentValue();
                this.paintCurrentValueBackground(graphics, rectangle, true);
                this.paintCurrentValue(graphics, rectangle, true);
            }
            catch (NullPointerException nullPointerException) {
                Logg.error((String)"Error painting combobox ui", (Throwable)nullPointerException);
            }
        }

        @Override
        public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
            ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            if (this.comboBox.isEnabled()) {
                component.setBackground(BreezeTheme.getInstance().getPanelBackground());
                component.setForeground(BreezeTheme.getInstance().getLabelForeground());
            } else {
                component.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
                component.setForeground(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
            }
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
            }
            component.setBounds(rectangle);
            component.setFont(this.comboBox.getFont());
            boolean bl2 = false;
            if (component instanceof JPanel) {
                bl2 = true;
            }
            this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        }

        @Override
        public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
            Color color = graphics.getColor();
            if (this.comboBox.isEnabled()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }

        @Override
        protected final JButton createArrowButton() {
            if (this.showArrowButton) {
                return new BreezeArrowButton(this.comboBox);
            }
            return new JButton(){

                @Override
                public int getWidth() {
                    return 0;
                }
            };
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = (BasicComboPopup)super.createPopup();
            Border border = BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse(), 1);
            basicComboPopup.setBorder(border);
            return basicComboPopup;
        }

        @Override
        public Dimension getMinimumSize(JComponent jComponent) {
            try {
                return super.getMinimumSize(jComponent);
            }
            catch (Exception exception) {
                return new Dimension(200, 30);
            }
        }
    }

    public static class FormatStringCellRenderer
    extends ComboBoxListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, (Object)StringHelper.formatLabel(object.toString()), n, bl, bl2);
        }
    }

    public static interface LoadingCallback<T> {
        public void loadItems(List<T> var1);

        public Object getSelectedItem();
    }
}

