/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeFieldInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.map.common.SwingTimer;

public class BreezeComboBoxInputField<T>
extends JPanel
implements BreezeFieldInterface {
    private final BreezeComboBox comboBox = new BreezeComboBox();
    private final BreezeLabel descLabel = new BreezeLabel("Name");
    private final BreezeLabel unitLabel = new BreezeLabel("mm");
    private final BreezeLabel usageLabel = new BreezeLabel("");
    private BreezeInputFieldHelper.Format format = BreezeInputFieldHelper.Format.OneRow;

    public BreezeComboBoxInputField() {
        this("");
    }

    public BreezeComboBoxInputField(String string) {
        this(string, "", BreezeInputFieldHelper.Format.OneRow);
    }

    public BreezeComboBoxInputField(String string, String string2, BreezeInputFieldHelper.Format format) {
        this.descLabel.setText(string);
        this.setUnit(string2);
        this.setFormat(format);
    }

    public BreezeComboBoxInputField(String string, List<T> list, T t, BreezeInputFieldHelper.Format format) {
        this(string, "", format);
        for (T t2 : list) {
            this.addItem(t2);
        }
        this.setSelectedItem(t);
    }

    public BreezeComboBoxInputField(String string, List<T> list, T t, SelectionChangedListener<T> selectionChangedListener) {
        this(string, list, t, selectionChangedListener, BreezeInputFieldHelper.Format.TwoRows);
    }

    public BreezeComboBoxInputField(String string, List<T> list, T t, SelectionChangedListener<T> selectionChangedListener, BreezeInputFieldHelper.Format format) {
        this(string, list, t, selectionChangedListener, format, false);
    }

    public BreezeComboBoxInputField(String string, List<T> list, T t, SelectionChangedListener<T> selectionChangedListener, BreezeInputFieldHelper.Format format, boolean bl) {
        this(string, list, t, format);
        this.setSelectedItemAndTriggerIfNoDefault(t, bl ? selectionChangedListener : null);
        this.setChangedListener(selectionChangedListener);
    }

    public void setChangedListener(SelectionChangedListener<T> selectionChangedListener) {
        this.comboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.triggerItem(selectionChangedListener, this.getSelectedItem());
            }
        });
    }

    protected void setSelectedItemAndTriggerIfNoDefault(T t, SelectionChangedListener<T> selectionChangedListener) {
        this.setSelectedItem(t);
        if (this.getSelectedItem() != null && !this.getSelectedItem().equals(t)) {
            this.triggerItem(selectionChangedListener, this.getSelectedItem());
        }
    }

    private void triggerItem(SelectionChangedListener<T> selectionChangedListener, Object object) {
        if (!(object instanceof Loading.LoadingItem) && selectionChangedListener != null) {
            selectionChangedListener.selected(object);
        }
    }

    @Override
    public void setFormat(BreezeInputFieldHelper.Format format) {
        this.format = format;
        BreezeInputFieldHelper.format(this, this.descLabel, this.comboBox, this.unitLabel, this.usageLabel, format);
    }

    public BreezeInputFieldHelper.Format getFormat() {
        return this.format;
    }

    public void reformat() {
        this.setFormat(this.format);
        this.revalidate();
        this.repaint();
    }

    public void setLabelForeground(Color color) {
        this.descLabel.setForeground(color);
    }

    public Color getLabelForeground() {
        return this.descLabel.getForeground();
    }

    public void setDescription(String string) {
        this.descLabel.setText(string);
    }

    public String getDescription() {
        return this.descLabel.getText();
    }

    public void setSelectedIndex(int n) {
        if (n < this.comboBox.getItemCount()) {
            this.comboBox.setSelectedIndex(n);
        }
    }

    @Override
    public void setValue(Object object) {
        this.setSelectedItem(object);
    }

    public void setSelectedItem(T t) {
        this.comboBox.setSelectedItem(t);
    }

    public void setSelectedString(String string) {
        this.comboBox.setSelectedString(string);
    }

    public void setSelectedIndexAndTrigger(int n) {
        this.comboBox.setSelectedIndexAndTrigger(n);
    }

    public void setSelectedItemAndTrigger(T t) {
        this.comboBox.setSelectedItemAndTrigger(t);
    }

    public void setSelectedIndexWithoutListeners(int n) {
        this.comboBox.setSelectedIndexWithoutListeners(n);
    }

    public void setSelectedItemWithoutListeners(Object object) {
        this.comboBox.setSelectedItemWithoutListeners(object);
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public boolean isSelectedItem(T t) {
        return this.comboBox.isSelectedItem(t);
    }

    public T getValue() {
        return this.getSelectedItem();
    }

    public T getSelectedItem() {
        return (T)this.comboBox.getSelectedItem();
    }

    public void addItem(T t) {
        this.comboBox.addItem(t);
    }

    public void addItems(T[] TArray) {
        this.comboBox.addItems(TArray);
    }

    public void setList(Iterable<? extends T> iterable) {
        this.removeAllItems();
        this.addList(iterable);
    }

    public void addList(Iterable<? extends T> iterable) {
        for (T t : iterable) {
            this.addItem(t);
        }
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.comboBox.setModel(comboBoxModel);
    }

    public void setValueHeight(int n) {
        this.comboBox.setMinimumSize(new Dimension(6, n));
        this.comboBox.setPreferredSize(new Dimension(59, n));
    }

    public int getValueHeight() {
        return this.comboBox.getPreferredSize().height;
    }

    public void setUnit(String string) {
        this.unitLabel.setText(string);
        this.unitLabel.setVisible(string.length() > 0);
    }

    public String getUnit() {
        return this.unitLabel.getText();
    }

    public void setEditable(boolean bl) {
        this.comboBox.setEditable(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.comboBox.setEnabled(bl);
        this.descLabel.setEnabled(bl);
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public void addSeparator() {
        this.comboBox.addSeparator();
    }

    public void setRenderer(BreezeComboBox.ComboBoxListCellRenderer comboBoxListCellRenderer) {
        this.comboBox.setRenderer(comboBoxListCellRenderer);
    }

    public BreezeLabel getLabel() {
        return this.descLabel;
    }

    public BreezeLabel getUnitLabel() {
        return this.unitLabel;
    }

    public BreezeComboBox getComboBox() {
        return this.comboBox;
    }

    public void setItems(List list) {
        this.comboBox.setItems(list);
    }

    @Override
    public void setLabelWidth(int n) {
        this.descLabel.setPreferredSize(new Dimension(n, this.comboBox.getPreferredSize().height));
    }

    @Override
    public void setValueWidth(int n) {
        this.comboBox.setPreferredSize(new Dimension(n, this.comboBox.getPreferredSize().height));
    }

    @Override
    public void setUnitLabelWidth(int n) {
        this.unitLabel.setPreferredSize(new Dimension(n, this.comboBox.getPreferredSize().height));
    }

    public void setUsage(String string) {
        this.usageLabel.setText(string);
    }

    public void removeAllItems() {
        try {
            this.comboBox.removeAllItems();
        }
        catch (Exception exception) {
            System.err.println("Cannot clear combo box: " + exception.getMessage());
        }
    }

    public T getItemAt(int n) {
        return (T)this.comboBox.getItemAt(n);
    }

    public boolean hasValue() {
        T t = this.getSelectedItem();
        return t != null && t.toString().length() > 0;
    }

    public void setLabelFontSize(int n) {
        this.descLabel.setFontSize(n);
    }

    public ItemListener[] removeAllItemListeners() {
        return this.comboBox.removeAllItemListeners();
    }

    public void addItemListeners(ItemListener[] itemListenerArray) {
        this.comboBox.addItemListeners(itemListenerArray);
    }

    public static interface SelectionChangedListener<T> {
        public void selected(T var1);
    }

    public static class Loading<T>
    extends BreezeComboBoxInputField {
        private final SelectionChangedListener<T> changedListener;
        private final String loadText;
        private final BreezeComboBox.LoadingCallback callback;
        private static final ExecutorService executor = Executors.newSingleThreadExecutor();

        public Loading(String string, SelectionChangedListener<T> selectionChangedListener, String string2, BreezeComboBox.LoadingCallback loadingCallback) {
            super(string, new ArrayList(), null, selectionChangedListener);
            this.changedListener = selectionChangedListener;
            this.loadText = string2;
            this.callback = loadingCallback;
            this.addItem(new LoadingItem(this.getComboBox(), string2));
            this.setEnabled(false);
            this.getComboBox().setNoItemsText("No " + string2 + " available");
        }

        public void reload() {
            BreezeComboBox breezeComboBox = this.getComboBox();
            breezeComboBox.removeAllItems();
            LoadingItem loadingItem = new LoadingItem(breezeComboBox, this.loadText);
            this.addItem(loadingItem);
            this.setEnabled(false);
            if (!executor.isShutdown()) {
                executor.submit(() -> {
                    try {
                        breezeComboBox.doWithoutListeners(() -> {
                            ArrayList arrayList = new ArrayList();
                            this.callback.loadItems(arrayList);
                            breezeComboBox.removeAllItems();
                            for (Object e : arrayList) {
                                this.addItem(e);
                            }
                        });
                        this.setSelectedItemAndTriggerIfNoDefault(this.callback.getSelectedItem(), this.changedListener);
                        this.setEnabled(breezeComboBox.getItemCount() > 0);
                    }
                    catch (Throwable throwable) {
                        loadingItem.failed();
                        breezeComboBox.repaint();
                        throw throwable;
                    }
                    finally {
                        loadingItem.finish();
                    }
                });
            }
        }

        public static class LoadingItem {
            private final String text;
            private final SwingTimer timer;
            private int index = 0;
            private boolean failed = false;

            public LoadingItem(BreezeComboBox breezeComboBox, String string) {
                this.text = string;
                this.timer = new SwingTimer(300, actionEvent -> {
                    breezeComboBox.repaint();
                    if (++this.index > 5) {
                        this.index = 0;
                    }
                }, true);
                this.timer.start();
            }

            public void failed() {
                this.failed = true;
            }

            public void finish() {
                this.timer.stop();
                this.index = 0;
            }

            public String toString() {
                if (this.failed) {
                    return "Failed scanning for " + this.text + ", please try again";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(".".repeat(Math.max(0, this.index)));
                return "Scanning for " + this.text + String.valueOf(stringBuilder);
            }
        }
    }
}

