/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import se.prediktera.map.main.Evince;

public class BreezeDateChooser
extends JComboBox {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy");

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        this.dateFormat = simpleDateFormat;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.removeAllItems();
        this.addItem(object);
        super.setSelectedItem(object);
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicComboBoxUI(){

            @Override
            protected ComboPopup createPopup() {
                return new DatePopup(this.comboBox);
            }
        });
    }

    public static void main(String[] stringArray) {
        Evince.setLookAndFeel();
        JFrame jFrame = new JFrame();
        Container container = jFrame.getContentPane();
        container.setLayout(new FlowLayout());
        container.add(new JLabel("Date:"));
        BreezeDateChooser breezeDateChooser = new BreezeDateChooser();
        container.add(breezeDateChooser);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setSize(200, 100);
        jFrame.setVisible(true);
    }

    public static abstract class BasicPopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComponent component;
        protected JPopupMenu popup;
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected JList list = new JList();
        protected boolean mouseInside = false;
        protected boolean hideNext = false;

        public BasicPopup(JComponent jComponent) {
            this.component = jComponent;
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
        }

        @Override
        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        @Override
        public MouseListener getMouseListener() {
            return this;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        @Override
        public KeyListener getKeyListener() {
            return this;
        }

        @Override
        public boolean isVisible() {
            return this.popup.isVisible();
        }

        @Override
        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComboBox jComboBox;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!this.component.isEnabled()) {
                return;
            }
            JComponent jComponent = this.component;
            if (jComponent instanceof JComboBox && (jComboBox = (JComboBox)jComponent).isEditable()) {
                jComboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.component.requestFocus();
            }
            this.togglePopup();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseInside = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseInside = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.hideNext = this.mouseInside;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }
    }

    private class DatePopup
    extends BasicPopup {
        private final JLabel monthLabel;
        private JPanel days;
        private final Calendar calendar;
        private final SimpleDateFormat monthFormat;

        public DatePopup(JComboBox jComboBox) {
            super(jComboBox);
            this.days = null;
            this.calendar = Calendar.getInstance();
            this.monthFormat = new SimpleDateFormat("MMM yyyy");
            int n = this.calendar.get(1);
            int n2 = this.calendar.get(2);
            int n3 = this.calendar.get(5);
            String string = n3 + "/" + n2 + "/" + n;
            jComboBox.addItem(string);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBackground(this.background);
            jPanel.setOpaque(true);
            JLabel jLabel = this.createUpdateButton(1, -1);
            jLabel.setText("<<");
            jLabel.setToolTipText("Previous Year");
            jPanel.add(Box.createHorizontalStrut(12));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(12));
            jLabel = this.createUpdateButton(2, -1);
            jLabel.setText("<");
            jLabel.setToolTipText("Previous Month");
            jPanel.add(jLabel);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.monthLabel);
            jPanel.add(Box.createHorizontalGlue());
            jLabel = this.createUpdateButton(2, 1);
            jLabel.setText(">");
            jLabel.setToolTipText("Next Month");
            jPanel.add(jLabel);
            jLabel = this.createUpdateButton(1, 1);
            jLabel.setText(">>");
            jLabel.setToolTipText("Next Year");
            jPanel.add(Box.createHorizontalStrut(12));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(12));
            this.popup.add("North", jPanel);
        }

        @Override
        public void show() {
            try {
                this.calendar.setTime(BreezeDateChooser.this.dateFormat.parse(((JComboBox)this.component).getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.component, 0, this.component.getHeight());
        }

        protected JLabel createUpdateButton(final int n, final int n2) {
            final JLabel jLabel = new JLabel();
            final EtchedBorder etchedBorder = new EtchedBorder();
            final EmptyBorder emptyBorder = new EmptyBorder(etchedBorder.getBorderInsets(new JLabel()));
            jLabel.setBorder(emptyBorder);
            jLabel.setForeground(this.foreground);
            jLabel.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ DatePopup this$1;
                {
                    this.this$1 = datePopup;
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.this$1.calendar.add(n, n2);
                    this.this$1.updatePopup();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setBorder(etchedBorder);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setBorder(emptyBorder);
                }
            });
            return jLabel;
        }

        protected void updatePopup() {
            int n;
            int n2;
            this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar calendar = (Calendar)this.calendar.clone();
            calendar.set(7, calendar.getFirstDayOfWeek());
            for (n2 = 0; n2 < 7; ++n2) {
                n = calendar.get(7);
                JLabel jLabel = new JLabel();
                jLabel.setHorizontalAlignment(0);
                jLabel.setForeground(this.foreground);
                if (n == 1) {
                    jLabel.setText("Sun");
                } else if (n == 2) {
                    jLabel.setText("Mon");
                } else if (n == 3) {
                    jLabel.setText("Tue");
                } else if (n == 4) {
                    jLabel.setText("Wed");
                } else if (n == 5) {
                    jLabel.setText("Thu");
                } else if (n == 6) {
                    jLabel.setText("Fri");
                } else if (n == 7) {
                    jLabel.setText("Sat");
                }
                this.days.add(jLabel);
                calendar.roll(7, true);
            }
            calendar = (Calendar)this.calendar.clone();
            calendar.set(5, 1);
            n2 = calendar.get(7);
            for (n = 0; n < n2 - 1; ++n) {
                this.days.add(new JLabel(""));
            }
            n = 1;
            while (n <= calendar.getActualMaximum(5)) {
                final int n3 = n++;
                final JLabel jLabel = new JLabel(String.valueOf(n3));
                jLabel.setHorizontalAlignment(0);
                jLabel.setForeground(this.foreground);
                jLabel.addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ DatePopup this$1;
                    {
                        this.this$1 = datePopup;
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        jLabel.setOpaque(false);
                        jLabel.setBackground(this.this$1.background);
                        jLabel.setForeground(this.this$1.foreground);
                        this.this$1.calendar.set(5, n3);
                        ((JComboBox)this.this$1.component).setSelectedItem(this.this$1.BreezeDateChooser.this.dateFormat.format(this.this$1.calendar.getTime()));
                        this.this$1.hide();
                        this.this$1.component.requestFocus();
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        jLabel.setOpaque(true);
                        jLabel.setBackground(this.this$1.selectedBackground);
                        jLabel.setForeground(this.this$1.selectedForeground);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        jLabel.setOpaque(false);
                        jLabel.setBackground(this.this$1.background);
                        jLabel.setForeground(this.this$1.foreground);
                    }
                });
                this.days.add(jLabel);
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }
    }
}

